/*
 * Decompiled with CFR 0.152.
 */
package util;

import amira.AmiraMeshEncoder;
import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.plugin.PlugIn;
import java.io.File;
import util.BatchOpener;
import util.LabelFilenameFilter;

public class Just_Certain_Labels
implements PlugIn {
    public void run(String string) {
        int n;
        String string2 = Macro.getOptions();
        String string3 = null;
        String string4 = null;
        int[] nArray = null;
        boolean[] blArray = new boolean[256];
        if (string2 == null) {
            IJ.error((String)"Currently this can only be called as macro with options.");
            return;
        }
        string3 = Macro.getValue((String)string2, (String)"source", null);
        if (string3 == null) {
            IJ.error((String)"No source directory specified. (Macro option 'source'.)");
            return;
        }
        File file = new File(string3);
        if (!file.exists() || !file.isDirectory()) {
            IJ.error((String)("The source (" + string3 + ") must both exist and be a directory. "));
            return;
        }
        string4 = Macro.getValue((String)string2, (String)"output", null);
        if (string4 == null) {
            IJ.error((String)"No output directory specified. (Macro option 'output'.)");
            return;
        }
        File file2 = new File(string4);
        if (!file2.exists() || !file2.isDirectory()) {
            IJ.error((String)("The output (" + string4 + ") must both exist and be a directory. "));
            return;
        }
        String string5 = Macro.getValue((String)string2, (String)"extension", null);
        String string6 = Macro.getValue((String)string2, (String)"labels", null);
        if (string6 == null) {
            IJ.error((String)"No labels to keep specified. (Macro option 'labels'.)");
            return;
        }
        String[] stringArray = string6.split(",");
        nArray = new int[stringArray.length];
        String string7 = null;
        for (n = 0; n < stringArray.length; ++n) {
            string7 = stringArray[n];
            try {
                nArray[n] = Integer.parseInt(string7);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                IJ.error((String)("Couldn't parse '" + string7 + "' as a label index."));
                return;
            }
        }
        for (n = 0; n < nArray.length; ++n) {
            blArray[nArray[n]] = true;
        }
        LabelFilenameFilter labelFilenameFilter = new LabelFilenameFilter(string5);
        File[] fileArray = file.listFiles(labelFilenameFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            File file3 = fileArray[i];
            String string8 = file3.getAbsolutePath();
            String string9 = file3.getName();
            System.out.println("Opening file: " + string8);
            System.out.println("Leaf name is: " + string9);
            ImagePlus[] imagePlusArray = BatchOpener.open(string8);
            if (imagePlusArray == null) {
                IJ.error((String)("Opening '" + string8 + "' failed."));
                return;
            }
            if (imagePlusArray.length != 1) {
                IJ.error((String)("The labels file must only have one channel: there are " + imagePlusArray.length + " in '" + string8));
                return;
            }
            ImagePlus imagePlus = imagePlusArray[0];
            int n2 = imagePlus.getType();
            if (n2 != 0 && n2 != 3) {
                IJ.error((String)("Something's wrong: '" + string8 + "' doesn't seem to be an 8 bit file."));
                return;
            }
            if (!AmiraParameters.isAmiraLabelfield(imagePlus)) {
                IJ.error((String)("The file '" + string8 + "' isn't an Amira labelfield!"));
                return;
            }
            int n3 = imagePlus.getWidth();
            int n4 = imagePlus.getHeight();
            int n5 = imagePlus.getStackSize();
            ImageStack imageStack = imagePlus.getStack();
            for (int j = 0; j < n5; ++j) {
                object = (byte[])imageStack.getPixels(j + 1);
                for (int k = 0; k < n3 * n4; ++k) {
                    int n6 = object[k] & 0xFF;
                    if (blArray[n6]) continue;
                    object[k] = 0;
                }
            }
            String string10 = file2.getAbsolutePath() + File.separator + string9;
            System.out.println("Would output to: " + string10);
            object = new AmiraMeshEncoder(string10);
            if (!((AmiraMeshEncoder)object).open()) {
                IJ.error((String)("Could not write " + string10));
                return;
            }
            if (!((AmiraMeshEncoder)object).write(imagePlus)) {
                IJ.error((String)("Error writing " + string10));
                return;
            }
            imagePlus.close();
        }
    }
}

