/*
 * Decompiled with CFR 0.152.
 */
package util;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.io.File;
import marchingcubes.ExportMesh_;
import util.BatchOpener;

public class Meshes_From_Label_File
implements PlugIn {
    public void run(String string) {
        String string2 = Macro.getOptions();
        String string3 = null;
        String string4 = null;
        if (string2 == null) {
            IJ.error((String)"Currently this can only be called as macro with options.");
            return;
        }
        string3 = Macro.getValue((String)string2, (String)"source", null);
        if (string3 == null) {
            IJ.error((String)"No source filename specified. (Macro option 'source'.)");
            return;
        }
        string4 = Macro.getValue((String)string2, (String)"output", null);
        if (string4 == null) {
            IJ.error((String)"No output directory specified. (Macro option 'output'.)");
            return;
        }
        File file = new File(string4);
        if (!file.exists() || !file.isDirectory()) {
            IJ.error((String)("The output (" + string4 + ") must both exist and be a directory. "));
            return;
        }
        ImagePlus imagePlus = BatchOpener.openFirstChannel(string3);
        if (imagePlus == null) {
            IJ.error((String)("File not found: " + string3));
            return;
        }
        int n = imagePlus.getType();
        if (n != 0 && n != 3) {
            IJ.error((String)("Something's wrong: '" + string3 + "' doesn't seem to be an 8 bit file."));
            return;
        }
        String[] stringArray = null;
        AmiraParameters amiraParameters = null;
        if (!AmiraParameters.isAmiraLabelfield(imagePlus)) {
            IJ.error((String)("The file '" + string3 + "' isn't an Amira labelfield!"));
            return;
        }
        amiraParameters = new AmiraParameters(imagePlus);
        stringArray = amiraParameters.getMaterialList();
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        int n4 = imagePlus.getStackSize();
        for (int i = 1; i < stringArray.length; ++i) {
            Object object;
            Object[] objectArray;
            Object object2;
            double[] dArray = amiraParameters.getMaterialColor(i);
            String string5 = stringArray[i];
            ImageStack imageStack = new ImageStack(n2, n3);
            ImageStack imageStack2 = imagePlus.getStack();
            for (int j = 0; j < n4; ++j) {
                object2 = new byte[n2 * n3];
                objectArray = (byte[])imageStack2.getPixels(j + 1);
                for (int k = 0; k < n2 * n3; ++k) {
                    int n5 = objectArray[k] & 0xFF;
                    if (n5 != i) continue;
                    object2[k] = -1;
                }
                object = new ByteProcessor(n2, n3);
                object.setPixels(object2);
                imageStack.addSlice("", (ImageProcessor)object);
            }
            ImagePlus imagePlus2 = new ImagePlus("", imageStack);
            object2 = new ExportMesh_();
            objectArray = new boolean[]{true, true, true};
            object = string4 + File.separator + dArray[0] + "_" + dArray[1] + "_" + dArray[2] + "_" + string5 + ".obj";
            ((ExportMesh_)object2).exportToMesh(imagePlus2, 128, 2, (boolean[])objectArray, (String)object);
            imagePlus2.close();
        }
    }
}

