/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;

public class ModelessQuestions
extends Dialog
implements ActionListener {
    protected static final int LABEL = 1;
    protected static final int CHECKBOX = 2;
    protected static final int RADIO = 3;
    protected static final int TEXTFIELD = 4;
    ArrayList<QuestionComponent> components;
    ImagePlus imagePlus;
    Hashtable<String, CheckboxGroup> checkboxGroups;
    ArrayList<Button> completingButtons = new ArrayList();
    int buttonPressed = -1;

    public ModelessQuestions(String string, ImagePlus imagePlus) {
        super((Frame)imagePlus.getWindow(), string, false);
        this.checkboxGroups = new Hashtable();
        this.components = new ArrayList();
        this.imagePlus = imagePlus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAnswers() {
        if (this.completingButtons.size() == 0) {
            IJ.error((String)"You must add some buttons to the ModelessQuestions object before calling waitForAnswers");
            return;
        }
        this.layOutDialog();
        try {
            System.out.println("About to synchronize");
            ModelessQuestions modelessQuestions = this;
            synchronized (modelessQuestions) {
                System.out.println("About to show");
                this.setVisible(true);
                System.out.println("About to wait");
                this.wait();
                System.out.println("Finished waiting");
            }
            System.out.println("After sychronized.");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void layOutDialog() {
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        block4: for (QuestionComponent object : this.components) {
            switch (object.type) {
                case 4: {
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 22;
                    panel.add((Component)new Label(object.key), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.anchor = 21;
                    panel.add(object.component, gridBagConstraints);
                    ++gridBagConstraints.gridy;
                    continue block4;
                }
                case 1: 
                case 2: 
                case 3: {
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridwidth = 2;
                    panel.add(object.component, gridBagConstraints);
                    ++gridBagConstraints.gridy;
                    continue block4;
                }
            }
            IJ.error((String)"BUG: Unkown component type.");
        }
        this.add((Component)panel, "Center");
        Panel panel2 = new Panel();
        panel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        for (Button button : this.completingButtons) {
            panel2.add((Component)button, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        this.add((Component)panel2, "South");
        this.pack();
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        System.out.println("In close(), about to synchronize");
        ModelessQuestions modelessQuestions = this;
        synchronized (modelessQuestions) {
            System.out.println("  In close(), about to notify()");
            this.notify();
        }
        System.out.println("In close(), after synchronized");
        this.setVisible(false);
        this.dispose();
    }

    public void addLabel(String string) {
        Label label = new Label(string);
        QuestionComponent questionComponent = new QuestionComponent(1, null, string, label);
        this.components.add(questionComponent);
    }

    public void addTextField(String string, int n, String string2) {
        TextField textField = new TextField(string, n);
        QuestionComponent questionComponent = new QuestionComponent(4, null, string2, textField);
        this.components.add(questionComponent);
    }

    public void addRadio(String string, String string2) {
        if (!this.checkboxGroups.containsKey(string)) {
            this.checkboxGroups.put(string, new CheckboxGroup());
        }
        CheckboxGroup checkboxGroup = this.checkboxGroups.get(string);
        Checkbox checkbox = new Checkbox(string2, false, checkboxGroup);
        QuestionComponent questionComponent = new QuestionComponent(3, string, string2, checkbox);
        this.components.add(questionComponent);
    }

    public void addCheckbox(String string) {
        Checkbox checkbox = new Checkbox(string, false);
        QuestionComponent questionComponent = new QuestionComponent(2, null, string, checkbox);
        this.components.add(questionComponent);
    }

    public void addCompletingButton(String string, String string2) {
        Button button = new Button(string2);
        button.addActionListener(this);
        this.completingButtons.add(button);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        for (int i = 0; i < this.completingButtons.size(); ++i) {
            if (object != this.completingButtons.get(i)) continue;
            this.buttonPressed = i;
        }
        this.close();
    }

    public int getCompletingButtonIndex() {
        return this.buttonPressed;
    }

    public class QuestionComponent {
        int type;
        String group;
        String key;
        Component component;

        public QuestionComponent(int n, String string, String string2, Component component) {
            this.type = n;
            this.group = string;
            this.key = string2;
            this.component = component;
        }
    }
}

