/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackMerge;
import ij.process.StackConverter;
import java.util.ArrayList;
import util.ModelessQuestions;
import vib.TransformedImage;

public class Overlay_Registered
implements PlugIn {
    public static ImageStack overlayToStack(ImagePlus imagePlus, ImagePlus imagePlus2) {
        int n;
        TransformedImage transformedImage = new TransformedImage(imagePlus, imagePlus2);
        float[] fArray = transformedImage.getValuesRange();
        imagePlus.getProcessor().setMinAndMax((double)fArray[0], (double)fArray[1]);
        imagePlus2.getProcessor().setMinAndMax((double)fArray[0], (double)fArray[1]);
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        int n4 = imagePlus.getStackSize();
        if (n2 != imagePlus2.getWidth() || n3 != imagePlus2.getHeight() || n4 != imagePlus2.getStackSize()) {
            IJ.error((String)("The dimensions of image stack " + imagePlus2.getTitle() + " do not match those of " + imagePlus.getTitle()));
            return null;
        }
        int n5 = imagePlus.getType();
        if (n5 != (n = imagePlus2.getType())) {
            IJ.error((String)"Can't overlay two images of different types.");
            return null;
        }
        float[] fArray2 = Overlay_Registered.getValuesRange(imagePlus);
        float[] fArray3 = Overlay_Registered.getValuesRange(imagePlus2);
        imagePlus.getProcessor().setMinAndMax((double)fArray2[0], (double)fArray2[1]);
        StackConverter stackConverter = new StackConverter(imagePlus);
        stackConverter.convertToGray8();
        imagePlus2.getProcessor().setMinAndMax((double)fArray3[0], (double)fArray3[1]);
        stackConverter = new StackConverter(imagePlus2);
        stackConverter.convertToGray8();
        RGBStackMerge rGBStackMerge = new RGBStackMerge();
        ImageStack imageStack = rGBStackMerge.mergeStacks(n2, n3, n4, imagePlus.getStack(), imagePlus2.getStack(), imagePlus.getStack(), true);
        return imageStack;
    }

    public static ImagePlus overlayToImagePlus(ImagePlus imagePlus, ImagePlus imagePlus2) {
        ImageStack imageStack = Overlay_Registered.overlayToStack(imagePlus, imagePlus2);
        ImagePlus imagePlus3 = new ImagePlus("Merged", imageStack);
        Calibration calibration = imagePlus.getCalibration();
        Calibration calibration2 = imagePlus2.getCalibration();
        if (calibration != null || calibration2 != null) {
            if (calibration != null) {
                if (!calibration.equals(calibration2)) {
                    IJ.error((String)"The calibrations of the two images differ");
                    return null;
                }
                imagePlus3.setCalibration(calibration);
            } else {
                IJ.error((String)"Calibration is set in one image but not the other.");
                return null;
            }
        }
        return imagePlus3;
    }

    public static float[] getValuesRange(ImagePlus imagePlus) {
        Object[] objectArray;
        int n = imagePlus.getStackSize();
        ImageStack imageStack = imagePlus.getStack();
        int n2 = imagePlus.getBitDepth();
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            if (8 == n2) {
                objectArray = (byte[])imageStack.getPixels(i + 1);
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    n3 = objectArray[n4] & 0xFF;
                    if ((float)n3 > f2) {
                        f2 = n3;
                    }
                    if (!((float)n3 < f)) continue;
                    f = n3;
                }
                continue;
            }
            if (16 != n2) continue;
            objectArray = (short[])imageStack.getPixels(i + 1);
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                n3 = (int)objectArray[n4];
                if ((float)n3 > f2) {
                    f2 = n3;
                }
                if (!((float)n3 < f)) continue;
                f = n3;
            }
        }
        objectArray = new float[]{f, f2};
        return objectArray;
    }

    public void run(String string) {
        int n;
        ImagePlus[] imagePlusArray;
        Object object;
        Object object2;
        String string2 = Macro.getOptions();
        Object object3 = "";
        Object var4_4 = null;
        boolean bl = false;
        if (string2 != null) {
            object2 = Macro.getValue((String)string2, (String)"substring", null);
            if (object2 != null) {
                object3 = object2;
            }
            if ((object2 = (Object)Macro.getValue((String)string2, (String)"keep", null)) != null) {
                System.out.println("Got keep!: '" + (String)object2 + "'");
            }
            if ((object2 = (Object)Macro.getValue((String)string2, (String)"close", null)) != null) {
                System.out.println("Got close!: '" + (String)object2 + "'");
            }
        }
        if ((object2 = WindowManager.getIDList()) == null) {
            IJ.error((String)"No images are open.");
            return;
        }
        if (((int[])object2).length < 2) {
            IJ.error((String)"Must have at least two images open.");
            return;
        }
        ArrayList<ImagePlus[]> arrayList = new ArrayList<ImagePlus[]>();
        ArrayList<ImagePlus> arrayList2 = new ArrayList<ImagePlus>();
        ImagePlus[] imagePlusArray2 = new ImagePlus[((int[])object2).length];
        ImagePlus[] imagePlusArray3 = new ImagePlus[((int[])object2).length];
        boolean bl2 = false;
        for (int i = 0; i < ((int[])object2).length; ++i) {
            object = WindowManager.getImage((int)object2[i]);
            Object object4 = imagePlusArray = object != null ? object.getTitle() : "";
            if (imagePlusArray.indexOf((String)object3) >= 0) {
                System.out.println("Yes, matched: " + (String)imagePlusArray);
                arrayList.add(imagePlusArray);
                arrayList2.add((ImagePlus)object);
                continue;
            }
            System.out.println("No, didn't match '' in: " + (String)imagePlusArray);
        }
        if (arrayList.size() < 2) {
            IJ.error((String)("Fewer than two images matched the substring '" + (String)object3 + "'"));
            return;
        }
        GenericDialog genericDialog = new GenericDialog("Overlay Transformed");
        genericDialog.addChoice("A:", arrayList.toArray(new String[1]), (String)arrayList.get(0));
        genericDialog.addChoice("B:", arrayList.toArray(new String[1]), (String)arrayList.get(1));
        genericDialog.addCheckbox("Keep source images", true);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        object = new int[2];
        object[0] = (ImagePlus)genericDialog.getNextChoiceIndex();
        object[1] = (ImagePlus)genericDialog.getNextChoiceIndex();
        imagePlusArray = new ImagePlus[]{(ImagePlus)arrayList2.get((int)object[0]), (ImagePlus)arrayList2.get((int)object[1])};
        ImagePlus imagePlus = Overlay_Registered.overlayToImagePlus(imagePlusArray[0], imagePlusArray[1]);
        imagePlus.show();
        ModelessQuestions modelessQuestions = new ModelessQuestions("Rate This Registration", imagePlus);
        modelessQuestions.addTextField("I dunno", 20, "Your message:");
        modelessQuestions.addTextField("Well", 10, "Something");
        modelessQuestions.addLabel("Just a label.");
        modelessQuestions.addCompletingButton("ok", "Done");
        modelessQuestions.addCompletingButton("unhappy", "Rubbish!");
        for (n = 0; n <= 10; ++n) {
            modelessQuestions.addRadio("rating", "" + n);
        }
        modelessQuestions.waitForAnswers();
        IJ.error((String)"Finished waiting for answers!");
        if (bl) {
            for (n = 0; n < imagePlusArray3.length; ++n) {
                imagePlusArray3[n].close();
            }
        }
    }
}

