/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.YesNoCancelDialog;
import ij.io.DirectoryChooser;
import ij.io.FileSaver;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ColorModel;
import java.io.File;
import java.util.Random;
import util.BatchOpener;
import vib.app.FileGroup;
import vib.app.gui.FileGroupDialog;

public class Quantile_Based_Normalization
implements PlugIn,
ActionListener,
ItemListener {
    public static final String PLUGIN_VERSION = "1.2";
    TextField outputDirectoryInput;
    Button chooseOutputDirectory;
    Checkbox useMaskCheckbox;
    TextField maskFileInput;
    Button chooseMaskButton;

    public void processToDirectory(FileGroup fileGroup, String string, String string2, int n, int n2, boolean bl, boolean bl2) {
        int n3;
        long l;
        long l2;
        int n4;
        int n5;
        Replacements[] replacementsArray;
        int n6;
        Object object;
        int n7;
        int n8;
        Object object2;
        Object object3;
        Object object4;
        File file = new File(string);
        if (!file.exists()) {
            IJ.error((String)("The output directory ('" + string + "') doesn't exist."));
            return;
        }
        if (!file.isDirectory()) {
            IJ.error((String)("'" + string + "' is not a directory"));
            return;
        }
        boolean[][] blArray = null;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        long l3 = 0L;
        if (string2 != null) {
            IJ.showStatus((String)("Loading mask file: " + string2));
            ImagePlus[] imagePlusArray = BatchOpener.open(string2);
            if (imagePlusArray == null) {
                IJ.error((String)("Couldn't open the mask file: " + string2));
                return;
            }
            if (imagePlusArray.length != 1) {
                IJ.error((String)("The mask file must have one channel - " + string2 + " has " + imagePlusArray.length));
                return;
            }
            object4 = imagePlusArray[0];
            object3 = object4.getStack();
            n9 = object4.getWidth();
            n10 = object4.getHeight();
            n11 = object4.getStackSize();
            blArray = new boolean[n11][n9 * n10];
            for (int i = 0; i < n11; ++i) {
                object2 = (byte[])object3.getPixels(i + 1);
                for (n8 = 0; n8 < n10; ++n8) {
                    for (int j = 0; j < n9; ++j) {
                        if ((object2[n8 * n9 + j] & 0xFF) <= 127) continue;
                        blArray[i][n8 * n9 + j] = true;
                        ++l3;
                    }
                }
            }
            object4.close();
        }
        if ((n7 = fileGroup.size()) < 1) {
            IJ.error((String)"No image files selected");
            return;
        }
        object4 = new long[n7][256];
        object3 = new long[n7];
        long[][] lArray = new long[n7][n2];
        object2 = new long[n7][n2];
        for (n8 = 0; n8 < n7; ++n8) {
            Object[] objectArray;
            int n12;
            File file2 = (File)fileGroup.get(n8);
            String string3 = file2.getAbsolutePath();
            object = BatchOpener.open(string3);
            if (n >= ((ImagePlus[])object).length) {
                IJ.error((String)("There is no channel " + n + " in " + string3));
                return;
            }
            ImagePlus imagePlus = object[n];
            int n13 = imagePlus.getType();
            if (n13 != 0 && n13 != 3) {
                IJ.error((String)("Error processing '" + string3 + "': This plugin only works on 8bit (GRAY8 or COLOR_256) images."));
                return;
            }
            String string4 = IJ.freeMemory();
            System.out.println("free memory is: " + string4);
            int n14 = imagePlus.getWidth();
            n6 = imagePlus.getHeight();
            int n15 = imagePlus.getStackSize();
            if (string2 != null && (n14 != n9 || n6 != n10 || n15 != n11)) {
                IJ.error((String)("The image file " + string3 + " was not the same dimensions as the mask file"));
                return;
            }
            replacementsArray = imagePlus.getStack();
            IJ.showStatus((String)("Calculating frequencies and quantiles for " + imagePlus.getShortTitle() + " ..."));
            for (n12 = 0; n12 < n15; ++n12) {
                objectArray = (byte[])replacementsArray.getPixels(n12 + 1);
                for (int i = 0; i < n6; ++i) {
                    for (n5 = 0; n5 < n14; ++n5) {
                        if (string2 != null && !blArray[n12][i * n14 + n5]) continue;
                        int n16 = objectArray[i * n14 + n5] & 0xFF;
                        long[] lArray2 = object4[n8];
                        int n17 = n16;
                        lArray2[n17] = lArray2[n17] + 1L;
                    }
                }
            }
            object3[n8] = string2 == null ? (long)(n14 * n6 * n15) : l3;
            System.out.println("Proportion of points to consider: " + (double)l3 / (double)(n14 * n6 * n15));
            for (n12 = 0; n12 < n2; ++n12) {
                objectArray = new long[256];
                long l4 = (int)((long)n12 * object3[n8] / (long)n2);
                long l5 = (int)((long)(n12 + 1) * object3[n8] / (long)n2);
                long l6 = l5 - l4;
                if (n12 == n2 - 1) {
                    l5 = object3[n8];
                }
                long l7 = 0L;
                long l8 = 0L;
                lArray[n8][n12] = 0L;
                object2[n8][n12] = 0L;
                for (n4 = 0; n4 < object4[n8].length; ++n4) {
                    if ((l7 += object4[n8][n4]) >= l4 && l8 < l5) {
                        l2 = 0L;
                        if (l4 > l8) {
                            l2 = l4 - l8;
                        }
                        l = object4[n8][n4] - 1L;
                        if (l5 < l7) {
                            l = l5 - l8 - 1L;
                        }
                        long l9 = l - l2 + 1L;
                        long[] lArray3 = object2[n8];
                        int n18 = n12;
                        lArray3[n18] = lArray3[n18] + l9;
                        long[] lArray4 = lArray[n8];
                        int n19 = n12;
                        lArray4[n19] = lArray4[n19] + (long)n4 * l9;
                    }
                    l8 += object4[n8][n4];
                }
            }
            imagePlus.close();
        }
        System.out.println("Now going on to calculate the mean in each quantile.");
        double[] dArray = new double[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            long l10 = 0L;
            long l11 = 0L;
            for (int i = 0; i < n7; ++i) {
                l10 += lArray[i][n3];
                l11 += object2[i][n3];
            }
            dArray[n3] = (double)l10 / (double)l11;
        }
        for (n3 = 0; n3 < n7; ++n3) {
            YesNoCancelDialog yesNoCancelDialog;
            int n20;
            File file3 = (File)fileGroup.get(n3);
            object = file3.getAbsolutePath();
            ImagePlus[] imagePlusArray = BatchOpener.open((String)object);
            ImagePlus imagePlus = imagePlusArray[n];
            String string5 = file3.getName();
            n6 = string5.lastIndexOf(".");
            String string6 = n6 >= 0 ? string5.substring(0, n6) + "-normalized.tif" : string5 + "-normalized";
            File file4 = new File(string, string6);
            replacementsArray = new Replacements[256];
            for (int i = 0; i < 256; ++i) {
                replacementsArray[i] = new Replacements(256);
            }
            Replacements[] replacementsArray2 = new Replacements[256];
            for (n20 = 0; n20 < 256; ++n20) {
                replacementsArray2[n20] = new Replacements(n2);
            }
            n20 = imagePlus.getWidth();
            int n21 = imagePlus.getHeight();
            n5 = imagePlus.getStackSize();
            ImageStack imageStack = imagePlus.getStack();
            IJ.showStatus((String)("Replacing values in: " + imagePlus.getShortTitle() + " ..."));
            for (int i = 0; i < n2; ++i) {
                long[] lArray5 = new long[256];
                long l12 = (int)((long)i * object3[n3] / (long)n2);
                long l13 = (int)((long)(i + 1) * object3[n3] / (long)n2);
                long l14 = l13 - l12;
                if (i == n2 - 1) {
                    l13 = object3[n3];
                }
                l2 = 0L;
                l = 0L;
                for (int j = 0; j < object4[n3].length; ++j) {
                    if ((l2 += object4[n3][j]) >= l12 && l < l13) {
                        long l15 = 0L;
                        if (l12 > l) {
                            l15 = l12 - l;
                        }
                        long l16 = object4[n3][j] - 1L;
                        if (l13 < l2) {
                            l16 = l13 - l - 1L;
                        }
                        long l17 = l16 - l15 + 1L;
                        long[] lArray6 = object2[n3];
                        int n22 = i;
                        lArray6[n22] = lArray6[n22] + l17;
                        long[] lArray7 = lArray[n3];
                        int n23 = i;
                        lArray7[n23] = lArray7[n23] + (long)j * l17;
                        lArray5[j] = l17;
                    }
                    l += object4[n3][j];
                }
                double d = dArray[i];
                int n24 = (int)Math.floor(d);
                int n25 = (int)Math.ceil(d);
                double d2 = Math.ceil(d) - d;
                int n26 = (int)Math.round(d2 * (double)(l13 - l12));
                int n27 = (int)(object2[n3][i] - (long)n26);
                long l18 = 0L;
                for (int j = 0; j < 256; ++j) {
                    long l19 = lArray5[j];
                    if (l19 == 0L) continue;
                    long l20 = 0L;
                    long l21 = 0L;
                    if (l18 >= (long)n26) {
                        l21 = l19;
                    } else if (l18 + l19 >= (long)n26) {
                        l20 = (long)n26 - l18;
                        l21 = l19 - l20;
                    } else {
                        l20 = l19;
                    }
                    replacementsArray[j].addSomeReplacements(l20, n24);
                    replacementsArray[j].addSomeReplacements(l21, n25);
                    replacementsArray2[j].addSomeReplacements(l19, i);
                    l18 += l19;
                }
            }
            IJ.showProgress((double)0.0);
            ImageStack imageStack2 = new ImageStack(n20, n21);
            for (int i = 0; i < n5; ++i) {
                byte[] byArray = (byte[])imageStack.getPixels(i + 1);
                byte[] byArray2 = new byte[n20 * n21];
                for (int j = 0; j < n21; ++j) {
                    for (int k = 0; k < n20; ++k) {
                        if (string2 != null && !blArray[i][j * n20 + k]) continue;
                        int n28 = byArray[j * n20 + k] & 0xFF;
                        if (bl) {
                            n4 = replacementsArray2[n28].getRandomReplacement();
                            if (bl2) {
                                n4 = 255 * n4 / (n2 - 1);
                            }
                        } else {
                            n4 = replacementsArray[n28].getRandomReplacement();
                        }
                        if (n4 < 0) {
                            System.out.println("BUG: ran out of replacements for " + n28);
                            byArray2[j * n20 + k] = (byte)n28;
                            continue;
                        }
                        byArray2[j * n20 + k] = (byte)n4;
                    }
                }
                ByteProcessor byteProcessor = new ByteProcessor(n20, n21);
                byteProcessor.setPixels((Object)byArray2);
                imageStack2.addSlice("", (ImageProcessor)byteProcessor);
                IJ.showProgress((double)((double)i / (double)n5));
            }
            IJ.showProgress((double)1.0);
            if (3 == imagePlus.getType()) {
                ColorModel colorModel = null;
                colorModel = imageStack.getColorModel();
                if (colorModel != null) {
                    imageStack2.setColorModel(colorModel);
                }
            }
            ImagePlus imagePlus2 = new ImagePlus("normalized " + imagePlus.getTitle(), imageStack2);
            imagePlus2.setCalibration(imagePlus.getCalibration());
            if (file4.exists() && !(yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Confirm", "The file " + file4.getAbsolutePath() + " already exists.  Overwrite it?")).yesPressed()) {
                if (yesNoCancelDialog.cancelPressed()) {
                    IJ.showStatus((String)"Quantile based normalization cancelled.");
                    imagePlus2.close();
                    return;
                }
                imagePlus2.close();
                continue;
            }
            boolean bl3 = new FileSaver(imagePlus2).saveAsTiffStack(file4.getAbsolutePath());
            if (!bl3) {
                return;
            }
            imagePlus2.close();
            imagePlus.close();
        }
        IJ.showStatus((String)("Normalization complete: files written to: " + string));
    }

    public void run(String string) {
        String[] stringArray = new String[]{};
        String string2 = "";
        String string3 = "";
        GenericDialog genericDialog = new GenericDialog("Quantile Based Normalization (version: 1.2)");
        FileGroup fileGroup = new FileGroup("foo");
        for (int i = 0; i < stringArray.length; ++i) {
            fileGroup.add(stringArray[i]);
        }
        FileGroupDialog fileGroupDialog = new FileGroupDialog(fileGroup, false);
        genericDialog.addPanel((Panel)fileGroupDialog);
        Panel panel = new Panel();
        panel.add(new Label("Output directory: "));
        this.outputDirectoryInput = new TextField(string2, 18);
        panel.add(this.outputDirectoryInput);
        this.chooseOutputDirectory = new Button("Choose ...");
        panel.add(this.chooseOutputDirectory);
        this.chooseOutputDirectory.addActionListener(this);
        genericDialog.addPanel(panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        this.useMaskCheckbox = new Checkbox("Use an image mask?");
        this.useMaskCheckbox.addItemListener(this);
        panel2.add((Component)this.useMaskCheckbox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        panel2.add((Component)new Label("(If you use a mask, all images must be the same dimensions."), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        panel2.add((Component)new Label("Mask file: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.maskFileInput = new TextField(string3, 18);
        this.maskFileInput.setEnabled(false);
        panel2.add((Component)this.maskFileInput, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.chooseMaskButton = new Button("Choose...");
        this.chooseMaskButton.setEnabled(false);
        panel2.add((Component)this.chooseMaskButton, gridBagConstraints);
        genericDialog.addPanel(panel2);
        genericDialog.addNumericField("Number of channel to use (starting at 1): ", 1.0, 0);
        genericDialog.addNumericField("Quantiles", 256.0, 0);
        String[] stringArray2 = new String[]{"mean", "rank"};
        genericDialog.addChoice("Replace each quantile with", stringArray2, "mean");
        genericDialog.addCheckbox("Rescale (if replacing with ranks)", true);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        String string4 = this.outputDirectoryInput.getText();
        boolean bl = this.useMaskCheckbox.getState();
        String string5 = null;
        if (bl) {
            string5 = this.maskFileInput.getText();
        }
        int n = (int)genericDialog.getNextNumber();
        --n;
        int n2 = (int)genericDialog.getNextNumber();
        if (n2 < 1 || n2 > 256) {
            IJ.error((String)"Number of quantiles must be between 1 and 256 inclusive.");
            return;
        }
        boolean bl2 = false;
        String string6 = genericDialog.getNextChoice();
        bl2 = string6.equals("rank");
        boolean bl3 = genericDialog.getNextBoolean();
        this.processToDirectory(fileGroup, string4, string5, n, n2, bl2, bl3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.chooseOutputDirectory) {
            DirectoryChooser directoryChooser = new DirectoryChooser("Choose output directory...");
            String string = directoryChooser.getDirectory();
            if (string != null) {
                this.outputDirectoryInput.setText(string);
            }
        } else if (object == this.chooseMaskButton) {
            OpenDialog openDialog = new OpenDialog("Select mask image file...", null, null);
            String string = openDialog.getFileName();
            String string2 = openDialog.getDirectory();
            if (string == null) {
                return;
            }
            String string3 = string2 + string;
            File file = new File(string3);
            if (file.exists()) {
                this.maskFileInput.setText(string3);
            } else {
                IJ.error((String)("The chosen mask file (" + string3 + ") doesn't exist."));
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.useMaskCheckbox) {
            boolean bl = this.useMaskCheckbox.getState();
            this.maskFileInput.setEnabled(bl);
            this.chooseMaskButton.setEnabled(bl);
        }
    }

    class Replacements {
        long[] replacements;
        long totalReplacements;
        int minReplacement = Integer.MAX_VALUE;
        int maxReplacement = Integer.MIN_VALUE;
        Random rng;
        int quantile;

        public Replacements(int n) {
            this.replacements = new long[n];
            this.rng = new Random();
        }

        public void addSomeReplacements(long l, int n) {
            if (n < this.minReplacement) {
                this.minReplacement = n;
            }
            if (n > this.maxReplacement) {
                this.maxReplacement = n;
            }
            int n2 = n;
            this.replacements[n2] = this.replacements[n2] + l;
            this.totalReplacements += l;
        }

        public int getRandomReplacement() {
            if (this.totalReplacements == 0L) {
                return -1;
            }
            long l = Math.abs(this.rng.nextLong()) % this.totalReplacements;
            long l2 = 0L;
            for (int i = this.minReplacement; i <= this.maxReplacement; ++i) {
                long l3 = l - l2;
                if (l3 < this.replacements[i]) {
                    int n = i;
                    this.replacements[n] = this.replacements[n] - 1L;
                    --this.totalReplacements;
                    return i;
                }
                l2 += this.replacements[i];
            }
            return -1;
        }

        public String toString() {
            if (this.totalReplacements == 0L) {
                return "No replacements left.";
            }
            String string = "" + this.totalReplacements + " replacements left (in";
            for (int i = this.minReplacement; i <= this.maxReplacement; ++i) {
                if (this.replacements[i] <= 0L) continue;
                string = string + " " + i + " (" + this.replacements[i] + ")";
            }
            return string;
        }
    }
}

