/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Panel;
import java.io.File;
import java.util.Arrays;
import process3d.Distance_Transform_3D;
import util.BatchOpener;
import util.ImageCalculatorRevised;
import vib.app.FileGroup;
import vib.app.gui.FileGroupDialog;

public class RohlfingSBA
implements PlugIn {
    private FileGroup fg;
    private ImagePlus D_min;
    private ImagePlus output;
    private int w;
    private int h;
    private int d;
    private int L;
    private int K;

    public void run(String string) {
        GenericDialog genericDialog = new GenericDialog("Rohlfing");
        this.fg = new FileGroup("files");
        FileGroupDialog fileGroupDialog = new FileGroupDialog(this.fg, false);
        genericDialog.addPanel((Panel)fileGroupDialog);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.init();
        this.doit();
    }

    ImagePlus calculate(ImagePlus imagePlus, String string, ImagePlus imagePlus2) {
        String string2 = string + " 32 stack";
        ImageCalculatorRevised imageCalculatorRevised = new ImageCalculatorRevised();
        return imageCalculatorRevised.calculateResult(string2, imagePlus, imagePlus2);
    }

    public void setFileGroup(FileGroup fileGroup) {
        this.fg = fileGroup;
    }

    public ImagePlus doit() {
        ImagePlus imagePlus = null;
        IJ.showProgress((double)0.0);
        for (int i = 0; i < this.L; ++i) {
            Object object;
            Object object2;
            int n;
            System.out.println("At level " + i);
            for (n = 0; n < this.K; ++n) {
                System.out.println("  Doing image " + n);
                if (imagePlus == null) {
                    imagePlus = this.d_kl(i, n);
                } else {
                    object2 = this.d_kl(i, n);
                    object = this.calculate(imagePlus, "add", (ImagePlus)object2);
                    imagePlus.close();
                    object2.close();
                    imagePlus = object;
                }
                IJ.showProgress((double)((double)(i * this.K + n) / (double)(this.L * this.K)));
            }
            for (n = 0; n < this.d; ++n) {
                imagePlus.getStack().getProcessor(n + 1).multiply(1.0 / (double)this.K);
                object2 = (float[])imagePlus.getStack().getProcessor(n + 1).getPixels();
                object = (float[])this.D_min.getStack().getProcessor(n + 1).getPixels();
                byte[] byArray = (byte[])this.output.getStack().getProcessor(n + 1).getPixels();
                for (int j = 0; j < this.w * this.h; ++j) {
                    if (!(object2[j] < object[j])) continue;
                    byArray[j] = (byte)i;
                    object[j] = object2[j];
                }
            }
        }
        IJ.showProgress((double)1.0);
        this.output.show();
        return this.output;
    }

    private ImagePlus d_kl(int n, int n2) {
        File file = (File)this.fg.get(n2);
        ImagePlus imagePlus = BatchOpener.openFirstChannel(file.getAbsolutePath());
        ImagePlus imagePlus2 = this.createBinary(imagePlus, n);
        imagePlus.close();
        ImagePlus imagePlus3 = new Distance_Transform_3D().getTransformed(imagePlus2, 0);
        ImagePlus imagePlus4 = new Distance_Transform_3D().getTransformed(imagePlus2, 255);
        imagePlus2.close();
        ImagePlus imagePlus5 = this.calculate(imagePlus4, "sub", imagePlus3);
        imagePlus3.close();
        imagePlus4.close();
        return imagePlus5;
    }

    private ImagePlus createBinary(ImagePlus imagePlus, int n) {
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getWidth();
        int n4 = imagePlus.getStackSize();
        ImageStack imageStack = new ImageStack(n2, n3);
        for (int i = 0; i < n4; ++i) {
            byte[] byArray = new byte[n2 * n3];
            byte[] byArray2 = (byte[])imagePlus.getStack().getProcessor(i + 1).getPixels();
            for (int j = 0; j < n2 * n3; ++j) {
                byArray[j] = (byArray2[j] & 0xFF) == n ? -1 : 0;
            }
            imageStack.addSlice("", (ImageProcessor)new ByteProcessor(n2, n3, byArray, null));
        }
        return new ImagePlus("Label_" + (n & 0xFF), imageStack);
    }

    public void init() {
        int n;
        File file = (File)this.fg.get(0);
        ImagePlus imagePlus = BatchOpener.openFirstChannel(file.getAbsolutePath());
        this.w = imagePlus.getWidth();
        this.h = imagePlus.getHeight();
        this.d = imagePlus.getStackSize();
        imagePlus.close();
        this.L = 256;
        this.K = this.fg.size();
        ImageStack imageStack = new ImageStack(this.w, this.h);
        for (n = 0; n < this.d; ++n) {
            imageStack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h));
        }
        this.output = new ImagePlus("Output", imageStack);
        imageStack = new ImageStack(this.w, this.h);
        for (n = 0; n < this.d; ++n) {
            float[] fArray = new float[this.w * this.h];
            Arrays.fill(fArray, Float.MAX_VALUE);
            imageStack.addSlice("", (ImageProcessor)new FloatProcessor(this.w, this.h, fArray, null));
        }
        this.D_min = new ImagePlus("D_min", imageStack);
    }
}

