/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import math3d.Point3d;
import vib.FastMatrix;
import vib.InterpolatedImage;

public class AugmentedLandmarkWarp_
implements PlugInFilter {
    ImagePlus image;
    InterpolatedImage ii;
    InterpolatedImage model;
    int labelCount;
    FastMatrix[] matrix;
    Point3d[] center;
    private float x;
    private float y;
    private float z;

    public void run(ImageProcessor imageProcessor) {
        try {
            GenericDialog genericDialog = new GenericDialog("Transform Parameters");
            genericDialog.addStringField("Center of materials or label image", "", 15);
            if (!AmiraParameters.addAmiraMeshList(genericDialog, "Model")) {
                return;
            }
            genericDialog.addStringField("LabelTransformationList", "1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1");
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return;
            }
            this.ii = new InterpolatedImage(this.image);
            this.model = new InterpolatedImage(WindowManager.getImage((String)genericDialog.getNextChoice()));
            String string = genericDialog.getNextString();
            this.matrix = FastMatrix.parseMatrices(genericDialog.getNextString());
            ImagePlus imagePlus = WindowManager.getImage((String)string);
            if (imagePlus != null) {
                InterpolatedImage interpolatedImage = new InterpolatedImage(imagePlus);
                this.initCentersFromLabelField(interpolatedImage);
            } else {
                this.initCentersFromString(string);
            }
            this.run();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    void setCenter(Point3d[] point3dArray) {
        this.center = point3dArray;
        this.labelCount = point3dArray.length;
        this.adjustMatricesToPixelCoordinates();
    }

    void initCentersFromString(String string) {
        this.center = Point3d.parsePoints(string);
        if (this.center.length != this.matrix.length) {
            IJ.error((String)"Number of center points and matrices must agree");
        }
        this.labelCount = this.center.length;
        this.adjustMatricesToPixelCoordinates();
    }

    void initCentersFromLabelField(InterpolatedImage interpolatedImage) {
        int n;
        this.center = new Point3d[256];
        for (int i = 0; i < this.center.length; ++i) {
            this.center[i] = new Point3d();
        }
        long[] lArray = new long[256];
        InterpolatedImage.Iterator iterator = interpolatedImage.iterator(false);
        while (iterator.next() != null) {
            n = interpolatedImage.getNoInterpol(iterator.i, iterator.j, iterator.k);
            this.center[n].x += (double)iterator.i;
            this.center[n].y += (double)iterator.j;
            this.center[n].z += (double)iterator.k;
            int n2 = n;
            lArray[n2] = lArray[n2] + 1L;
        }
        this.labelCount = 256;
        while (this.labelCount > 1 && lArray[this.labelCount - 1] == 0L) {
            --this.labelCount;
        }
        for (n = 0; n < this.labelCount; ++n) {
            if (lArray[n] > 0L) {
                this.center[n].x /= (double)lArray[n];
                this.center[n].y /= (double)lArray[n];
                this.center[n].z /= (double)lArray[n];
                continue;
            }
            this.matrix[n] = null;
        }
        this.adjustMatricesToPixelCoordinates();
    }

    private void adjustMatricesToPixelCoordinates() {
        FastMatrix fastMatrix = FastMatrix.fromCalibration(this.ii.image);
        FastMatrix fastMatrix2 = FastMatrix.fromCalibration(this.model.image).inverse();
        for (int i = 1; i < this.matrix.length; ++i) {
            if (this.matrix[i] == null) continue;
            this.matrix[i] = fastMatrix2.times(this.matrix[i].inverse().times(fastMatrix));
        }
    }

    void transCoord(int n, int n2, int n3) {
        float f = 0.0f;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        for (int i = 0; i < this.labelCount; ++i) {
            if (this.matrix[i] == null) continue;
            this.matrix[i].apply(n, n2, n3);
            double d = this.matrix[i].x;
            double d2 = this.matrix[i].y;
            double d3 = this.matrix[i].z;
            int n4 = (int)Math.round(this.center[i].x - (double)n);
            int n5 = (int)Math.round(this.center[i].y - (double)n2);
            int n6 = (int)Math.round(this.center[i].z - (double)n3);
            float f2 = n4 * n4 + n5 * n5 + n6 * n6;
            f2 = 1.0f / (f2 + 0.01f);
            this.x = (float)((double)this.x + d * (double)f2);
            this.y = (float)((double)this.y + d2 * (double)f2);
            this.z = (float)((double)this.z + d3 * (double)f2);
            f += f2;
        }
        this.x /= f;
        this.y /= f;
        this.z /= f;
    }

    void run() {
        InterpolatedImage.Iterator iterator = this.ii.iterator(true);
        while (iterator.next() != null) {
            this.transCoord(iterator.i, iterator.j, iterator.k);
            this.ii.set(iterator.i, iterator.j, iterator.k, (int)this.model.interpol.get(this.x, this.y, this.z));
        }
        new AmiraParameters(this.model.image).setParameters(this.ii.image, false);
        this.ii.image.updateAndDraw();
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 3;
    }
}

