/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Vector;
import vib.FastMatrix;
import vib.InterpolatedImage;
import vib.TransformedImage;
import vib.VIB;

public class AverageBrain_
implements PlugInFilter {
    ImagePlus image;
    int[][] cumul;
    int w;
    int h;
    int d;
    int count;

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Transform Parameters");
        genericDialog.addStringField("files", "");
        genericDialog.addStringField("matrices", "");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        String[] stringArray = genericDialog.getNextString().split(",");
        FastMatrix[] fastMatrixArray = FastMatrix.parseMatrices(genericDialog.getNextString());
        this.doit(this.image, stringArray, fastMatrixArray);
    }

    public void doit(ImagePlus imagePlus, String[] stringArray, FastMatrix[] fastMatrixArray) {
        int n = this.count = "".equals(stringArray[0]) ? 0 : stringArray.length;
        if (this.count != fastMatrixArray.length) {
            IJ.error((String)("Count mismatch: " + this.count + " files, but " + fastMatrixArray.length + " matrices!"));
            return;
        }
        int n2 = this.count;
        InterpolatedImage interpolatedImage = new InterpolatedImage(imagePlus);
        this.w = interpolatedImage.w;
        this.h = interpolatedImage.h;
        this.d = interpolatedImage.d;
        this.cumul = new int[interpolatedImage.d][interpolatedImage.w * interpolatedImage.h];
        boolean bl = !imagePlus.getProcessor().isColorLut();
        Method method = bl ? new AverageGray() : new AverageLabels();
        method.cumul = this.cumul;
        if (!bl) {
            AmiraParameters amiraParameters = new AmiraParameters(imagePlus);
            amiraParameters.changeLabelfieldToGray();
            amiraParameters.setParameters(imagePlus);
        }
        for (int i = 0; i < this.count; ++i) {
            VIB.showStatus("Brain (" + (i + 1) + "/" + this.count + ")");
            ImagePlus imagePlus2 = IJ.openImage((String)stringArray[i]);
            if (imagePlus2 == null) {
                --n2;
                continue;
            }
            method.t = new TransformedImage(imagePlus, imagePlus2);
            method.t.setTransformation(fastMatrixArray[i]);
            method.isIdentity = method.t.matrix.isIdentity();
            TransformedImage.Iterator iterator = method.t.iterator();
            while (iterator.next() != null) {
                method.accumulate(iterator.i, iterator.j, iterator.k, iterator.x, iterator.y, iterator.z);
            }
            method.t = null;
            imagePlus2.close();
        }
        method.count = n2 < 1 ? 1 : n2;
        InterpolatedImage.Iterator iterator = interpolatedImage.iterator();
        while (iterator.next() != null) {
            interpolatedImage.set(iterator.i, iterator.j, iterator.k, method.get(iterator.i, iterator.j, iterator.k));
        }
    }

    private static byte physicsLUTHelper(double d) {
        double d2 = Math.sin(d);
        if (d2 < 0.0) {
            return 0;
        }
        return (byte)Math.round(255.0 * d2);
    }

    private static void setPhysicsLUT(ImagePlus imagePlus) {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        int n = 100;
        for (int i = 0; i <= n; ++i) {
            double d = (double)i * Math.PI / (double)(n / 2);
            byArray[i] = AverageBrain_.physicsLUTHelper(d + Math.PI);
            byArray2[i] = AverageBrain_.physicsLUTHelper(d - 1.5707963267948966);
            byArray3[i] = AverageBrain_.physicsLUTHelper(d);
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        imagePlus.getProcessor().setColorModel((ColorModel)indexColorModel);
        if (imagePlus.getStackSize() > 1) {
            imagePlus.getStack().setColorModel((ColorModel)indexColorModel);
        }
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 3;
    }

    public static void main(String[] stringArray) {
        Tuple tuple = new Tuple(5, 1, 3);
        Tuple tuple2 = new Tuple(tuple, 5);
        Tuple tuple3 = new Tuple(tuple, 3);
        Tuple tuple4 = new Tuple(tuple, 2);
        Tuple tuple5 = new Tuple(tuple2, 5);
        Tuple tuple6 = new Tuple(tuple2, 3);
        System.err.println("3(1) 5(1) : " + tuple);
        System.err.println("5(2) 3(1) : " + tuple2);
        System.err.println("3(2) 5(1) : " + tuple3);
        System.err.println("3(1) 5(1) 2(1) : " + tuple4);
        System.err.println("5(3) 3(1) : " + tuple5);
        System.err.println("5(2) 3(2) : " + tuple6);
    }

    static class Tuple {
        byte[] labels = new byte[256];
        int[] counts = new int[256];

        public Tuple(int n, int n2, int n3) {
            if (n2 == 1 && n3 < n) {
                int n4 = n3;
                n3 = n;
                n = n4;
            }
            this.labels[0] = (byte)n;
            this.counts[0] = n2;
            this.labels[1] = (byte)n3;
            this.counts[1] = 1;
        }

        public Tuple(Tuple tuple, int n) {
            int n2;
            int n3;
            System.arraycopy(tuple.labels, 0, this.labels, 0, this.labels.length);
            System.arraycopy(tuple.counts, 0, this.counts, 0, this.counts.length);
            for (n3 = 0; n3 < this.labels.length && this.labels[n3] != n && this.labels[n3] != 0; ++n3) {
            }
            if (this.labels[n3] == 0) {
                this.labels[n3] = (byte)n;
            }
            for (n2 = n3 - 1; n2 >= 0 && this.counts[n2] == this.counts[n3]; --n2) {
            }
            if (++n2 < n3) {
                int n4 = this.counts[n3];
                System.arraycopy(this.labels, n2, this.labels, n2 + 1, n3 - n2);
                System.arraycopy(this.counts, n2, this.counts, n2 + 1, n3 - n2);
                this.labels[n2] = (byte)n;
                this.counts[n2] = n4;
                n3 = n2;
            }
            int n5 = n3;
            this.counts[n5] = this.counts[n5] + 1;
        }

        public boolean equals(Tuple tuple) {
            for (int i = 0; i == 0 || this.labels[i - 1] != 0; ++i) {
                if (this.labels[i] == tuple.labels[i] && this.counts[i] == tuple.counts[i]) continue;
                return false;
            }
            return true;
        }

        public int getIndex(Vector vector) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                if (!this.equals((Tuple)vector.get(i))) continue;
                return i;
            }
            vector.add(this);
            return n;
        }

        public String toString() {
            String string = "";
            for (int i = 0; i < 256 && this.labels[i] != 0; ++i) {
                string = string + "" + this.labels[i] + "(" + this.counts[i] + ") ";
            }
            return string;
        }
    }

    class AverageLabels
    extends Method {
        byte[][] labels;
        Vector[] tuples;
        static final int maxProb = 100;

        public AverageLabels() {
            this.labels = new byte[AverageBrain_.this.d][AverageBrain_.this.w * AverageBrain_.this.h];
            this.tuples = new Vector[256];
            for (int i = 0; i < 256; ++i) {
                this.tuples[i] = new Vector();
            }
        }

        public void accumulate(int n, int n2, int n3, double d, double d2, double d3) {
            int n4 = this.t.transform.getNearestByte(d, d2, d3);
            if (n4 == 0) {
                return;
            }
            int n5 = n4 < 0 ? 256 + n4 : n4;
            int n6 = this.labels[n3][n + n2 * AverageBrain_.this.w];
            if (n6 < 0) {
                n6 += 256;
            }
            int n7 = this.cumul[n3][n + n2 * AverageBrain_.this.w];
            if (n6 == 0) {
                this.labels[n3][n + n2 * AverageBrain_.this.w] = n4;
                this.cumul[n3][n + n2 * AverageBrain_.this.w] = 1;
            } else if (n6 == n5 && n7 > 0) {
                int[] nArray = this.cumul[n3];
                int n8 = n + n2 * AverageBrain_.this.w;
                nArray[n8] = nArray[n8] + 1;
            } else {
                Tuple tuple;
                if (n7 > 0) {
                    tuple = new Tuple(n6, n7, n5);
                } else {
                    Tuple tuple2 = (Tuple)this.tuples[n6].get(-n7);
                    tuple = new Tuple(tuple2, n5);
                }
                if (tuple.labels[0] != (byte)n6) {
                    n6 = tuple.labels[0];
                    this.labels[n3][n + n2 * AverageBrain_.this.w] = (byte)n6;
                    if (n6 < 0) {
                        n6 += 256;
                    }
                }
                this.cumul[n3][n + n2 * AverageBrain_.this.w] = -tuple.getIndex(this.tuples[n6]);
            }
        }

        public int get(int n, int n2, int n3) {
            int n4;
            int n5 = this.labels[n3][n + n2 * AverageBrain_.this.w];
            if (n5 == 0) {
                return 0;
            }
            if (n5 < 0) {
                n5 += 256;
            }
            if ((n4 = this.cumul[n3][n + n2 * AverageBrain_.this.w]) <= 0) {
                Tuple tuple = (Tuple)this.tuples[n5].get(-n4);
                n4 = tuple.counts[0];
            }
            return n4 * 100 / this.count;
        }
    }

    class AverageGray
    extends Method {
        AverageGray() {
        }

        public void accumulate(int n, int n2, int n3, double d, double d2, double d3) {
            if (this.isIdentity) {
                int[] nArray = this.cumul[n3];
                int n4 = n + n2 * AverageBrain_.this.w;
                nArray[n4] = nArray[n4] + this.t.transform.getNoInterpol(n, n2, n3);
                return;
            }
            double d4 = this.t.transform.interpol.get(d, d2, d3);
            int[] nArray = this.cumul[n3];
            int n5 = n + n2 * AverageBrain_.this.w;
            nArray[n5] = nArray[n5] + (int)d4;
        }

        public int get(int n, int n2, int n3) {
            return this.cumul[n3][n + n2 * AverageBrain_.this.w] / this.count;
        }
    }

    abstract class Method {
        boolean isIdentity = false;
        TransformedImage t;
        int[][] cumul;
        int count;

        Method() {
        }

        public abstract void accumulate(int var1, int var2, int var3, double var4, double var6, double var8);

        public abstract int get(int var1, int var2, int var3);
    }
}

