/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.Macro;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BatchLog_
implements PlugIn {
    static TextArea area;
    public static boolean alwaysShowWindow;
    static String logFile;
    static DateFormat dateFormat;
    static String hostName;

    public void run(String string) {
        if (string.equals("")) {
            string = Macro.getOptions();
        }
        if (string.startsWith("logfile:")) {
            logFile = string.substring(8).trim();
            dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                inetAddress = InetAddress.getByName(inetAddress.getHostAddress());
                hostName = inetAddress.getHostName();
            }
            catch (Exception exception) {
                hostName = "<unnamed>";
            }
            return;
        }
        string = string + "\n";
        BatchLog_.appendText(string);
        if (logFile != null) {
            try {
                FileWriter fileWriter = new FileWriter(logFile, true);
                string = dateFormat.format(new Date()) + " (" + hostName + "): " + string;
                fileWriter.write(string);
                fileWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception);
            }
        }
    }

    public static final void appendText(String string) {
        if (alwaysShowWindow || Interpreter.isBatchMode()) {
            if (area == null) {
                area = new TextArea(25, 80);
                area.setText(string);
                area.setEditable(false);
                area.setVisible(true);
                final Frame frame = new Frame("Log");
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        area = null;
                        frame.dispose();
                    }
                });
                frame.add(area);
                frame.setSize(new Dimension(400, 300));
                frame.doLayout();
                frame.setVisible(true);
                area.setCaretPosition(Integer.MAX_VALUE);
            } else {
                area.append(string);
            }
        } else {
            IJ.showStatus((String)string);
        }
    }

    static {
        alwaysShowWindow = true;
    }
}

