/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Deformable_Registration
implements PlugIn {
    private ImagePlus model;
    private ImagePlus template;
    private byte[][] modelP;
    private byte[][] templateP;
    private int w;
    private int h;
    private int d;
    private GradientField gf;
    private DisplacementField df;
    private static final float LAMBDA = 100.0f;
    private static final int ITERATIONS = 100;
    private static final int STARTLEVEL = 1;
    private static final int STOPLEVEL = 1;
    private int level = 1;

    public void run(String string) {
        int[] nArray = WindowManager.getIDList();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = WindowManager.getImage((int)nArray[i]).getTitle();
        }
        GenericDialog genericDialog = new GenericDialog("Deformable Registration");
        genericDialog.addChoice("Model: ", stringArray, stringArray[0]);
        genericDialog.addChoice("Template: ", stringArray, stringArray[0]);
        genericDialog.addCheckbox("Load displacement", false);
        genericDialog.addCheckbox("Register", true);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.model = WindowManager.getImage((String)genericDialog.getNextChoice());
        this.template = WindowManager.getImage((String)genericDialog.getNextChoice());
        this.init();
        if (genericDialog.getNextBoolean()) {
            this.df.load(0);
            this.df.load(1);
            this.df.load(2);
        }
        if (genericDialog.getNextBoolean()) {
            this.register();
        }
        this.apply();
    }

    private float A(int n, int n2, int n3) {
        return this.templateP[n3][n2 * this.w + n] & 0xFF;
    }

    private float interpolate(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, int n) {
        float f12 = f - (float)((int)f / n);
        float f13 = f2 - (float)((int)f2 / n);
        float f14 = f3 - (float)((int)f3 / n);
        float f15 = f4 * ((float)n - f14) + f8 * f14;
        float f16 = f6 * ((float)n - f14) + f10 * f14;
        float f17 = f5 * ((float)n - f14) + f9 * f14;
        float f18 = f7 * ((float)n - f14) + f11 * f14;
        float f19 = f15 * ((float)n - f13) + f16 * f13;
        float f20 = f17 * ((float)n - f13) + f18 * f13;
        return f19 * ((float)n - f12) + f20 * f12;
    }

    private float interpolate(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        return this.interpolate(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, 1);
    }

    private float B(int n, int n2, int n3) {
        float f = (float)n3 + this.df.u(n, n2, n3, 0);
        float f2 = (float)n2 + this.df.u(n, n2, n3, 1);
        float f3 = (float)n + this.df.u(n, n2, n3, 2);
        int n4 = (int)f3;
        int n5 = (int)f2;
        int n6 = (int)f;
        return this.interpolate(f3, f2, f, this.getB(n4, n5, n6), this.getB(n4 + this.level, n5, n6), this.getB(n4, n5 + this.level, n6), this.getB(n4 + this.level, n5 + this.level, n6), this.getB(n4, n5, n6 + this.level), this.getB(n4 + this.level, n5, n6 + this.level), this.getB(n4, n5 + this.level, n6 + this.level), this.getB(n4 + this.level, n5 + this.level, n6 + this.level), this.level);
    }

    private float getB(int n, int n2, int n3) {
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.d) {
            n3 = this.d - 1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= this.w) {
            n = this.w - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.h) {
            n2 = this.h - 1;
        }
        return this.modelP[n3][n2 * this.w + n] & 0xFF;
    }

    private final void update(int n, int n2, int n3, int n4) {
        float f = this.gf.g(n, n2, n3, n4);
        float f2 = 100.0f * this.df.del2u(n, n2, n3, n4) - (this.B(n, n2, n3) - this.A(n, n2, n3)) * f;
        this.df.add(n, n2, n3, n4, f2 / (100.0f + f * f));
        for (int i = 0; i < this.level; ++i) {
            for (int j = 0; j < this.level; ++j) {
                for (int k = 0; k < this.level; ++k) {
                    this.df.set(n + k, n2 + j, n3 + i, n4, this.df.u(n, n2, n3, n4));
                }
            }
        }
    }

    private void register() {
        int n = 100;
        while (this.level >= 1) {
            IJ.showStatus((String)("Level " + this.level));
            this.registerLevel(n);
            n *= 2;
            this.level /= 2;
        }
        this.level = 1;
    }

    private void registerLevel(int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= this.d - this.level; j += this.level) {
                for (int k = 0; k <= this.h - this.level; k += this.level) {
                    for (int i2 = 0; i2 <= this.w - this.level; i2 += this.level) {
                        for (int i3 = 0; i3 < 3; ++i3) {
                            this.update(i2, k, j, i3);
                        }
                    }
                }
            }
            IJ.showProgress((int)i, (int)n);
        }
    }

    private void apply() {
        ImageStack imageStack = new ImageStack(this.w, this.h);
        byte[][] byArray = new byte[this.d][this.w * this.h];
        for (int i = 0; i < this.d; ++i) {
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.w; ++k) {
                    byArray[i][j * this.w + k] = (byte)this.B(k, j, i);
                }
            }
            imageStack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h, byArray[i], null));
        }
        new ImagePlus("result", imageStack).show();
        this.df.show(0);
        this.df.show(1);
        this.df.show(2);
    }

    private void init() {
        this.w = this.template.getWidth();
        this.h = this.template.getHeight();
        this.d = this.template.getStackSize();
        this.templateP = new byte[this.d][];
        this.modelP = new byte[this.d][];
        for (int i = 0; i < this.d; ++i) {
            this.templateP[i] = (byte[])this.template.getStack().getProcessor(i + 1).getPixels();
            this.modelP[i] = (byte[])this.model.getStack().getProcessor(i + 1).getPixels();
        }
        this.gf = new GradientField();
        this.df = new DisplacementField();
    }

    private class GradientField {
        private float[][][] g;

        private GradientField() {
            this.g = new float[3][Deformable_Registration.this.d][Deformable_Registration.this.w * Deformable_Registration.this.h];
            this.gradX();
            this.gradY();
            this.gradZ();
        }

        private float g(int n, int n2, int n3, int n4) {
            float f = (float)n3 + Deformable_Registration.this.df.u(n, n2, n3, 0);
            float f2 = (float)n2 + Deformable_Registration.this.df.u(n, n2, n3, 1);
            float f3 = (float)n + Deformable_Registration.this.df.u(n, n2, n3, 2);
            int n5 = (int)f3;
            int n6 = (int)f2;
            int n7 = (int)f;
            return Deformable_Registration.this.interpolate(f3, f2, f, this.getG(n5, n6, n7, n4), this.getG(n5 + Deformable_Registration.this.level, n6, n7, n4), this.getG(n5, n6 + Deformable_Registration.this.level, n7, n4), this.getG(n5 + Deformable_Registration.this.level, n6 + Deformable_Registration.this.level, n7, n4), this.getG(n5, n6, n7 + Deformable_Registration.this.level, n4), this.getG(n5 + Deformable_Registration.this.level, n6, n7 + Deformable_Registration.this.level, n4), this.getG(n5, n6 + Deformable_Registration.this.level, n7 + Deformable_Registration.this.level, n4), this.getG(n5 + Deformable_Registration.this.level, n6 + Deformable_Registration.this.level, n7 + Deformable_Registration.this.level, n4), Deformable_Registration.this.level);
        }

        private float getG(int n, int n2, int n3, int n4) {
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 >= Deformable_Registration.this.d) {
                n3 = Deformable_Registration.this.d - 1;
            }
            if (n < 0) {
                n = 0;
            }
            if (n >= Deformable_Registration.this.w) {
                n = Deformable_Registration.this.w - 1;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= Deformable_Registration.this.h) {
                n2 = Deformable_Registration.this.h - 1;
            }
            return this.g[n4][n3][n2 * Deformable_Registration.this.w + n];
        }

        private void gradX() {
            for (int i = 0; i < Deformable_Registration.this.d; ++i) {
                byte[] byArray = (byte[])Deformable_Registration.this.model.getStack().getProcessor(i + 1).getPixels();
                for (int j = 0; j < Deformable_Registration.this.h; ++j) {
                    this.g[2][i][j * ((Deformable_Registration)Deformable_Registration.this).w] = (byArray[j * Deformable_Registration.this.w + 1] & 0xFF) - (byArray[j * Deformable_Registration.this.w] & 0xFF);
                    for (int k = 1; k < Deformable_Registration.this.w - 1; ++k) {
                        this.g[2][i][j * ((Deformable_Registration)Deformable_Registration.this).w + k] = (float)((byArray[j * Deformable_Registration.this.w + k + 1] & 0xFF) - (byArray[j * Deformable_Registration.this.w + k - 1] & 0xFF)) / 2.0f;
                    }
                    this.g[2][i][j * ((Deformable_Registration)Deformable_Registration.this).w + ((Deformable_Registration)Deformable_Registration.this).w - 1] = (byArray[j * Deformable_Registration.this.w + Deformable_Registration.this.w - 1] & 0xFF) - (byArray[j * Deformable_Registration.this.w + Deformable_Registration.this.w - 2] & 0xFF);
                }
            }
        }

        private void gradY() {
            for (int i = 0; i < Deformable_Registration.this.d; ++i) {
                int n;
                byte[] byArray = (byte[])Deformable_Registration.this.model.getStack().getProcessor(i + 1).getPixels();
                for (n = 0; n < Deformable_Registration.this.w; ++n) {
                    this.g[1][i][n] = (byArray[Deformable_Registration.this.w + n] & 0xFF) - (byArray[n] & 0xFF);
                }
                for (n = 1; n < Deformable_Registration.this.h - 1; ++n) {
                    for (int j = 0; j < Deformable_Registration.this.w; ++j) {
                        this.g[1][i][n * ((Deformable_Registration)Deformable_Registration.this).w + j] = (float)((byArray[(n + 1) * Deformable_Registration.this.w + j] & 0xFF) - (byArray[(n - 1) * Deformable_Registration.this.w + j] & 0xFF)) / 2.0f;
                    }
                }
                for (n = 0; n < Deformable_Registration.this.w; ++n) {
                    this.g[1][i][(((Deformable_Registration)Deformable_Registration.this).h - 1) * ((Deformable_Registration)Deformable_Registration.this).w + n] = (byArray[(Deformable_Registration.this.h - 1) * Deformable_Registration.this.w + n] & 0xFF) - (byArray[(Deformable_Registration.this.h - 2) * Deformable_Registration.this.w + n] & 0xFF);
                }
            }
        }

        private void gradZ() {
            int n;
            ImageStack imageStack = Deformable_Registration.this.model.getStack();
            byte[] byArray = (byte[])imageStack.getProcessor(1).getPixels();
            byte[] byArray2 = (byte[])imageStack.getProcessor(2).getPixels();
            for (n = 0; n < Deformable_Registration.this.w * Deformable_Registration.this.h; ++n) {
                this.g[0][0][n] = (byArray2[n] & 0xFF) - (byArray[n] & 0xFF);
            }
            for (n = 1; n < Deformable_Registration.this.d - 1; ++n) {
                byte[] byArray3 = (byte[])imageStack.getProcessor(n).getPixels();
                byArray = (byte[])imageStack.getProcessor(n + 1).getPixels();
                byArray2 = (byte[])imageStack.getProcessor(n + 2).getPixels();
                for (int i = 0; i < Deformable_Registration.this.w * Deformable_Registration.this.h; ++i) {
                    this.g[0][n][i] = (float)((byArray2[i] & 0xFF) - (byArray3[i] & 0xFF)) / 2.0f;
                }
            }
            byte[] byArray4 = (byte[])imageStack.getProcessor(Deformable_Registration.this.d - 1).getPixels();
            byArray = (byte[])imageStack.getProcessor(Deformable_Registration.this.d).getPixels();
            for (int i = 0; i < Deformable_Registration.this.w * Deformable_Registration.this.h; ++i) {
                this.g[0][((Deformable_Registration)Deformable_Registration.this).d - 1][i] = (byArray[i] & 0xFF) - (byArray4[i] & 0xFF);
            }
        }
    }

    private class DisplacementField {
        private float[][][] u;

        private DisplacementField() {
            this.u = new float[3][Deformable_Registration.this.d][Deformable_Registration.this.w * Deformable_Registration.this.h];
        }

        private float u(int n, int n2, int n3, int n4) {
            return this.u[n4][n3][n2 * Deformable_Registration.this.w + n];
        }

        private void add(int n, int n2, int n3, int n4, float f) {
            float[] fArray = this.u[n4][n3];
            int n5 = n2 * Deformable_Registration.this.w + n;
            fArray[n5] = fArray[n5] + f;
        }

        private void set(int n, int n2, int n3, int n4, float f) {
            this.u[n4][n3][n2 * ((Deformable_Registration)Deformable_Registration.this).w + n] = f;
        }

        private void show(int n) {
            ImageStack imageStack = new ImageStack(Deformable_Registration.this.w, Deformable_Registration.this.h);
            for (int i = 0; i < Deformable_Registration.this.d; ++i) {
                imageStack.addSlice("", (ImageProcessor)new FloatProcessor(Deformable_Registration.this.w, Deformable_Registration.this.h, this.u[n][i], null));
            }
            new ImagePlus("Displacement_dim" + n, imageStack).show();
        }

        private void load(int n) {
            ImagePlus imagePlus = WindowManager.getImage((String)("Displacement_dim" + n));
            if (imagePlus == null) {
                return;
            }
            for (int i = 0; i < Deformable_Registration.this.d; ++i) {
                this.u[n][i] = (float[])imagePlus.getStack().getProcessor(i + 1).getPixels();
            }
        }

        private float del2u(int n, int n2, int n3, int n4) {
            int n5 = n3 >= Deformable_Registration.this.level ? n3 - Deformable_Registration.this.level : n3 + Deformable_Registration.this.level;
            int n6 = n >= Deformable_Registration.this.level ? n - Deformable_Registration.this.level : n + Deformable_Registration.this.level;
            int n7 = n2 >= Deformable_Registration.this.level ? n2 - Deformable_Registration.this.level : n2 + Deformable_Registration.this.level;
            int n8 = n3 < Deformable_Registration.this.d - Deformable_Registration.this.level ? n3 + Deformable_Registration.this.level : n3 - Deformable_Registration.this.level;
            int n9 = n < Deformable_Registration.this.w - Deformable_Registration.this.level ? n + Deformable_Registration.this.level : n - Deformable_Registration.this.level;
            int n10 = n2 < Deformable_Registration.this.h - Deformable_Registration.this.level ? n2 + Deformable_Registration.this.level : n2 - Deformable_Registration.this.level;
            return (this.u[n4][n3][n2 * Deformable_Registration.this.w + n9] + this.u[n4][n3][n2 * Deformable_Registration.this.w + n6] + this.u[n4][n3][n10 * Deformable_Registration.this.w + n] + this.u[n4][n3][n7 * Deformable_Registration.this.w + n] + this.u[n4][n8][n2 * Deformable_Registration.this.w + n] + this.u[n4][n5][n2 * Deformable_Registration.this.w + n]) / 6.0f - this.u[n4][n3][n2 * Deformable_Registration.this.w + n];
        }

        private final void interpolateU() {
            for (int i = 0; i <= Deformable_Registration.this.d - 2 * Deformable_Registration.this.level; i += Deformable_Registration.this.level) {
                for (int j = 0; j <= Deformable_Registration.this.h - 2 * Deformable_Registration.this.level; j += Deformable_Registration.this.level) {
                    for (int k = 0; k <= Deformable_Registration.this.w - 2 * Deformable_Registration.this.level; k += Deformable_Registration.this.level) {
                        for (int i2 = 0; i2 < 3; ++i2) {
                            this.interpolateU(k, j, i, i2);
                        }
                    }
                }
            }
        }

        private final void interpolateU(int n, int n2, int n3, int n4) {
            for (int i = 0; i < Deformable_Registration.this.level; ++i) {
                for (int j = 0; j < Deformable_Registration.this.level; ++j) {
                    for (int k = 0; k < Deformable_Registration.this.level; ++k) {
                        this.u[n4][n3 + i][(n2 + j) * ((Deformable_Registration)Deformable_Registration.this).w + n + k] = Deformable_Registration.this.interpolate(n + k, n2 + j, n3 + i, this.u[n4][n3][n2 * Deformable_Registration.this.w + n], this.u[n4][n3][n2 * Deformable_Registration.this.w + n + Deformable_Registration.this.level], this.u[n4][n3][(n2 + Deformable_Registration.this.level) * Deformable_Registration.this.w + n], this.u[n4][n3][(n2 + Deformable_Registration.this.level) * Deformable_Registration.this.w + n + Deformable_Registration.this.level], this.u[n4][n3 + Deformable_Registration.this.level][n2 * Deformable_Registration.this.w + n], this.u[n4][n3 + Deformable_Registration.this.level][n2 + Deformable_Registration.this.level + n + Deformable_Registration.this.level], this.u[n4][n3 + Deformable_Registration.this.level][(n2 + Deformable_Registration.this.level) * Deformable_Registration.this.w + n], this.u[n4][n3 + Deformable_Registration.this.level][(n2 + Deformable_Registration.this.level) * Deformable_Registration.this.w + n + Deformable_Registration.this.level]);
                    }
                }
            }
        }
    }
}

