/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;

public class EdgeDetectors_
implements PlugInFilter {
    ImagePlus image;
    static final double[][] isotropic = new double[][]{{-1.0, -1.4142135623731, -1.0}, {0.0, 0.0, 0.0}, {1.0, 1.4142135623731, 1.0}};
    static double[][] roberts = new double[][]{{0.0, -1.0}, {1.0, 0.0}};
    static double[][] prewitt = new double[][]{{-1.0, -1.0, -1.0}, {0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
    static double[][] sobel = new double[][]{{-1.0, -2.0, -1.0}, {0.0, 0.0, 0.0}, {1.0, 2.0, 1.0}};

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Parameters");
        String[] stringArray = new String[]{"Roberts", "Prewitt", "Sobel", "Isotropic"};
        genericDialog.addChoice("detector", stringArray, "Sobel");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n = genericDialog.getNextChoiceIndex();
        double[][] dArray = n == 0 ? roberts : (n == 1 ? prewitt : (n == 2 ? sobel : isotropic));
        int n2 = n == 0 ? 2 : 3;
        double[][] dArray2 = new double[n2][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = n2 == 2 ? dArray[1 - i][j] : dArray[j][i];
            }
        }
        ImageStack imageStack = this.image.getStack();
        ImageStack imageStack2 = new ImageStack(imageStack.getWidth(), imageStack.getHeight());
        for (int i = 1; i <= imageStack.getSize(); ++i) {
            imageStack2.addSlice("", (ImageProcessor)this.doit(imageStack.getProcessor(i), dArray, dArray2, n2));
        }
        new ImagePlus("Edges" + n, imageStack2).show();
    }

    private ByteProcessor doit(ImageProcessor imageProcessor, double[][] dArray, double[][] dArray2, int n) {
        int n2;
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        double[] dArray3 = new double[n3 * n4];
        double d = -1.0E9;
        double d2 = 1.0E9;
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                float f = 0.0f;
                float f2 = 0.0f;
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < n; ++k) {
                        if (i + j - 1 < 0 || i + j - 1 >= n3 || n2 + k - 1 < 0 || n2 + k - 1 >= n4) continue;
                        float f3 = imageProcessor.getPixel(i + j - 1, n2 + k - 1);
                        f = (float)((double)f + dArray[j][k] * (double)f3);
                        f2 = (float)((double)f2 + dArray2[j][k] * (double)f3);
                    }
                }
                dArray3[i + n3 * n2] = Math.abs(f) + Math.abs(f2);
                if (dArray3[i + n3 * n2] > d) {
                    d = dArray3[i + n3 * n2];
                }
                if (!(dArray3[i + n3 * n2] < d2)) continue;
                d2 = dArray3[i + n3 * n2];
            }
        }
        byte[] byArray = new byte[n3 * n4];
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < n4; ++i) {
                byArray[n2 + n3 * i] = (byte)((dArray3[n2 + n3 * i] - d2) * 255.999 / (d - d2));
            }
        }
        ByteProcessor byteProcessor = new ByteProcessor(n3, n4, byArray, null);
        return byteProcessor;
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 13;
    }
}

