/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij3d.Image3DUniverse;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import math3d.NormalEstimator;
import math3d.Point3d;
import vib.DoubleArray;
import vib.IntArray;
import vib.InterpolatedImage;

public class Extract_Surface
implements PlugInFilter {
    ImagePlus image;
    InterpolatedImage ii;
    Calibration calib;
    Map surfaceVoxels = new TreeMap();
    Vector vertices = new Vector();
    Set vertexCandidates;
    double maxDev2;
    Point3f[] normals;
    Map edges;
    static int lineMeshCount = 0;
    Vector connected;
    Map triangles;
    int triangleCount = 0;
    Image3DUniverse universe;
    int pointCount = 0;
    boolean verbose = true;
    int lowerThreshold;
    int upperThreshold;

    public void run(ImageProcessor imageProcessor) {
        this.calib = this.image.getCalibration();
        GenericDialog genericDialog = new GenericDialog("Transform Parameters");
        genericDialog.addNumericField("LowerThreshold", 1.0, 0);
        genericDialog.addNumericField("UpperThreshold", 255.0, 0);
        genericDialog.addNumericField("CullRadius", 6.0, 0);
        genericDialog.addStringField("outputFileName", "");
        genericDialog.addStringField("outputVRMLFileName", "");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.lowerThreshold = (int)genericDialog.getNextNumber();
        this.upperThreshold = (int)genericDialog.getNextNumber();
        double d = genericDialog.getNextNumber();
        String string = genericDialog.getNextString();
        String string2 = genericDialog.getNextString();
        this.maxDev2 = d * d;
        this.ii = new InterpolatedImage(this.image);
        IJ.showProgress((int)0, (int)6);
        IJ.showStatus((String)"find vertices");
        this.getAllVertices();
        IJ.showProgress((int)1, (int)6);
        IJ.showStatus((String)"reassociate vertices");
        this.reassociateVertices();
        IJ.showProgress((int)3, (int)6);
        IJ.showStatus((String)"get edges");
        this.getEdges();
        IJ.showProgress((int)4, (int)6);
        IJ.showStatus((String)"get triangles");
        this.getTriangles();
        IJ.showProgress((int)5, (int)6);
        IJ.showStatus((String)"show triangles");
        this.showTriangles(0xFF0000);
        IJ.showProgress((int)6, (int)6);
        if (!string2.equals("")) {
            this.saveWRL(string2);
        }
        if (!string.equals("")) {
            this.saveAsText(string);
        }
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 131;
    }

    public SurfaceVoxel getVertex(int n) {
        return (SurfaceVoxel)this.vertices.get(n);
    }

    public SurfaceVoxel getVoxel(int n, int n2, int n3) {
        SurfaceVoxel surfaceVoxel = new SurfaceVoxel(n, n2, n3);
        SurfaceVoxel surfaceVoxel2 = (SurfaceVoxel)this.surfaceVoxels.get(surfaceVoxel);
        if (surfaceVoxel2 != null) {
            return surfaceVoxel2;
        }
        this.surfaceVoxels.put(surfaceVoxel, surfaceVoxel);
        return surfaceVoxel;
    }

    public SurfaceVoxel getFirstPoint() {
        InterpolatedImage.Iterator iterator = this.ii.iterator();
        while (iterator.next() != null) {
            if (!this.testVoxel(iterator.i, iterator.j, iterator.k)) continue;
            SurfaceVoxel surfaceVoxel = this.getVoxel(iterator.i, iterator.j, iterator.k);
            this.surfaceVoxels.put(surfaceVoxel, surfaceVoxel);
            return surfaceVoxel;
        }
        return null;
    }

    public void addVertex(SurfaceVoxel surfaceVoxel) {
        Object object;
        int n = this.vertices.size();
        this.vertices.addElement(surfaceVoxel);
        NeighbourQueue neighbourQueue = new NeighbourQueue(surfaceVoxel);
        while (neighbourQueue.getDistance() < this.maxDev2) {
            object = neighbourQueue.pop();
            if (((SurfaceVoxel)object).vertexIndex >= 0) continue;
            ((SurfaceVoxel)object).setVertex(n);
        }
        object = neighbourQueue.iterator();
        while (object.hasNext()) {
            this.vertexCandidates.add(object.next());
        }
    }

    public void getAllVertices() {
        this.vertexCandidates = new TreeSet();
        SurfaceVoxel surfaceVoxel = this.getFirstPoint();
        if (surfaceVoxel == null) {
            throw new RuntimeException("Empty material!");
        }
        this.vertexCandidates.add(surfaceVoxel);
        block0: while (this.vertexCandidates.size() > 0) {
            Iterator iterator = this.vertexCandidates.iterator();
            while (iterator.hasNext()) {
                SurfaceVoxel surfaceVoxel2 = (SurfaceVoxel)iterator.next();
                if (surfaceVoxel2.vertexIndex < 0) {
                    this.addVertex(surfaceVoxel2);
                    continue block0;
                }
                iterator.remove();
            }
        }
    }

    void showAllPoints() {
        this.showAllPoints(false);
    }

    Color3f makeColor(int n) {
        return new Color3f((float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n & 0xFF) / 255.0f);
    }

    void showAllPoints(boolean bl) {
        this.showPoints(this.surfaceVoxels.keySet().iterator(), 0xFF0000);
    }

    void reassociateVertices() {
        for (int i = 0; i < this.vertices.size(); ++i) {
            SurfaceVoxel surfaceVoxel = (SurfaceVoxel)this.vertices.get(i);
            NeighbourQueue neighbourQueue = new NeighbourQueue(surfaceVoxel, false);
            while (neighbourQueue.size() > 0) {
                SurfaceVoxel surfaceVoxel2 = neighbourQueue.pop();
                if (surfaceVoxel2.vertexIndex != i) {
                    double d = surfaceVoxel2.distance2(surfaceVoxel);
                    if (d > surfaceVoxel2.distance) continue;
                    surfaceVoxel2.setVertex(i);
                }
                SurfaceVoxel.NeighbourIterator neighbourIterator = surfaceVoxel2.iterator();
                while (neighbourIterator.hasNext()) {
                    SurfaceVoxel surfaceVoxel3 = (SurfaceVoxel)neighbourIterator.next();
                    neighbourQueue.push(surfaceVoxel3);
                }
            }
        }
    }

    static Point3f Point3d2Point3f(Point3d point3d) {
        return new Point3f((float)point3d.x, (float)point3d.y, (float)point3d.z);
    }

    void getNormals() {
        this.normals = new Point3f[this.vertices.size()];
        for (int i = 0; i < this.normals.length; ++i) {
            SurfaceVoxel surfaceVoxel = this.getVertex(i);
            NeighbourQueue neighbourQueue = new NeighbourQueue(surfaceVoxel);
            NormalEstimator normalEstimator = new NormalEstimator();
            while (neighbourQueue.getDistance() < this.maxDev2) {
                SurfaceVoxel surfaceVoxel2 = neighbourQueue.pop();
                normalEstimator.add(surfaceVoxel2.getPoint3d());
            }
            this.normals[i] = Extract_Surface.Point3d2Point3f(normalEstimator.getNormal());
        }
    }

    void getEdges() {
        this.edges = new TreeMap();
        for (SurfaceVoxel surfaceVoxel : this.surfaceVoxels.keySet()) {
            SurfaceVoxel.NeighbourIterator neighbourIterator = surfaceVoxel.iterator();
            while (neighbourIterator.hasNext()) {
                SurfaceVoxel surfaceVoxel2 = (SurfaceVoxel)neighbourIterator.next();
                if (surfaceVoxel.vertexIndex == surfaceVoxel2.vertexIndex) continue;
                Edge edge = new Edge(surfaceVoxel.vertexIndex, surfaceVoxel2.vertexIndex);
                this.edges.put(edge, edge);
            }
        }
    }

    void showEdges(int n) {
        this.getUniverse();
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        for (Edge edge : this.edges.keySet()) {
            edge.addLineTo(arrayList);
        }
        this.universe.addLineMesh(arrayList, this.makeColor(n), "line" + lineMeshCount++, false);
    }

    void getTriangles() {
        IntArray intArray;
        this.connected = new Vector();
        this.connected.setSize(this.vertices.size());
        for (Edge edge : this.edges.keySet()) {
            intArray = (IntArray)this.connected.get(edge.a);
            if (intArray == null) {
                intArray = new IntArray();
                this.connected.set(edge.a, intArray);
            }
            if (!intArray.contains(edge.b)) {
                intArray.add(edge.b);
            }
            if ((intArray = (IntArray)this.connected.get(edge.b)) == null) {
                intArray = new IntArray();
                this.connected.set(edge.b, intArray);
            }
            if (intArray.contains(edge.a)) continue;
            intArray.add(edge.a);
        }
        this.triangles = new TreeMap();
        for (Edge edge : this.edges.keySet()) {
            intArray = (IntArray)this.connected.get(edge.a);
            IntArray intArray2 = (IntArray)this.connected.get(edge.b);
            for (int i = 0; i < intArray.size(); ++i) {
                int n = intArray.get(i);
                if (!intArray2.contains(n)) continue;
                Triangle triangle = new Triangle(edge.a, edge.b, n);
                this.triangles.put(triangle, triangle);
            }
        }
    }

    void showTriangles(int n) {
        this.getUniverse();
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        for (Triangle triangle : this.triangles.keySet()) {
            triangle.addTriangleTo(arrayList);
        }
        this.universe.addMesh(arrayList, this.makeColor(n), "mesh" + this.triangleCount++, 0);
    }

    void getUniverse() {
        if (this.universe != null) {
            return;
        }
        this.universe = new Image3DUniverse();
        this.universe.show();
    }

    void showPoints(Iterator iterator, int n) {
        this.getUniverse();
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Point3d point3d = null;
            point3d = e instanceof SurfaceVoxel ? ((SurfaceVoxel)e).getPoint3d() : (Point3d)e;
            float f = (this.ii.w + this.ii.h + this.ii.d) / 6;
            Point3f point3f = new Point3f((float)point3d.x, (float)point3d.y, (float)point3d.z - f);
            Point3f point3f2 = new Point3f((float)point3d.x - 0.5f * f, (float)point3d.y + 0.8f * f, (float)point3d.z + 0.3f * f);
            Point3f point3f3 = new Point3f((float)point3d.x - 0.5f * f, (float)point3d.y - 0.8f * f, (float)point3d.z + 0.3f * f);
            Point3f point3f4 = new Point3f((float)point3d.x + 0.8f * f, (float)point3d.y, (float)point3d.z + 0.3f * f);
            arrayList.add(point3f);
            arrayList.add(point3f2);
            arrayList.add(point3f3);
            arrayList.add(point3f4);
            arrayList.add(point3f2);
            arrayList.add(point3f3);
            arrayList.add(point3f);
            arrayList.add(point3f2);
            arrayList.add(point3f4);
            arrayList.add(point3f);
            arrayList.add(point3f3);
            arrayList.add(point3f4);
        }
        this.universe.addMesh(arrayList, this.makeColor(n), "point" + this.pointCount++, 0);
    }

    public void showSurfaceVoxels() {
        this.getUniverse();
        this.showPoints(this.surfaceVoxels.values().iterator(), -1);
    }

    boolean isWithinThresholds(int n, int n2, int n3) {
        int n4 = this.ii.getNoInterpol(n, n2, n3);
        return n4 < this.lowerThreshold || n4 > this.upperThreshold;
    }

    boolean testVoxel(int n, int n2, int n3) {
        if (!this.isWithinThresholds(n, n2, n3)) {
            return false;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (this.isWithinThresholds(n + k, n2 + j, n3 + i)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    void saveWRL(String string) {
        try {
            FileWriter fileWriter = new FileWriter(new File(string));
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(fileWriter));
            printWriter.println("#VRML V2.0 utf8\n\nTransform { children [ Shape {\n   appearance Appearance { material Material { diffuseColor 0.57 0.57 0.57 } }\n   geometry IndexedFaceSet { coord Coordinate { point [");
            for (Comparable comparable : this.vertices) {
                printWriter.println("    " + comparable.getPoint3d());
            }
            printWriter.println("  ] } coordIndex [");
            for (Comparable comparable : this.triangles.keySet()) {
                printWriter.println("    " + ((Triangle)comparable).a + ", " + ((Triangle)comparable).b + ", " + ((Triangle)comparable).c + ", -1,");
                printWriter.println("    " + ((Triangle)comparable).c + ", " + ((Triangle)comparable).b + ", " + ((Triangle)comparable).a + ", -1,");
            }
            if (this.normals != null) {
                printWriter.println("  ],\n  normal Normal {\n  vector [\n");
                for (int i = 0; i < this.normals.length; ++i) {
                    printWriter.println("    " + this.normals[i]);
                }
                printWriter.println("  ] } normalIndex [");
                for (Triangle triangle : this.triangles.keySet()) {
                    printWriter.println("    " + triangle.a + ", " + triangle.b + ", " + triangle.c + ", -1,");
                    printWriter.println("    " + triangle.c + ", " + triangle.b + ", " + triangle.a + ", -1,");
                }
            }
            printWriter.println("  ]\n  } }\n] }");
            printWriter.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    void saveAsText(String string) {
        try {
            SurfaceVoxel surfaceVoxel;
            int n;
            DecimalFormat decimalFormat = new DecimalFormat("0.###");
            FileWriter fileWriter = new FileWriter(new File(string));
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(fileWriter));
            printWriter.println("# vertices");
            printWriter.println("" + this.vertices.size());
            for (n = 0; n < this.vertices.size(); ++n) {
                surfaceVoxel = (SurfaceVoxel)this.vertices.get(n);
                printWriter.println(surfaceVoxel.getPoint3d());
            }
            printWriter.println("# normals");
            printWriter.println("" + this.normals.length);
            for (n = 0; n < this.normals.length; ++n) {
                surfaceVoxel = this.normals[n];
                printWriter.println(decimalFormat.format(((Point3f)surfaceVoxel).x) + " " + decimalFormat.format(((Point3f)surfaceVoxel).y) + " " + decimalFormat.format(((Point3f)surfaceVoxel).z));
            }
            printWriter.println("# triangles");
            printWriter.println("" + this.triangles.size());
            Iterator iterator = this.triangles.keySet().iterator();
            while (iterator.hasNext()) {
                printWriter.println(iterator.next());
            }
            printWriter.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    class Triangle
    implements Comparable {
        int a;
        int b;
        int c;

        public Triangle(int n, int n2, int n3) {
            int n4;
            if (n > n2) {
                n4 = n;
                n = n2;
                n2 = n4;
            }
            if (n2 > n3) {
                n4 = n2;
                n2 = n3;
                n3 = n4;
            }
            if (n > n2) {
                n4 = n;
                n = n2;
                n2 = n4;
            }
            this.a = n;
            this.b = n2;
            this.c = n3;
        }

        public boolean equals(Object object) {
            Triangle triangle = (Triangle)object;
            return this.a == triangle.a && this.b == triangle.b && this.c == triangle.c;
        }

        public int compareTo(Object object) {
            Triangle triangle = (Triangle)object;
            int n = this.a - triangle.a;
            if (n == 0 && (n = this.b - triangle.b) == 0) {
                n = this.c - triangle.c;
            }
            return n;
        }

        public String toString() {
            return "" + this.a + " " + this.b + " " + this.c;
        }

        public void addTriangleTo(List list) {
            list.add(Extract_Surface.this.getVertex(this.a).getPoint3f());
            list.add(Extract_Surface.this.getVertex(this.b).getPoint3f());
            list.add(Extract_Surface.this.getVertex(this.c).getPoint3f());
            list.add(Extract_Surface.this.getVertex(this.c).getPoint3f());
            list.add(Extract_Surface.this.getVertex(this.b).getPoint3f());
            list.add(Extract_Surface.this.getVertex(this.a).getPoint3f());
        }
    }

    class Edge
    implements Comparable {
        int a;
        int b;

        public Edge(int n, int n2) {
            if (n < n2) {
                this.a = n;
                this.b = n2;
            } else {
                if (n == n2) {
                    throw new RuntimeException("illegal edge " + n + " " + n2 + "!");
                }
                this.a = n2;
                this.b = n;
            }
        }

        public boolean equals(Object object) {
            Edge edge = (Edge)object;
            return this.a == edge.a && this.b == edge.b;
        }

        public int compareTo(Object object) {
            Edge edge = (Edge)object;
            int n = this.a - edge.a;
            if (n == 0) {
                n = this.b - edge.b;
            }
            return n;
        }

        public String toString() {
            return "" + this.a + " " + this.b;
        }

        public void addLineTo(List list) {
            list.add(Extract_Surface.this.getVertex(this.a).getPoint3f());
            list.add(Extract_Surface.this.getVertex(this.b).getPoint3f());
        }
    }

    static class NeighbourQueue {
        Point3d center;
        Vector queue;
        Set done;
        DoubleArray distances;
        boolean pushNeighboursAutomatically;

        public NeighbourQueue(SurfaceVoxel surfaceVoxel) {
            this(surfaceVoxel, true);
        }

        public NeighbourQueue(SurfaceVoxel surfaceVoxel, boolean bl) {
            this.pushNeighboursAutomatically = bl;
            this.center = surfaceVoxel.getPoint3d();
            this.queue = new Vector();
            this.distances = new DoubleArray();
            this.done = new TreeSet();
            this.push(surfaceVoxel);
        }

        public SurfaceVoxel pop() {
            int n = this.queue.size() - 1;
            SurfaceVoxel surfaceVoxel = (SurfaceVoxel)this.queue.get(n);
            this.queue.setSize(n);
            this.distances.setSize(n);
            if (this.pushNeighboursAutomatically) {
                SurfaceVoxel.NeighbourIterator neighbourIterator = surfaceVoxel.iterator();
                while (neighbourIterator.hasNext()) {
                    this.push((SurfaceVoxel)neighbourIterator.next());
                }
            }
            return surfaceVoxel;
        }

        public void push(SurfaceVoxel surfaceVoxel) {
            int n;
            if (this.done.contains(surfaceVoxel)) {
                return;
            }
            double d = this.center.distance2(surfaceVoxel.getPoint3d());
            for (n = 0; n < this.distances.size() && d < this.distances.get(n); ++n) {
            }
            this.distances.add(n, d);
            this.queue.add(n, surfaceVoxel);
            this.done.add(surfaceVoxel);
        }

        public boolean contains(SurfaceVoxel surfaceVoxel) {
            return this.queue.contains(surfaceVoxel);
        }

        public Iterator iterator() {
            return this.queue.iterator();
        }

        public int size() {
            return this.queue.size();
        }

        public double getDistance() {
            int n = this.size() - 1;
            if (n < 0) {
                return Double.MAX_VALUE;
            }
            return this.distances.get(n);
        }
    }

    class SurfaceVoxel
    implements Comparable {
        int i;
        int j;
        int k;
        int vertexIndex;
        double distance;
        Vector neighbours;

        public SurfaceVoxel(int n, int n2, int n3) {
            this.i = n;
            this.j = n2;
            this.k = n3;
            this.vertexIndex = -1;
        }

        public int hashCodeOld() {
            return this.i | this.j << 11 | this.k << 22;
        }

        public boolean equals(Object object) {
            SurfaceVoxel surfaceVoxel = (SurfaceVoxel)object;
            return this.i == surfaceVoxel.i && this.j == surfaceVoxel.j && this.k == surfaceVoxel.k;
        }

        public int compareTo(Object object) {
            SurfaceVoxel surfaceVoxel = (SurfaceVoxel)object;
            int n = this.i - surfaceVoxel.i;
            if (n == 0 && (n = this.j - surfaceVoxel.j) == 0) {
                n = this.k - surfaceVoxel.k;
            }
            return n;
        }

        public String toString() {
            return "" + this.i + " " + this.j + " " + this.k;
        }

        public Point3d getPoint3d() {
            return new Point3d(Extract_Surface.this.calib.xOrigin + (double)this.i * Extract_Surface.this.calib.pixelWidth, Extract_Surface.this.calib.yOrigin + (double)this.j * Extract_Surface.this.calib.pixelHeight, Extract_Surface.this.calib.zOrigin + (double)this.k * Extract_Surface.this.calib.pixelDepth);
        }

        public Point3f getPoint3f() {
            return new Point3f((float)(Extract_Surface.this.calib.xOrigin + (double)this.i * Extract_Surface.this.calib.pixelWidth), (float)(Extract_Surface.this.calib.yOrigin + (double)this.j * Extract_Surface.this.calib.pixelHeight), (float)(Extract_Surface.this.calib.zOrigin + (double)this.k * Extract_Surface.this.calib.pixelDepth));
        }

        public double distance2(SurfaceVoxel surfaceVoxel) {
            return this.getPoint3d().distance2(surfaceVoxel.getPoint3d());
        }

        public SurfaceVoxel getVertex() {
            if (this.vertexIndex < 0) {
                return null;
            }
            return (SurfaceVoxel)Extract_Surface.this.vertices.get(this.vertexIndex);
        }

        public void setVertex(int n) {
            this.vertexIndex = n;
            this.distance = this.distance2(this.getVertex());
        }

        public NeighbourIterator iterator() {
            return new NeighbourIterator();
        }

        public class NeighbourIterator
        implements Iterator {
            Iterator iter;

            NeighbourIterator() {
                if (SurfaceVoxel.this.neighbours == null) {
                    this.getNeighbours();
                }
                this.iter = SurfaceVoxel.this.neighbours.iterator();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.iter.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private final void getNeighbours() {
                SurfaceVoxel.this.neighbours = new Vector();
                for (int i = SurfaceVoxel.this.k - 1; i <= SurfaceVoxel.this.k + 1; ++i) {
                    for (int j = SurfaceVoxel.this.j - 1; j <= SurfaceVoxel.this.j + 1; ++j) {
                        for (int k = SurfaceVoxel.this.i - 1; k <= SurfaceVoxel.this.i + 1; ++k) {
                            this.getNeighbour(k, j, i);
                        }
                    }
                }
            }

            private final void getNeighbour(int n, int n2, int n3) {
                if (n3 == SurfaceVoxel.this.k && n2 == SurfaceVoxel.this.j && n == SurfaceVoxel.this.i) {
                    return;
                }
                if (!Extract_Surface.this.testVoxel(n, n2, n3)) {
                    return;
                }
                SurfaceVoxel.this.neighbours.add(Extract_Surface.this.getVoxel(n, n2, n3));
            }
        }
    }
}

