/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Pattern;
import pal.math.ConjugateDirectionSearch;
import pal.math.MultivariateFunction;
import util.BatchOpener;
import util.Quantile_Based_Normalization;
import vib.Bins;
import vib.ShellsCanvas;
import vib.app.FileGroup;

public class Fit_Sphere
implements PlugIn {
    public void run(String string) {
        Object object;
        Object object2;
        int n;
        int n2;
        Object object3;
        Object object4;
        int n3;
        Object object5;
        Object object6;
        int n4;
        double d;
        Object object7;
        double d2;
        String string2 = "/Users/mark/central-complex-complete-vib-protocol/output_1/71yAAeastmost.tif";
        String string3 = "/Users/mark/central-complex-complete-vib-protocol/normalized/";
        int[][][] nArrayArray = new int[][][]{new int[][]{{226, 450, 50}, {232, 526, 50}, {250, 364, 50}, {248, 564, 50}, {254, 360, 47}, {226, 420, 47}, {228, 506, 47}, {244, 544, 47}, {246, 376, 44}, {222, 456, 44}, {240, 530, 44}}, new int[][]{{270, 456, 50}, {298, 360, 50}, {290, 540, 50}, {292, 382, 47}, {268, 456, 47}, {284, 522, 47}, {280, 524, 44}, {266, 456, 44}, {290, 386, 44}}};
        int[] nArray = new int[]{294, 466, 43};
        int[] nArray2 = new int[]{294, 466, 49};
        int[] nArray3 = new int[]{234, 484, 42};
        int[] nArray4 = new int[]{234, 484, 50};
        ImagePlus[] imagePlusArray = BatchOpener.open(string2);
        if (imagePlusArray == null) {
            IJ.error((String)("Couldn't open: " + string2));
        }
        ImagePlus imagePlus = imagePlusArray[0];
        Calibration calibration = imagePlusArray[0].getCalibration();
        double d3 = calibration.pixelWidth;
        double d4 = calibration.pixelHeight;
        double d5 = calibration.pixelDepth;
        int n5 = imagePlus.getWidth();
        int n6 = imagePlus.getHeight();
        int n7 = imagePlus.getStackSize();
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = (double)nArray2[0] * d3;
        dArray[1] = (double)nArray2[1] * d4;
        dArray[2] = (double)nArray2[2] * d5;
        dArray2[0] = (double)nArray[0] * d3;
        dArray2[1] = (double)nArray[1] * d4;
        dArray2[2] = (double)nArray[2] * d5;
        ConjugateDirectionSearch conjugateDirectionSearch = new ConjugateDirectionSearch();
        conjugateDirectionSearch.step = 0.5;
        double[] dArray3 = new double[3];
        double d6 = 356.0 * d3;
        double d7 = 459.0 * d4;
        double d8 = 45.0 * d5;
        dArray3[0] = (double)n5 * d3 / 2.0;
        dArray3[1] = (double)n6 * d4 / 2.0;
        dArray3[2] = (double)n7 * d5 / 2.0;
        SphereAttempt sphereAttempt = new SphereAttempt(2);
        for (int i = 0; i < 2; ++i) {
            int[][] nArray5 = nArrayArray[i];
            for (int j = 0; j < nArray5.length; ++j) {
                sphereAttempt.addPointInShell(i, (double)nArray5[j][0] * d3, (double)nArray5[j][1] * d4, (double)nArray5[j][2] * d5);
            }
        }
        conjugateDirectionSearch.optimize(sphereAttempt, dArray3, 2.0, 2.0);
        double d9 = dArray3[0];
        double d10 = dArray3[1];
        double d11 = dArray3[2];
        double d12 = Math.atan((dArray[2] - d11) / (d9 - dArray[0]));
        double d13 = Math.atan((dArray2[2] - d11) / (d9 - dArray2[0]));
        System.out.println("maxAngle is " + d12 + " (in degrees: " + d12 * 180.0 / Math.PI + ")");
        System.out.println("minAngle is " + d13 + " (in degrees: " + d13 * 180.0 / Math.PI + ")");
        double[] dArray4 = new double[nArrayArray.length];
        for (int i = 0; i < nArrayArray.length; ++i) {
            double d14 = 0.0;
            int[][] nArray6 = nArrayArray[i];
            for (int j = 0; j < nArray6.length; ++j) {
                double d15 = (double)nArray6[j][0] * d3;
                double d16 = (double)nArray6[j][1] * d4;
                double d17 = (double)nArray6[j][2] * d5;
                double d18 = d15 - d9;
                double d19 = d16 - d10;
                double d20 = d17 - d11;
                d2 = Math.sqrt(d18 * d18 + d19 * d19 + d20 * d20);
                d14 += d2;
            }
            dArray4[i] = d14 / (double)nArray6.length;
        }
        double d21 = d9 / d3;
        double d22 = d10 / d4;
        double d23 = d11 / d5;
        double d24 = (int)d21;
        double d25 = (int)d22;
        double d26 = (int)d23;
        ShellsCanvas shellsCanvas = new ShellsCanvas(imagePlus, d9, d10, d11);
        for (int i = 0; i < dArray4.length; ++i) {
            shellsCanvas.addRadius(dArray4[i]);
        }
        new StackWindow(imagePlus, (ImageCanvas)shellsCanvas);
        imagePlus.show();
        String string4 = "/Users/mark/central-complex-complete-vib-protocol/fb-average.tif";
        ImagePlus[] imagePlusArray2 = BatchOpener.open(string4);
        if (imagePlusArray2 == null) {
            IJ.error((String)("Couldn't open: " + string4));
            return;
        }
        boolean[][] blArrayArray = new boolean[n7][];
        byte[][] byArray = new byte[n7][n5 * n6];
        d2 = 0.0;
        double d27 = Double.MAX_VALUE;
        ImagePlus imagePlus2 = imagePlusArray2[0];
        ImageStack imageStack = imagePlus2.getStack();
        int n8 = 127;
        for (int i = 0; i < n7; ++i) {
            byte[] byArray2 = (byte[])imageStack.getPixels(i + 1);
            object7 = new boolean[n5 * n6];
            for (int j = 0; j < n6; ++j) {
                for (int k = 0; k < n5; ++k) {
                    boolean bl;
                    d = (double)k * d3;
                    double d28 = (double)j * d4;
                    double d29 = (double)i * d5;
                    double d30 = d - d9;
                    double d31 = d28 - d10;
                    double d32 = d29 - d11;
                    double d33 = Math.atan(d32 / -d30);
                    if (d33 > d12 || (double)k >= d21) {
                        byArray[i][j * n5 + k] = -1;
                        continue;
                    }
                    if (d33 < d13 || (double)k >= d21) {
                        byArray[i][j * n5 + k] = -1;
                        continue;
                    }
                    n4 = byArray2[j * n5 + k] & 0xFF;
                    object7[j * n5 + k] = bl = n4 >= n8;
                    if (!bl) {
                        byArray[i][j * n5 + k] = -128;
                        continue;
                    }
                    double d34 = d30 * d30 + d31 * d31 + d32 * d32;
                    if (d34 > d2) {
                        d2 = d34;
                        continue;
                    }
                    if (!(d34 < d27)) continue;
                    d27 = d34;
                }
            }
            blArrayArray[i] = object7;
        }
        imagePlus2.close();
        ImageStack imageStack2 = new ImageStack(n5, n6);
        for (int i = 0; i < n7; ++i) {
            object7 = new ByteProcessor(n5, n6);
            object7.setPixels((Object)byArray[i]);
            imageStack2.addSlice("", (ImageProcessor)object7);
        }
        ImagePlus imagePlus3 = new ImagePlus("points excluded by angle", imageStack2);
        imagePlus3.show();
        boolean bl = false;
        double d35 = Math.sqrt(d2);
        d = Math.sqrt(d27);
        System.out.println("All distances between: " + d35 + " and " + d);
        String string5 = "/Users/mark/thesis/annotations-with-scores.csv";
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        System.out.println("Trying to load: " + string5);
        try {
            object6 = new BufferedReader(new FileReader(string5));
            int n9 = 0;
            while ((object5 = ((BufferedReader)object6).readLine()) != null) {
                if (++n9 == 1) continue;
                String[] stringArray = ((String)object5).split(",");
                String string6 = stringArray[2];
                String string7 = stringArray[3];
                try {
                    int n10 = Integer.parseInt(string7);
                    n3 = string6.lastIndexOf(".");
                    if (n3 > 0) {
                        string6 = string6.substring(0, n3);
                    }
                    System.out.println("got score " + string7 + " for file " + string6);
                    hashtable.put(string6, new Integer(n10));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("The score '" + string7 + "' wasn't an integer - skipping that one.");
                }
            }
        }
        catch (IOException iOException) {
            IJ.error((String)("Error parsing the file " + string5 + ": " + iOException));
            return;
        }
        object6 = new File("/Users/mark/central-complex-complete-vib-protocol/warped_2");
        object5 = new File("/Users/mark/central-complex-complete-vib-protocol/warped_1");
        Pattern[] patternArray = new Pattern[]{Pattern.compile("71y"), Pattern.compile("210y"), Pattern.compile("c0*5"), Pattern.compile("c0*61"), Pattern.compile("760"), Pattern.compile("(876|924)")};
        int n11 = 100;
        FileGroup[] fileGroupArray = new FileGroup[patternArray.length + 1];
        for (int i = 0; i < fileGroupArray.length; ++i) {
            fileGroupArray[i] = new FileGroup("group " + i);
        }
        Bins[] binsArray = new Bins[patternArray.length + 1];
        int n12 = 0;
        for (n3 = 0; n3 <= patternArray.length; ++n3) {
            binsArray[n3] = new Bins(n11, d, d35);
            Pattern pattern = n3 == patternArray.length ? Pattern.compile("^[a-zA-Z0-9][^/]+$") : patternArray[n3];
            System.out.println("Finding files matching: /" + pattern + "/");
            object4 = n3 == patternArray.length ? ((File)object5).listFiles() : ((File)object6).listFiles();
            for (n4 = 0; n4 < ((Bins[])object4).length; n4 += 1) {
                Bins bins = object4[n4];
                if (!pattern.matcher(((File)((Object)bins)).getName()).find()) continue;
                String string8 = ((File)((Object)bins)).getName();
                int n13 = string8.lastIndexOf(".");
                if (n13 >= 0) {
                    string8 = string8.substring(0, n13);
                }
                if ((object3 = (Integer)hashtable.get(string8)) != null) {
                    n2 = (Integer)object3;
                    System.out.println("... that had score " + n2);
                    if (n2 < 6) continue;
                }
                fileGroupArray[n3].add(bins);
                ++n12;
            }
        }
        File[] fileArray = new File[patternArray.length + 1];
        for (n = 0; n <= patternArray.length; ++n) {
            object4 = string3 + (n == patternArray.length ? "nc82" : patternArray[n].toString()) + File.separator;
            fileArray[n] = new File((String)object4);
            System.out.println("Going to create: " + (String)object4);
            n4 = fileArray[n].mkdir() ? 1 : 0;
            System.out.println("   result was: " + (n4 != 0));
            Quantile_Based_Normalization quantile_Based_Normalization = new Quantile_Based_Normalization();
            quantile_Based_Normalization.processToDirectory(fileGroupArray[n], fileArray[n].getAbsolutePath(), string4, 0, 256, false, false);
        }
        n = 0;
        object4 = new Bins[n12];
        String[] stringArray = new String[n12];
        String[] stringArray2 = new String[n12];
        for (int i = 0; i <= patternArray.length; ++i) {
            File file = fileArray[i];
            object3 = file.listFiles();
            for (n2 = 0; n2 < ((File[])object3).length; ++n2) {
                object2 = object3[n2];
                System.out.println("looking at values in: " + object2);
                object = BatchOpener.open(((File)object2).getAbsolutePath());
                if (object == null) {
                    IJ.error((String)("Couldn't open file: " + object2));
                    return;
                }
                ImagePlus imagePlus4 = object[0];
                ImageStack imageStack3 = imagePlus4.getStack();
                int n14 = -1;
                if (bl) {
                    n14 = this.maxValueInImage(imagePlus4, blArrayArray);
                    System.out.println("Rescaling with old maxValue: " + n14);
                }
                for (int j = 0; j < n7; ++j) {
                    byte[] byArray3 = (byte[])imageStack3.getPixels(j + 1);
                    for (int k = 0; k < n6; ++k) {
                        for (int i2 = 0; i2 < n5; ++i2) {
                            if (!blArrayArray[j][k * n5 + i2]) continue;
                            double d36 = (double)i2 * d3;
                            double d37 = (double)k * d4;
                            double d38 = (double)j * d5;
                            double d39 = d36 - d9;
                            double d40 = d37 - d10;
                            double d41 = d38 - d11;
                            double d42 = Math.sqrt(d39 * d39 + d40 * d40 + d41 * d41);
                            int n15 = byArray3[k * n5 + i2] & 0xFF;
                            if (bl) {
                                n15 = 255 * n15 / n14;
                            }
                            binsArray[i].add(n15, d42);
                            object4[n].add(n15, d42);
                            stringArray[n] = file.getName();
                            stringArray2[n] = ((File)object2).getName();
                        }
                    }
                }
                imagePlus4.close();
                ++n;
            }
        }
        String string9 = "/Users/mark/central-complex-complete-vib-protocol/mhl-output/";
        try {
            for (int i = 0; i <= patternArray.length; ++i) {
                object3 = i == patternArray.length ? string9 + "nc82.tsv" : string9 + patternArray[i] + ".tsv";
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File((String)object3))));
                printWriter.println("Pattern\tBin\tMinimumInBin\tMaximumInBin\tMidPointOfBin\tMeanValueInBin\tSDOfValuesInBin\t +N");
                object2 = i == patternArray.length ? "nc82" : patternArray[i].toString();
                object = binsArray[i];
                for (int j = 0; j < n11; ++j) {
                    printWriter.println("\"" + (String)object2 + "\"\t" + j + "\t" + ((Bins)object).getMinimumInBin(j) + "\t" + ((Bins)object).getMaximumInBin(j) + "\t" + ((Bins)object).getMidPointOfBin(j) + "\t" + ((Bins)object).getMean(j) + "\t" + ((Bins)object).getStandardDeviation(j) + "\t" + ((Bins)object).getN(j));
                }
                printWriter.close();
            }
            File file = new File(string9 + "per-brain");
            file.mkdir();
            for (int i = 0; i <= ((Bins[])object4).length; ++i) {
                String string10 = file.getAbsolutePath() + File.separator + stringArray2[i] + ".tsv";
                object2 = new PrintWriter(new BufferedWriter(new FileWriter(new File(string10))));
                ((PrintWriter)object2).println("Pattern\tBin\tMinimumInBin\tMaximumInBin\tMidPointOfBin\tMeanValueInBin\tSDOfValuesInBin\t +N");
                object = object4[i];
                for (int j = 0; j < n11; ++j) {
                    ((PrintWriter)object2).println("\"" + stringArray[i] + "\"\t" + j + "\t" + ((Bins)object).getMinimumInBin(j) + "\t" + ((Bins)object).getMaximumInBin(j) + "\t" + ((Bins)object).getMidPointOfBin(j) + "\t" + ((Bins)object).getMean(j) + "\t" + ((Bins)object).getStandardDeviation(j) + "\t" + ((Bins)object).getN(j));
                }
                ((PrintWriter)object2).close();
            }
        }
        catch (IOException iOException) {
            IJ.error((String)("There was an exception while writing the data: " + iOException));
            return;
        }
    }

    private int maxValueInImage(ImagePlus imagePlus, boolean[][] blArray) {
        int n = 0;
        ImageStack imageStack = imagePlus.getStack();
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        int n4 = imagePlus.getStackSize();
        for (int i = 0; i < n4; ++i) {
            byte[] byArray = (byte[])imageStack.getPixels(i + 1);
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    int n5;
                    if (!blArray[i][j * n2 + k] || (n5 = byArray[j * n2 + k] & 0xFF) <= n) continue;
                    n = n5;
                }
            }
        }
        return n;
    }

    class SphereAttempt
    implements MultivariateFunction {
        ArrayList<ArrayList<double[]>> pointsInShells = new ArrayList();

        SphereAttempt(int n) {
            for (int i = 0; i < n; ++i) {
                this.pointsInShells.add(new ArrayList());
            }
        }

        public double evaluate(double[] dArray) {
            double d = 0.0;
            for (int i = 0; i < this.pointsInShells.size(); ++i) {
                ArrayList<double[]> arrayList = this.pointsInShells.get(i);
                double d2 = 0.0;
                double d3 = 0.0;
                int n = arrayList.size();
                double d4 = dArray[0];
                double d5 = dArray[1];
                double d6 = dArray[2];
                for (double[] dArray2 : arrayList) {
                    double d7 = dArray2[0] - d4;
                    double d8 = dArray2[1] - d5;
                    double d9 = dArray2[2] - d6;
                    double d10 = d7 * d7 + d8 * d8 + d9 * d9;
                    double d11 = Math.sqrt(d10);
                    d2 += d10;
                    d3 += d11;
                }
                double d12 = d2 / (double)n - d3 * d3 / (double)(n * n);
                d += d12;
            }
            return d;
        }

        public int getNumArguments() {
            return 3;
        }

        public double getLowerBound(int n) {
            return 0.0;
        }

        public double getUpperBound(int n) {
            return 10000.0;
        }

        public void addPointInShell(int n, double d, double d2, double d3) {
            if (n < 0 || n >= this.pointsInShells.size()) {
                IJ.error((String)("There are only " + n + " (trying to insert into shell " + n + ")"));
                return;
            }
            double[] dArray = new double[]{d, d2, d3};
            this.pointsInShells.get(n).add(dArray);
        }
    }
}

