/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.ImagePlus;
import ij.measure.Calibration;
import java.util.StringTokenizer;
import java.util.Vector;
import math3d.FloatMatrixN;
import math3d.JacobiFloat;
import math3d.Point3d;
import math3d.Triangle;

public class FloatMatrix {
    public float x;
    public float y;
    public float z;
    protected float a00;
    protected float a01;
    protected float a02;
    protected float a03;
    protected float a10;
    protected float a11;
    protected float a12;
    protected float a13;
    protected float a20;
    protected float a21;
    protected float a22;
    protected float a23;

    public FloatMatrix() {
    }

    public FloatMatrix(float f) {
        this.a11 = this.a22 = f;
        this.a00 = this.a22;
    }

    public FloatMatrix(float[][] fArray) {
        if (fArray.length != 3 && fArray.length != 4 || fArray[0].length != 4) {
            throw new RuntimeException("Wrong dimensions: " + fArray.length + "x" + fArray[0].length);
        }
        this.a00 = fArray[0][0];
        this.a01 = fArray[0][1];
        this.a02 = fArray[0][2];
        this.a03 = fArray[0][3];
        this.a10 = fArray[1][0];
        this.a11 = fArray[1][1];
        this.a12 = fArray[1][2];
        this.a13 = fArray[1][3];
        this.a20 = fArray[2][0];
        this.a21 = fArray[2][1];
        this.a22 = fArray[2][2];
        this.a23 = fArray[2][3];
    }

    public FloatMatrix(FloatMatrix floatMatrix) {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.a00 = floatMatrix.a00;
        this.a01 = floatMatrix.a01;
        this.a02 = floatMatrix.a02;
        this.a03 = floatMatrix.a03;
        this.a10 = floatMatrix.a10;
        this.a11 = floatMatrix.a11;
        this.a12 = floatMatrix.a12;
        this.a13 = floatMatrix.a13;
        this.a20 = floatMatrix.a20;
        this.a21 = floatMatrix.a21;
        this.a22 = floatMatrix.a22;
        this.a23 = floatMatrix.a23;
    }

    public FloatMatrix copyFrom(FloatMatrix floatMatrix) {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.a00 = floatMatrix.a00;
        this.a01 = floatMatrix.a01;
        this.a02 = floatMatrix.a02;
        this.a03 = floatMatrix.a03;
        this.a10 = floatMatrix.a10;
        this.a11 = floatMatrix.a11;
        this.a12 = floatMatrix.a12;
        this.a13 = floatMatrix.a13;
        this.a20 = floatMatrix.a20;
        this.a21 = floatMatrix.a21;
        this.a22 = floatMatrix.a22;
        this.a23 = floatMatrix.a23;
        return this;
    }

    public boolean isJustTranslation() {
        FloatMatrix floatMatrix = new FloatMatrix(this);
        floatMatrix.a03 -= this.a03;
        floatMatrix.a13 -= this.a13;
        floatMatrix.a23 -= this.a23;
        return floatMatrix.isIdentity();
    }

    public boolean noTranslation() {
        float f = 1.0E-10f;
        return Math.abs(this.a03) < f && Math.abs(this.a13) < f && Math.abs(this.a23) < f;
    }

    public FloatMatrix composeWith(FloatMatrix floatMatrix) {
        FloatMatrix floatMatrix2 = this;
        FloatMatrix floatMatrix3 = floatMatrix;
        FloatMatrix floatMatrix4 = new FloatMatrix();
        floatMatrix4.a00 = floatMatrix2.a00 * floatMatrix3.a00 + floatMatrix2.a10 * floatMatrix3.a01 + floatMatrix2.a20 * floatMatrix3.a02;
        floatMatrix4.a10 = floatMatrix2.a00 * floatMatrix3.a10 + floatMatrix2.a10 * floatMatrix3.a11 + floatMatrix2.a20 * floatMatrix3.a12;
        floatMatrix4.a20 = floatMatrix2.a00 * floatMatrix3.a20 + floatMatrix2.a10 * floatMatrix3.a21 + floatMatrix2.a20 * floatMatrix3.a22;
        floatMatrix4.a01 = floatMatrix2.a01 * floatMatrix3.a00 + floatMatrix2.a11 * floatMatrix3.a01 + floatMatrix2.a21 * floatMatrix3.a02;
        floatMatrix4.a11 = floatMatrix2.a01 * floatMatrix3.a10 + floatMatrix2.a11 * floatMatrix3.a11 + floatMatrix2.a21 * floatMatrix3.a12;
        floatMatrix4.a21 = floatMatrix2.a01 * floatMatrix3.a20 + floatMatrix2.a11 * floatMatrix3.a21 + floatMatrix2.a21 * floatMatrix3.a22;
        floatMatrix4.a02 = floatMatrix2.a02 * floatMatrix3.a00 + floatMatrix2.a12 * floatMatrix3.a01 + floatMatrix2.a22 * floatMatrix3.a02;
        floatMatrix4.a12 = floatMatrix2.a02 * floatMatrix3.a10 + floatMatrix2.a12 * floatMatrix3.a11 + floatMatrix2.a22 * floatMatrix3.a12;
        floatMatrix4.a22 = floatMatrix2.a02 * floatMatrix3.a20 + floatMatrix2.a12 * floatMatrix3.a21 + floatMatrix2.a22 * floatMatrix3.a22;
        floatMatrix4.a03 = floatMatrix2.a03 * floatMatrix3.a00 + floatMatrix2.a13 * floatMatrix3.a01 + floatMatrix2.a23 * floatMatrix3.a02 + floatMatrix3.a03;
        floatMatrix4.a13 = floatMatrix2.a03 * floatMatrix3.a10 + floatMatrix2.a13 * floatMatrix3.a11 + floatMatrix2.a23 * floatMatrix3.a12 + floatMatrix3.a13;
        floatMatrix4.a23 = floatMatrix2.a03 * floatMatrix3.a20 + floatMatrix2.a13 * floatMatrix3.a21 + floatMatrix2.a23 * floatMatrix3.a22 + floatMatrix3.a23;
        return floatMatrix4;
    }

    public FloatMatrix[] decompose() {
        FloatMatrix[] floatMatrixArray = new FloatMatrix[2];
        floatMatrixArray[0].a00 = this.a00;
        floatMatrixArray[0].a01 = this.a01;
        floatMatrixArray[0].a02 = this.a02;
        floatMatrixArray[0].a10 = this.a10;
        floatMatrixArray[0].a11 = this.a11;
        floatMatrixArray[0].a12 = this.a12;
        floatMatrixArray[0].a20 = this.a20;
        floatMatrixArray[0].a21 = this.a21;
        floatMatrixArray[0].a22 = this.a22;
        floatMatrixArray[1].a03 = this.a03;
        floatMatrixArray[1].a13 = this.a13;
        floatMatrixArray[1].a23 = this.a23;
        return floatMatrixArray;
    }

    public FloatMatrix plus(FloatMatrix floatMatrix) {
        FloatMatrix floatMatrix2 = new FloatMatrix();
        floatMatrix2.a00 = floatMatrix.a00 + this.a00;
        floatMatrix2.a01 = floatMatrix.a01 + this.a01;
        floatMatrix2.a02 = floatMatrix.a02 + this.a02;
        floatMatrix2.a03 = floatMatrix.a03 + this.a03;
        floatMatrix2.a10 = floatMatrix.a10 + this.a10;
        floatMatrix2.a11 = floatMatrix.a11 + this.a11;
        floatMatrix2.a12 = floatMatrix.a12 + this.a12;
        floatMatrix2.a13 = floatMatrix.a13 + this.a13;
        floatMatrix2.a20 = floatMatrix.a20 + this.a20;
        floatMatrix2.a21 = floatMatrix.a21 + this.a21;
        floatMatrix2.a22 = floatMatrix.a22 + this.a22;
        floatMatrix2.a23 = floatMatrix.a23 + this.a23;
        return floatMatrix2;
    }

    public void apply(float f, float f2, float f3) {
        this.x = f * this.a00 + f2 * this.a01 + f3 * this.a02 + this.a03;
        this.y = f * this.a10 + f2 * this.a11 + f3 * this.a12 + this.a13;
        this.z = f * this.a20 + f2 * this.a21 + f3 * this.a22 + this.a23;
    }

    public void apply(Point3d point3d) {
        this.x = (float)(point3d.x * (double)this.a00 + point3d.y * (double)this.a01 + point3d.z * (double)this.a02 + (double)this.a03);
        this.y = (float)(point3d.x * (double)this.a10 + point3d.y * (double)this.a11 + point3d.z * (double)this.a12 + (double)this.a13);
        this.z = (float)(point3d.x * (double)this.a20 + point3d.y * (double)this.a21 + point3d.z * (double)this.a22 + (double)this.a23);
    }

    public void apply(float[] fArray) {
        this.x = fArray[0] * this.a00 + fArray[1] * this.a01 + fArray[2] * this.a02 + this.a03;
        this.y = fArray[0] * this.a10 + fArray[1] * this.a11 + fArray[2] * this.a12 + this.a13;
        this.z = fArray[0] * this.a20 + fArray[1] * this.a21 + fArray[2] * this.a22 + this.a23;
    }

    public void applyWithoutTranslation(float f, float f2, float f3) {
        this.x = f * this.a00 + f2 * this.a01 + f3 * this.a02;
        this.y = f * this.a10 + f2 * this.a11 + f3 * this.a12;
        this.z = f * this.a20 + f2 * this.a21 + f3 * this.a22;
    }

    public void applyWithoutTranslation(Point3d point3d) {
        this.x = (float)(point3d.x * (double)this.a00 + point3d.y * (double)this.a01 + point3d.z * (double)this.a02);
        this.y = (float)(point3d.x * (double)this.a10 + point3d.y * (double)this.a11 + point3d.z * (double)this.a12);
        this.z = (float)(point3d.x * (double)this.a20 + point3d.y * (double)this.a21 + point3d.z * (double)this.a22);
    }

    public Point3d getResult() {
        return new Point3d(this.x, this.y, this.z);
    }

    public FloatMatrix scale(float f, float f2, float f3) {
        FloatMatrix floatMatrix = new FloatMatrix();
        floatMatrix.a00 = this.a00 * f;
        floatMatrix.a01 = this.a01 * f;
        floatMatrix.a02 = this.a02 * f;
        floatMatrix.a03 = this.a03 * f;
        floatMatrix.a10 = this.a10 * f2;
        floatMatrix.a11 = this.a11 * f2;
        floatMatrix.a12 = this.a12 * f2;
        floatMatrix.a13 = this.a13 * f2;
        floatMatrix.a20 = this.a20 * f3;
        floatMatrix.a21 = this.a21 * f3;
        floatMatrix.a22 = this.a22 * f3;
        floatMatrix.a23 = this.a23 * f3;
        return floatMatrix;
    }

    public FloatMatrix times(FloatMatrix floatMatrix) {
        FloatMatrix floatMatrix2 = new FloatMatrix();
        floatMatrix2.a00 = floatMatrix.a00 * this.a00 + floatMatrix.a10 * this.a01 + floatMatrix.a20 * this.a02;
        floatMatrix2.a10 = floatMatrix.a00 * this.a10 + floatMatrix.a10 * this.a11 + floatMatrix.a20 * this.a12;
        floatMatrix2.a20 = floatMatrix.a00 * this.a20 + floatMatrix.a10 * this.a21 + floatMatrix.a20 * this.a22;
        floatMatrix2.a01 = floatMatrix.a01 * this.a00 + floatMatrix.a11 * this.a01 + floatMatrix.a21 * this.a02;
        floatMatrix2.a11 = floatMatrix.a01 * this.a10 + floatMatrix.a11 * this.a11 + floatMatrix.a21 * this.a12;
        floatMatrix2.a21 = floatMatrix.a01 * this.a20 + floatMatrix.a11 * this.a21 + floatMatrix.a21 * this.a22;
        floatMatrix2.a02 = floatMatrix.a02 * this.a00 + floatMatrix.a12 * this.a01 + floatMatrix.a22 * this.a02;
        floatMatrix2.a12 = floatMatrix.a02 * this.a10 + floatMatrix.a12 * this.a11 + floatMatrix.a22 * this.a12;
        floatMatrix2.a22 = floatMatrix.a02 * this.a20 + floatMatrix.a12 * this.a21 + floatMatrix.a22 * this.a22;
        this.apply(floatMatrix.a03, floatMatrix.a13, floatMatrix.a23);
        floatMatrix2.a03 = this.x;
        floatMatrix2.a13 = this.y;
        floatMatrix2.a23 = this.z;
        return floatMatrix2;
    }

    public float det() {
        float f = this.a11 * this.a22 - this.a12 * this.a21;
        float f2 = this.a10 * this.a22 - this.a12 * this.a20;
        float f3 = this.a10 * this.a21 - this.a11 * this.a20;
        float f4 = this.a01 * this.a22 - this.a02 * this.a21;
        float f5 = this.a00 * this.a22 - this.a02 * this.a20;
        float f6 = this.a00 * this.a21 - this.a01 * this.a20;
        float f7 = this.a01 * this.a12 - this.a02 * this.a11;
        float f8 = this.a00 * this.a12 - this.a02 * this.a10;
        float f9 = this.a00 * this.a11 - this.a01 * this.a10;
        return this.a00 * f - this.a01 * f2 + this.a02 * f3;
    }

    private FloatMatrix invert3x3() {
        float f = this.a11 * this.a22 - this.a12 * this.a21;
        float f2 = this.a10 * this.a22 - this.a12 * this.a20;
        float f3 = this.a10 * this.a21 - this.a11 * this.a20;
        float f4 = this.a01 * this.a22 - this.a02 * this.a21;
        float f5 = this.a00 * this.a22 - this.a02 * this.a20;
        float f6 = this.a00 * this.a21 - this.a01 * this.a20;
        float f7 = this.a01 * this.a12 - this.a02 * this.a11;
        float f8 = this.a00 * this.a12 - this.a02 * this.a10;
        float f9 = this.a00 * this.a11 - this.a01 * this.a10;
        float f10 = this.a00 * f - this.a01 * f2 + this.a02 * f3;
        FloatMatrix floatMatrix = new FloatMatrix();
        floatMatrix.a00 = f / f10;
        floatMatrix.a01 = -f4 / f10;
        floatMatrix.a02 = f7 / f10;
        floatMatrix.a10 = -f2 / f10;
        floatMatrix.a11 = f5 / f10;
        floatMatrix.a12 = -f8 / f10;
        floatMatrix.a20 = f3 / f10;
        floatMatrix.a21 = -f6 / f10;
        floatMatrix.a22 = f9 / f10;
        return floatMatrix;
    }

    public FloatMatrix inverse() {
        FloatMatrix floatMatrix = this.invert3x3();
        floatMatrix.apply(-this.a03, -this.a13, -this.a23);
        floatMatrix.a03 = floatMatrix.x;
        floatMatrix.a13 = floatMatrix.y;
        floatMatrix.a23 = floatMatrix.z;
        return floatMatrix;
    }

    public static FloatMatrix rotate(float f, int n) {
        FloatMatrix floatMatrix = new FloatMatrix();
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        switch (n) {
            case 0: {
                floatMatrix.a11 = floatMatrix.a22 = f2;
                floatMatrix.a21 = f3;
                floatMatrix.a12 = -floatMatrix.a21;
                floatMatrix.a00 = 1.0f;
                break;
            }
            case 1: {
                floatMatrix.a00 = floatMatrix.a22 = f2;
                floatMatrix.a20 = f3;
                floatMatrix.a02 = -floatMatrix.a20;
                floatMatrix.a11 = 1.0f;
                break;
            }
            case 2: {
                floatMatrix.a00 = floatMatrix.a11 = f2;
                floatMatrix.a10 = f3;
                floatMatrix.a01 = -floatMatrix.a10;
                floatMatrix.a22 = 1.0f;
                break;
            }
            default: {
                throw new RuntimeException("Illegal axis: " + n);
            }
        }
        return floatMatrix;
    }

    public static FloatMatrix rotateFromTo(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        f /= f7;
        f2 /= f7;
        f3 /= f7;
        f7 = (float)Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
        float f8 = f2 * (f6 /= f7) - f3 * (f5 /= f7);
        float f9 = f3 * (f4 /= f7) - f * f6;
        float f10 = f * f5 - f2 * f4;
        float f11 = f9 * f3 - f10 * f2;
        float f12 = f10 * f - f8 * f3;
        float f13 = f8 * f2 - f9 * f;
        float f14 = f9 * f6 - f10 * f5;
        float f15 = f10 * f4 - f8 * f6;
        float f16 = f8 * f5 - f9 * f4;
        FloatMatrix floatMatrix = new FloatMatrix();
        floatMatrix.a00 = f;
        floatMatrix.a01 = f2;
        floatMatrix.a02 = f3;
        floatMatrix.a10 = f8;
        floatMatrix.a11 = f9;
        floatMatrix.a12 = f10;
        floatMatrix.a20 = f11;
        floatMatrix.a21 = f12;
        floatMatrix.a22 = f13;
        FloatMatrix floatMatrix2 = new FloatMatrix();
        floatMatrix2.a00 = f4;
        floatMatrix2.a01 = f8;
        floatMatrix2.a02 = f14;
        floatMatrix2.a10 = f5;
        floatMatrix2.a11 = f9;
        floatMatrix2.a12 = f15;
        floatMatrix2.a20 = f6;
        floatMatrix2.a21 = f10;
        floatMatrix2.a22 = f16;
        return floatMatrix2.times(floatMatrix);
    }

    public static float dotProduct(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("In dotProduct, the vectors must be of the same length.");
        }
        if (fArray.length < 1) {
            throw new IllegalArgumentException("Can't dotProduct vectors of zero length.");
        }
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i] * fArray2[i];
        }
        return f;
    }

    public static float sizeSquared(float[] fArray) {
        return FloatMatrix.dotProduct(fArray, fArray);
    }

    public static float size(float[] fArray) {
        return (float)Math.sqrt(FloatMatrix.dotProduct(fArray, fArray));
    }

    public static float angleBetween(float[] fArray, float[] fArray2) {
        return (float)Math.acos(FloatMatrix.dotProduct(fArray, fArray2) / (FloatMatrix.size(fArray) * FloatMatrix.size(fArray2)));
    }

    public static float[] crossProduct(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{fArray[1] * fArray2[2] - fArray[2] * fArray2[1], fArray[2] * fArray2[0] - fArray[0] * fArray2[2], fArray[0] * fArray2[1] - fArray[1] * fArray2[0]};
        return fArray3;
    }

    public static float[] normalize(float[] fArray) {
        float f = FloatMatrix.size(fArray);
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = fArray[i] / f;
        }
        return fArray2;
    }

    public static FloatMatrix rotateToAlignVectors(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        float f = FloatMatrix.angleBetween(fArray3, fArray);
        float[] fArray5 = FloatMatrix.crossProduct(fArray3, fArray);
        float[] fArray6 = FloatMatrix.normalize(fArray5);
        FloatMatrix floatMatrix = FloatMatrix.rotateAround(fArray6[0], fArray6[1], fArray6[2], f);
        float f2 = FloatMatrix.dotProduct(fArray4, fArray3) / FloatMatrix.sizeSquared(fArray3);
        float[] fArray7 = new float[]{fArray4[0] - f2 * fArray3[0], fArray4[1] - f2 * fArray3[1], fArray4[2] - f2 * fArray3[2]};
        float f3 = FloatMatrix.dotProduct(fArray2, fArray) / FloatMatrix.sizeSquared(fArray);
        float[] fArray8 = new float[]{fArray2[0] - f3 * fArray[0], fArray2[1] - f3 * fArray[1], fArray2[2] - f3 * fArray[2]};
        floatMatrix.apply(fArray7[0], fArray7[1], fArray7[2]);
        float[] fArray9 = new float[]{floatMatrix.x, floatMatrix.y, floatMatrix.z};
        float f4 = FloatMatrix.angleBetween(fArray9, fArray8);
        float[] fArray10 = FloatMatrix.crossProduct(fArray9, fArray8);
        float[] fArray11 = FloatMatrix.normalize(fArray10);
        FloatMatrix floatMatrix2 = FloatMatrix.rotateAround(fArray11[0], fArray11[1], fArray11[2], f4);
        return floatMatrix.composeWith(floatMatrix2);
    }

    public static FloatMatrix rotateAround(float f, float f2, float f3, float f4) {
        FloatMatrix floatMatrix = new FloatMatrix();
        float f5 = (float)Math.cos(f4);
        float f6 = (float)Math.sin(f4);
        floatMatrix.a00 = -(f5 - 1.0f) * f * f + f5;
        floatMatrix.a01 = -(f5 - 1.0f) * f * f2 - f6 * f3;
        floatMatrix.a02 = -(f5 - 1.0f) * f * f3 + f6 * f2;
        floatMatrix.a03 = 0.0f;
        floatMatrix.a10 = -(f5 - 1.0f) * f * f2 + f6 * f3;
        floatMatrix.a11 = -(f5 - 1.0f) * f2 * f2 + f5;
        floatMatrix.a12 = -(f5 - 1.0f) * f2 * f3 - f6 * f;
        floatMatrix.a13 = 0.0f;
        floatMatrix.a20 = -(f5 - 1.0f) * f * f3 - f6 * f2;
        floatMatrix.a21 = -(f5 - 1.0f) * f2 * f3 + f6 * f;
        floatMatrix.a22 = -(f5 - 1.0f) * f3 * f3 + f5;
        floatMatrix.a23 = 0.0f;
        return floatMatrix;
    }

    public static FloatMatrix rotateEuler(float f, float f2, float f3) {
        FloatMatrix floatMatrix = new FloatMatrix();
        float f4 = (float)Math.cos(f);
        float f5 = (float)Math.sin(f);
        float f6 = (float)Math.cos(f2);
        float f7 = (float)Math.sin(f2);
        float f8 = (float)Math.cos(f3);
        float f9 = (float)Math.sin(f3);
        floatMatrix.a00 = f8 * f4 - f6 * f5 * f9;
        floatMatrix.a01 = -f9 * f4 - f6 * f5 * f8;
        floatMatrix.a02 = f7 * f5;
        floatMatrix.a03 = 0.0f;
        floatMatrix.a10 = f8 * f5 + f6 * f4 * f9;
        floatMatrix.a11 = -f9 * f5 + f6 * f4 * f8;
        floatMatrix.a12 = -f7 * f4;
        floatMatrix.a13 = 0.0f;
        floatMatrix.a20 = f7 * f9;
        floatMatrix.a21 = f7 * f8;
        floatMatrix.a22 = f6;
        floatMatrix.a23 = 0.0f;
        return floatMatrix;
    }

    public static FloatMatrix rotateEulerAt(float f, float f2, float f3, float f4, float f5, float f6) {
        FloatMatrix floatMatrix = new FloatMatrix();
        float f7 = (float)Math.cos(f);
        float f8 = (float)Math.sin(f);
        float f9 = (float)Math.cos(f2);
        float f10 = (float)Math.sin(f2);
        float f11 = (float)Math.cos(f3);
        float f12 = (float)Math.sin(f3);
        floatMatrix.a00 = f11 * f7 - f9 * f8 * f12;
        floatMatrix.a01 = -f12 * f7 - f9 * f8 * f11;
        floatMatrix.a02 = f10 * f8;
        floatMatrix.a03 = 0.0f;
        floatMatrix.a10 = f11 * f8 + f9 * f7 * f12;
        floatMatrix.a11 = -f12 * f8 + f9 * f7 * f11;
        floatMatrix.a12 = -f10 * f7;
        floatMatrix.a13 = 0.0f;
        floatMatrix.a20 = f10 * f12;
        floatMatrix.a21 = f10 * f11;
        floatMatrix.a22 = f9;
        floatMatrix.a23 = 0.0f;
        floatMatrix.apply(f4, f5, f6);
        floatMatrix.a03 = f4 - floatMatrix.x;
        floatMatrix.a13 = f5 - floatMatrix.y;
        floatMatrix.a23 = f6 - floatMatrix.z;
        return floatMatrix;
    }

    public void guessEulerParameters(float[] fArray) {
        if (fArray.length != 6) {
            throw new IllegalArgumentException("Need 6 parameters, got " + fArray.length);
        }
        this.guessEulerParameters(fArray, null);
    }

    public void guessEulerParameters(float[] fArray, Point3d point3d) {
        if (point3d != null && fArray.length != 9) {
            throw new IllegalArgumentException("Need 9 parameters, got " + fArray.length);
        }
        if (this.a21 == 0.0f && this.a20 == 0.0f) {
            fArray[2] = 0.0f;
            fArray[1] = 0.0f;
            fArray[0] = (float)Math.atan2(this.a10, this.a00);
        } else {
            fArray[2] = (float)Math.atan2(this.a20, this.a21);
            fArray[1] = (float)Math.atan2(Math.sqrt(this.a21 * this.a21 + this.a20 * this.a20), this.a22);
            fArray[0] = (float)Math.atan2(this.a02, -this.a12);
        }
        if (point3d != null) {
            fArray[6] = (float)point3d.x;
            fArray[7] = (float)point3d.y;
            fArray[8] = (float)point3d.z;
            this.apply(point3d);
            fArray[3] = this.x - (float)point3d.x;
            fArray[4] = this.y - (float)point3d.y;
            fArray[5] = this.z - (float)point3d.z;
            return;
        }
        if (this.a03 == 0.0f && this.a13 == 0.0f && this.a23 == 0.0f) {
            fArray[5] = 0.0f;
            fArray[4] = 0.0f;
            fArray[3] = 0.0f;
        } else {
            this.apply(this.a03, this.a13, this.a23);
            Triangle triangle = new Triangle(new Point3d(0.0, 0.0, 0.0), new Point3d(this.a03, this.a13, this.a23), new Point3d(this.x, this.y, this.z));
            triangle.calculateCircumcenter2();
            fArray[3] = (float)triangle.center.x;
            fArray[4] = (float)triangle.center.y;
            fArray[5] = (float)triangle.center.z;
        }
    }

    public static FloatMatrix translate(float f, float f2, float f3) {
        FloatMatrix floatMatrix = new FloatMatrix();
        floatMatrix.a22 = 1.0f;
        floatMatrix.a11 = 1.0f;
        floatMatrix.a00 = 1.0f;
        floatMatrix.a03 = f;
        floatMatrix.a13 = f2;
        floatMatrix.a23 = f3;
        return floatMatrix;
    }

    public static FloatMatrix bestLinear(Point3d[] point3dArray, Point3d[] point3dArray2) {
        if (point3dArray.length != point3dArray2.length) {
            throw new RuntimeException("different lengths");
        }
        if (point3dArray.length != 4) {
            throw new RuntimeException("The arrays passed to bestLinear must be of length 4");
        }
        float[][] fArray = new float[4][4];
        float[][] fArray2 = new float[4][4];
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray3 = fArray[0];
            fArray3[0] = fArray3[0] + (float)(point3dArray[i].x * point3dArray[i].x);
            float[] fArray4 = fArray[0];
            fArray4[1] = fArray4[1] + (float)(point3dArray[i].x * point3dArray[i].y);
            float[] fArray5 = fArray[0];
            fArray5[2] = fArray5[2] + (float)(point3dArray[i].x * point3dArray[i].z);
            float[] fArray6 = fArray[0];
            fArray6[3] = fArray6[3] + (float)point3dArray[i].x;
            float[] fArray7 = fArray[1];
            fArray7[1] = fArray7[1] + (float)(point3dArray[i].y * point3dArray[i].y);
            float[] fArray8 = fArray[1];
            fArray8[2] = fArray8[2] + (float)(point3dArray[i].y * point3dArray[i].z);
            float[] fArray9 = fArray[1];
            fArray9[3] = fArray9[3] + (float)point3dArray[i].y;
            float[] fArray10 = fArray[2];
            fArray10[2] = fArray10[2] + (float)(point3dArray[i].z * point3dArray[i].z);
            float[] fArray11 = fArray[2];
            fArray11[3] = fArray11[3] + (float)point3dArray[i].z;
            float[] fArray12 = fArray2[0];
            fArray12[0] = fArray12[0] + (float)(point3dArray[i].x * point3dArray2[i].x);
            float[] fArray13 = fArray2[0];
            fArray13[1] = fArray13[1] + (float)(point3dArray[i].y * point3dArray2[i].x);
            float[] fArray14 = fArray2[0];
            fArray14[2] = fArray14[2] + (float)(point3dArray[i].z * point3dArray2[i].x);
            float[] fArray15 = fArray2[0];
            fArray15[3] = fArray15[3] + (float)point3dArray2[i].x;
            float[] fArray16 = fArray2[1];
            fArray16[0] = fArray16[0] + (float)(point3dArray[i].x * point3dArray2[i].y);
            float[] fArray17 = fArray2[1];
            fArray17[1] = fArray17[1] + (float)(point3dArray[i].y * point3dArray2[i].y);
            float[] fArray18 = fArray2[1];
            fArray18[2] = fArray18[2] + (float)(point3dArray[i].z * point3dArray2[i].y);
            float[] fArray19 = fArray2[1];
            fArray19[3] = fArray19[3] + (float)point3dArray2[i].y;
            float[] fArray20 = fArray2[2];
            fArray20[0] = fArray20[0] + (float)(point3dArray[i].x * point3dArray2[i].z);
            float[] fArray21 = fArray2[2];
            fArray21[1] = fArray21[1] + (float)(point3dArray[i].y * point3dArray2[i].z);
            float[] fArray22 = fArray2[2];
            fArray22[2] = fArray22[2] + (float)(point3dArray[i].z * point3dArray2[i].z);
            float[] fArray23 = fArray2[2];
            fArray23[3] = fArray23[3] + (float)point3dArray2[i].z;
        }
        fArray[1][0] = fArray[0][1];
        fArray[2][0] = fArray[0][2];
        fArray[2][1] = fArray[1][2];
        fArray[3][0] = fArray[0][3];
        fArray[3][1] = fArray[1][3];
        fArray[3][2] = fArray[2][3];
        fArray[3][3] = 1.0f;
        FloatMatrixN.invert(fArray);
        float[][] fArray24 = FloatMatrixN.times(fArray2, fArray);
        FloatMatrix floatMatrix = new FloatMatrix();
        floatMatrix.a00 = fArray24[0][0];
        floatMatrix.a01 = fArray24[0][1];
        floatMatrix.a02 = fArray24[0][2];
        floatMatrix.a03 = fArray24[0][3];
        floatMatrix.a10 = fArray24[1][0];
        floatMatrix.a11 = fArray24[1][1];
        floatMatrix.a12 = fArray24[1][2];
        floatMatrix.a13 = fArray24[1][3];
        floatMatrix.a20 = fArray24[2][0];
        floatMatrix.a21 = fArray24[2][1];
        floatMatrix.a22 = fArray24[2][2];
        floatMatrix.a23 = fArray24[2][3];
        return floatMatrix;
    }

    public static FloatMatrix bestRigid(Point3d[] point3dArray, Point3d[] point3dArray2) {
        return FloatMatrix.bestRigid(point3dArray, point3dArray2, true);
    }

    public static FloatMatrix bestRigid(Point3d[] point3dArray, Point3d[] point3dArray2, boolean bl) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        if (point3dArray.length != point3dArray2.length) {
            throw new RuntimeException("different lengths");
        }
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        for (int i = 0; i < point3dArray.length; ++i) {
            f15 += (float)point3dArray[i].x;
            f14 += (float)point3dArray[i].y;
            f13 += (float)point3dArray[i].z;
            f12 += (float)point3dArray2[i].x;
            f11 += (float)point3dArray2[i].y;
            f10 += (float)point3dArray2[i].z;
        }
        f15 /= (float)point3dArray.length;
        f14 /= (float)point3dArray.length;
        f13 /= (float)point3dArray.length;
        f12 /= (float)point3dArray.length;
        f11 /= (float)point3dArray.length;
        f10 /= (float)point3dArray.length;
        float f16 = 1.0f;
        if (bl) {
            f9 = 0.0f;
            f8 = 0.0f;
            for (int i = 0; i < point3dArray.length; ++i) {
                f7 = (float)point3dArray[i].x - f15;
                f6 = (float)point3dArray[i].y - f14;
                f5 = (float)point3dArray[i].z - f13;
                f4 = (float)point3dArray2[i].x - f12;
                f3 = (float)point3dArray2[i].y - f11;
                f2 = (float)point3dArray2[i].z - f10;
                f8 += f7 * f7 + f6 * f6 + f5 * f5;
                f9 += f4 * f4 + f3 * f3 + f2 * f2;
            }
            f16 = (float)Math.sqrt(f9 / f8);
        }
        f2 = 0.0f;
        f3 = 0.0f;
        f4 = 0.0f;
        f5 = 0.0f;
        f6 = 0.0f;
        f7 = 0.0f;
        float f17 = 0.0f;
        f9 = 0.0f;
        f8 = 0.0f;
        for (int i = 0; i < point3dArray.length; ++i) {
            float f18 = ((float)point3dArray[i].x - f15) * f16;
            float f19 = ((float)point3dArray[i].y - f14) * f16;
            float f20 = ((float)point3dArray[i].z - f13) * f16;
            float f21 = (float)point3dArray2[i].x - f12;
            float f22 = (float)point3dArray2[i].y - f11;
            f = (float)point3dArray2[i].z - f10;
            f8 += f18 * f21;
            f9 += f18 * f22;
            f17 += f18 * f;
            f7 += f19 * f21;
            f6 += f19 * f22;
            f5 += f19 * f;
            f4 += f20 * f21;
            f3 += f20 * f22;
            f2 += f20 * f;
        }
        float[][] fArray = new float[4][4];
        fArray[0][0] = f8 + f6 + f2;
        fArray[0][1] = f5 - f3;
        fArray[0][2] = f4 - f17;
        fArray[0][3] = f9 - f7;
        fArray[1][0] = f5 - f3;
        fArray[1][1] = f8 - f6 - f2;
        fArray[1][2] = f9 + f7;
        fArray[1][3] = f4 + f17;
        fArray[2][0] = f4 - f17;
        fArray[2][1] = f9 + f7;
        fArray[2][2] = -f8 + f6 - f2;
        fArray[2][3] = f5 + f3;
        fArray[3][0] = f9 - f7;
        fArray[3][1] = f4 + f17;
        fArray[3][2] = f5 + f3;
        fArray[3][3] = -f8 - f6 + f2;
        JacobiFloat jacobiFloat = new JacobiFloat(fArray);
        float[][] fArray2 = jacobiFloat.getEigenVectors();
        float[] fArray3 = jacobiFloat.getEigenValues();
        int n = 0;
        for (int i = 1; i < 4; ++i) {
            if (!(fArray3[i] > fArray3[n])) continue;
            n = i;
        }
        float[] fArray4 = fArray2[n];
        f = fArray4[0];
        float f23 = fArray4[1];
        float f24 = fArray4[2];
        float f25 = fArray4[3];
        FloatMatrix floatMatrix = new FloatMatrix();
        floatMatrix.a00 = f16 * (f * f + f23 * f23 - f24 * f24 - f25 * f25);
        floatMatrix.a01 = f16 * 2.0f * (f23 * f24 - f * f25);
        floatMatrix.a02 = f16 * 2.0f * (f23 * f25 + f * f24);
        floatMatrix.a10 = f16 * 2.0f * (f24 * f23 + f * f25);
        floatMatrix.a11 = f16 * (f * f - f23 * f23 + f24 * f24 - f25 * f25);
        floatMatrix.a12 = f16 * 2.0f * (f24 * f25 - f * f23);
        floatMatrix.a20 = f16 * 2.0f * (f25 * f23 - f * f24);
        floatMatrix.a21 = f16 * 2.0f * (f25 * f24 + f * f23);
        floatMatrix.a22 = f16 * (f * f - f23 * f23 - f24 * f24 + f25 * f25);
        floatMatrix.apply(f15, f14, f13);
        floatMatrix.a03 = f12 - floatMatrix.x;
        floatMatrix.a13 = f11 - floatMatrix.y;
        floatMatrix.a23 = f10 - floatMatrix.z;
        return floatMatrix;
    }

    public static FloatMatrix average(FloatMatrix[] floatMatrixArray) {
        FloatMatrix floatMatrix = new FloatMatrix();
        int n = 0;
        for (int i = 0; i < floatMatrixArray.length; ++i) {
            if (floatMatrixArray[i] == null) continue;
            ++n;
            floatMatrix.a00 += floatMatrixArray[i].a00;
            floatMatrix.a01 += floatMatrixArray[i].a01;
            floatMatrix.a02 += floatMatrixArray[i].a02;
            floatMatrix.a03 += floatMatrixArray[i].a03;
            floatMatrix.a10 += floatMatrixArray[i].a10;
            floatMatrix.a11 += floatMatrixArray[i].a11;
            floatMatrix.a12 += floatMatrixArray[i].a12;
            floatMatrix.a13 += floatMatrixArray[i].a13;
            floatMatrix.a20 += floatMatrixArray[i].a20;
            floatMatrix.a21 += floatMatrixArray[i].a21;
            floatMatrix.a22 += floatMatrixArray[i].a22;
            floatMatrix.a23 += floatMatrixArray[i].a23;
        }
        if (n > 0) {
            floatMatrix.a00 /= (float)n;
            floatMatrix.a01 /= (float)n;
            floatMatrix.a02 /= (float)n;
            floatMatrix.a03 /= (float)n;
            floatMatrix.a10 /= (float)n;
            floatMatrix.a11 /= (float)n;
            floatMatrix.a12 /= (float)n;
            floatMatrix.a13 /= (float)n;
            floatMatrix.a20 /= (float)n;
            floatMatrix.a21 /= (float)n;
            floatMatrix.a22 /= (float)n;
            floatMatrix.a23 /= (float)n;
        }
        return floatMatrix;
    }

    public float[] rowwise16() {
        return new float[]{this.a00, this.a01, this.a02, this.a03, this.a10, this.a11, this.a12, this.a13, this.a20, this.a21, this.a22, this.a23, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static FloatMatrix parseMatrix(String string) {
        FloatMatrix floatMatrix = new FloatMatrix();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            boolean bl = true;
            floatMatrix.a00 = Float.parseFloat(stringTokenizer.nextToken());
            floatMatrix.a10 = Float.parseFloat(stringTokenizer.nextToken());
            floatMatrix.a20 = Float.parseFloat(stringTokenizer.nextToken());
            float f = Float.parseFloat(stringTokenizer.nextToken());
            if (f != 0.0f) {
                bl = false;
                floatMatrix.a03 = f;
            }
            floatMatrix.a01 = Float.parseFloat(stringTokenizer.nextToken());
            floatMatrix.a11 = Float.parseFloat(stringTokenizer.nextToken());
            floatMatrix.a21 = Float.parseFloat(stringTokenizer.nextToken());
            f = Float.parseFloat(stringTokenizer.nextToken());
            if (bl && f != 0.0f) {
                bl = false;
            }
            if (!bl) {
                floatMatrix.a13 = f;
            }
            floatMatrix.a02 = Float.parseFloat(stringTokenizer.nextToken());
            floatMatrix.a12 = Float.parseFloat(stringTokenizer.nextToken());
            floatMatrix.a22 = Float.parseFloat(stringTokenizer.nextToken());
            f = Float.parseFloat(stringTokenizer.nextToken());
            if (bl && f != 0.0f) {
                bl = false;
            }
            if (!bl) {
                floatMatrix.a23 = f;
            }
            if (bl) {
                if (!stringTokenizer.hasMoreTokens()) {
                    bl = false;
                }
            } else if (stringTokenizer.hasMoreTokens()) {
                throw new RuntimeException("Not a uniform matrix: " + string);
            }
            if (bl) {
                floatMatrix.a03 = Float.parseFloat(stringTokenizer.nextToken());
                floatMatrix.a13 = Float.parseFloat(stringTokenizer.nextToken());
                floatMatrix.a23 = Float.parseFloat(stringTokenizer.nextToken());
                if (Float.parseFloat(stringTokenizer.nextToken()) != 1.0f) {
                    throw new RuntimeException("Not a uniform matrix: " + string);
                }
            } else {
                f = floatMatrix.a01;
                floatMatrix.a01 = floatMatrix.a10;
                floatMatrix.a10 = f;
                f = floatMatrix.a02;
                floatMatrix.a02 = floatMatrix.a20;
                floatMatrix.a20 = f;
                f = floatMatrix.a12;
                floatMatrix.a12 = floatMatrix.a21;
                floatMatrix.a21 = f;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return floatMatrix;
    }

    public static FloatMatrix[] parseMatrices(String string) {
        FloatMatrix[] floatMatrixArray;
        Vector<FloatMatrix> vector = new Vector<FloatMatrix>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            floatMatrixArray = stringTokenizer.nextToken().trim();
            if (floatMatrixArray.equals("")) {
                vector.add(null);
                continue;
            }
            vector.add(FloatMatrix.parseMatrix((String)floatMatrixArray));
        }
        floatMatrixArray = new FloatMatrix[vector.size()];
        for (int i = 0; i < floatMatrixArray.length; ++i) {
            floatMatrixArray[i] = (FloatMatrix)vector.get(i);
        }
        return floatMatrixArray;
    }

    public static FloatMatrix fromCalibration(ImagePlus imagePlus) {
        Calibration calibration = imagePlus.getCalibration();
        FloatMatrix floatMatrix = new FloatMatrix();
        floatMatrix.a00 = (float)Math.abs(calibration.pixelWidth);
        floatMatrix.a11 = (float)Math.abs(calibration.pixelHeight);
        floatMatrix.a22 = (float)Math.abs(calibration.pixelDepth);
        floatMatrix.a03 = (float)calibration.xOrigin;
        floatMatrix.a13 = (float)calibration.yOrigin;
        floatMatrix.a23 = (float)calibration.zOrigin;
        return floatMatrix;
    }

    public static FloatMatrix translateToCenter(ImagePlus imagePlus) {
        Calibration calibration = imagePlus.getCalibration();
        FloatMatrix floatMatrix = new FloatMatrix();
        floatMatrix.a00 = 1.0f;
        floatMatrix.a11 = 1.0f;
        floatMatrix.a22 = 1.0f;
        floatMatrix.a03 = (float)(calibration.xOrigin + calibration.pixelWidth * (double)imagePlus.getWidth() / 2.0);
        floatMatrix.a13 = (float)(calibration.yOrigin + calibration.pixelHeight * (double)imagePlus.getHeight() / 2.0);
        floatMatrix.a23 = (float)(calibration.yOrigin + calibration.pixelDepth * (double)imagePlus.getStack().getSize() / 2.0);
        return floatMatrix;
    }

    public final boolean isIdentity() {
        return this.isIdentity(1.0E-10f);
    }

    public final boolean equals(FloatMatrix floatMatrix) {
        float f = 1.0E-10f;
        return f > Math.abs(this.a00 - floatMatrix.a00) && f > Math.abs(this.a01 - floatMatrix.a01) && f > Math.abs(this.a02 - floatMatrix.a02) && f > Math.abs(this.a03 - floatMatrix.a03) && f > Math.abs(this.a10 - floatMatrix.a10) && f > Math.abs(this.a11 - floatMatrix.a11) && f > Math.abs(this.a12 - floatMatrix.a12) && f > Math.abs(this.a13 - floatMatrix.a13) && f > Math.abs(this.a20 - floatMatrix.a20) && f > Math.abs(this.a21 - floatMatrix.a21) && f > Math.abs(this.a22 - floatMatrix.a22) && f > Math.abs(this.a23 - floatMatrix.a23);
    }

    public final boolean isIdentity(float f) {
        return f > Math.abs(this.a00 - 1.0f) && f > Math.abs(this.a11 - 1.0f) && f > Math.abs(this.a22 - 1.0f) && f > Math.abs(this.a01) && f > Math.abs(this.a02) && f > Math.abs(this.a03) && f > Math.abs(this.a10) && f > Math.abs(this.a12) && f > Math.abs(this.a13) && f > Math.abs(this.a20) && f > Math.abs(this.a21) && f > Math.abs(this.a23);
    }

    public void copyToFlatFloatArray(float[] fArray) {
        fArray[0] = this.a00;
        fArray[1] = this.a01;
        fArray[2] = this.a02;
        fArray[3] = this.a03;
        fArray[4] = this.a10;
        fArray[5] = this.a11;
        fArray[6] = this.a12;
        fArray[7] = this.a13;
        fArray[8] = this.a20;
        fArray[9] = this.a21;
        fArray[10] = this.a22;
        fArray[11] = this.a23;
    }

    public void setFromFlatFloatArray(float[] fArray) {
        this.a00 = fArray[0];
        this.a01 = fArray[1];
        this.a02 = fArray[2];
        this.a03 = fArray[3];
        this.a10 = fArray[4];
        this.a11 = fArray[5];
        this.a12 = fArray[6];
        this.a13 = fArray[7];
        this.a20 = fArray[8];
        this.a21 = fArray[9];
        this.a22 = fArray[10];
        this.a23 = fArray[11];
    }

    public String resultToString() {
        return "" + this.x + " " + this.y + " " + this.z;
    }

    public String toStringIndented(String string) {
        String string2 = string + this.a00 + ", " + this.a01 + ", " + this.a02 + ", " + this.a03 + "\n";
        string2 = string2 + string + this.a10 + ", " + this.a11 + ", " + this.a12 + ", " + this.a13 + "\n";
        string2 = string2 + string + this.a20 + ", " + this.a21 + ", " + this.a22 + ", " + this.a23 + "\n";
        return string2;
    }

    public String toString() {
        return "" + this.a00 + " " + this.a01 + " " + this.a02 + " " + this.a03 + "   " + this.a10 + " " + this.a11 + " " + this.a12 + " " + this.a13 + "   " + this.a20 + " " + this.a21 + " " + this.a22 + " " + this.a23 + "   ";
    }

    public String toStringForAmira() {
        return "" + this.a00 + " " + this.a10 + " " + this.a20 + " 0 " + this.a01 + " " + this.a11 + " " + this.a21 + " 0 " + this.a02 + " " + this.a12 + " " + this.a22 + " 0 " + this.a03 + " " + this.a13 + " " + this.a23 + " 1";
    }

    public static void main(String[] stringArray) {
        FloatMatrix floatMatrix = FloatMatrix.rotateFromTo(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        floatMatrix.apply(0.0f, 0.0f, 1.0f);
        System.err.println("expect 0 0 1: " + floatMatrix.x + " " + floatMatrix.y + " " + floatMatrix.z);
        floatMatrix.apply(1.0f, 0.0f, 0.0f);
        System.err.println("expect 0 1 0: " + floatMatrix.x + " " + floatMatrix.y + " " + floatMatrix.z);
        floatMatrix.apply(0.0f, 1.0f, 0.0f);
        System.err.println("expect -1 0 0: " + floatMatrix.x + " " + floatMatrix.y + " " + floatMatrix.z);
    }
}

