/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import math3d.Point3d;
import vib.BenesNamedPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointList
implements Iterable<BenesNamedPoint> {
    private List<BenesNamedPoint> points;
    private List<PointListListener> listeners = new ArrayList<PointListListener>();

    public PointList() {
        this.points = new ArrayList<BenesNamedPoint>();
    }

    public void add(BenesNamedPoint benesNamedPoint) {
        this.points.add(benesNamedPoint);
        this.fireAdded(benesNamedPoint);
    }

    public void add(String string, double d, double d2, double d3) {
        this.add(new BenesNamedPoint(string, d, d2, d3));
    }

    public void add(double d, double d2, double d3) {
        this.add(this.getDefaultNameForNext(), d, d2, d3);
    }

    private String getDefaultNameForNext() {
        int n = this.points.size();
        int n2 = 1;
        if (n != 0) {
            String string = this.get((int)(this.points.size() - 1)).name;
            try {
                n2 = Integer.parseInt(string.substring(5, string.length())) + 1;
            }
            catch (Exception exception) {
                n2 = n;
            }
        }
        return "point" + n2;
    }

    public void remove(BenesNamedPoint benesNamedPoint) {
        int n = this.indexOf(benesNamedPoint);
        this.remove(n);
    }

    public void remove(int n) {
        if (n >= 0 && n < this.size()) {
            BenesNamedPoint benesNamedPoint = this.points.get(n);
            this.points.remove(n);
            this.fireRemoved(benesNamedPoint);
        }
    }

    public void clear() {
        while (this.size() > 0) {
            this.remove(0);
        }
    }

    public void rename(BenesNamedPoint benesNamedPoint, String string) {
        benesNamedPoint.name = string;
        this.fireRenamed(benesNamedPoint);
    }

    public void up(BenesNamedPoint benesNamedPoint) {
        int n = this.points.size();
        int n2 = this.points.indexOf(benesNamedPoint);
        this.points.remove(n2);
        this.points.add((n2 - 1 + n) % n, benesNamedPoint);
        this.fireReordered();
    }

    public void down(BenesNamedPoint benesNamedPoint) {
        int n = this.points.indexOf(benesNamedPoint);
        int n2 = this.points.size();
        this.points.remove(n);
        this.points.add((n + 1) % n2, benesNamedPoint);
        this.fireReordered();
    }

    public void highlight(BenesNamedPoint benesNamedPoint) {
        this.fireHighlighted(benesNamedPoint);
    }

    public void placePoint(BenesNamedPoint benesNamedPoint, double d, double d2, double d3) {
        benesNamedPoint.set(d, d2, d3);
        this.fireMoved(benesNamedPoint);
    }

    public BenesNamedPoint get(int n) {
        return this.points.get(n);
    }

    public int indexOf(BenesNamedPoint benesNamedPoint) {
        return this.points.indexOf(benesNamedPoint);
    }

    public int indexOfPointAt(double d, double d2, double d3, double d4) {
        Point3d point3d = new Point3d(d, d2, d3);
        d4 *= d4;
        for (int i = 0; i < this.points.size(); ++i) {
            BenesNamedPoint benesNamedPoint = this.points.get(i);
            if (!(point3d.distance2(benesNamedPoint) < d4)) continue;
            return i;
        }
        return -1;
    }

    public BenesNamedPoint pointAt(double d, double d2, double d3, double d4) {
        int n = this.indexOfPointAt(d, d2, d3, d4);
        if (n == -1) {
            return null;
        }
        return this.get(n);
    }

    public BenesNamedPoint[] toArray() {
        return this.points.toArray(new BenesNamedPoint[0]);
    }

    public int size() {
        return this.points.size();
    }

    public BenesNamedPoint get(String string) {
        for (BenesNamedPoint benesNamedPoint : this.points) {
            if (!benesNamedPoint.name.equals(string)) continue;
            return benesNamedPoint;
        }
        return null;
    }

    @Override
    public Iterator<BenesNamedPoint> iterator() {
        return this.points.iterator();
    }

    public PointList duplicate() {
        PointList pointList = new PointList();
        for (BenesNamedPoint benesNamedPoint : this) {
            pointList.add(new BenesNamedPoint(benesNamedPoint.name, benesNamedPoint.x, benesNamedPoint.y, benesNamedPoint.z));
        }
        return pointList;
    }

    public static PointList fromMask(ImagePlus imagePlus) {
        PointList pointList = new PointList();
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getStackSize();
        Calibration calibration = imagePlus.getCalibration();
        double d = calibration.pixelWidth;
        double d2 = calibration.pixelHeight;
        double d3 = calibration.pixelDepth;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray = (byte[])imagePlus.getStack().getPixels(i + 1);
            for (int j = 0; j < byArray.length; ++j) {
                if (byArray[j] != -1) continue;
                pointList.add(new BenesNamedPoint("point" + j, (double)(j % n) * d, (double)(j / n) * d2, (double)i * d3));
            }
        }
        return pointList;
    }

    public static PointList load(ImagePlus imagePlus) {
        FileInfo fileInfo = imagePlus.getOriginalFileInfo();
        if (fileInfo != null) {
            PointList pointList = PointList.load(fileInfo.directory, fileInfo.fileName + ".points", true);
            return pointList;
        }
        return PointList.load(null, null, true);
    }

    public static PointList load(String string, String string2, boolean bl) {
        PointList pointList;
        String string3 = string + File.separatorChar + string2;
        if (bl) {
            pointList = new OpenDialog("Open points annotation file", string, string2);
            if (pointList.getFileName() == null) {
                return null;
            }
            string3 = pointList.getDirectory() + pointList.getFileName();
        }
        pointList = new PointList();
        try {
            String string4;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string3));
            while ((string4 = bufferedReader.readLine()) != null) {
                BenesNamedPoint benesNamedPoint = BenesNamedPoint.fromLine(string4);
                if (benesNamedPoint == null) continue;
                pointList.add(benesNamedPoint);
            }
            return pointList;
        }
        catch (FileNotFoundException fileNotFoundException) {
            IJ.showMessage((String)("Could not find file " + string3));
        }
        catch (IOException iOException) {
            IJ.showMessage((String)("Could not read file " + string3));
        }
        return null;
    }

    public void save(String string, String string2) {
        String string3 = string2 + ".points";
        SaveDialog saveDialog = new SaveDialog("Save points annotation file as...", string, string3, ".points");
        if (saveDialog.getFileName() == null) {
            return;
        }
        String string4 = saveDialog.getDirectory() + saveDialog.getFileName();
        File file = new File(string4);
        if (file != null && file.exists() && !IJ.showMessageWithCancel((String)"Save points annotation file", (String)("The file " + string4 + " already exists.\n" + "Do you want to replace it?"))) {
            return;
        }
        IJ.showStatus((String)("Saving point annotations to " + string4));
        try {
            PrintStream printStream = new PrintStream(string4);
            for (BenesNamedPoint benesNamedPoint : this.points) {
                if (!benesNamedPoint.set) continue;
                printStream.println(benesNamedPoint.toYAML() + "\n");
            }
            printStream.close();
        }
        catch (IOException iOException) {
            IJ.error((String)("Error saving to: " + string4 + "\n" + iOException));
        }
        IJ.showStatus((String)"Saved point annotations.");
    }

    public static ArrayList<String> pointsInBothAsString(PointList pointList, PointList pointList2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (BenesNamedPoint benesNamedPoint : pointList) {
            for (BenesNamedPoint benesNamedPoint2 : pointList2) {
                if (!benesNamedPoint.name.equals(benesNamedPoint2.name)) continue;
                arrayList.add(benesNamedPoint.name);
                continue block0;
            }
        }
        return arrayList;
    }

    public static PointList pointsInBoth(PointList pointList, PointList pointList2) {
        PointList pointList3 = new PointList();
        block0: for (BenesNamedPoint benesNamedPoint : pointList) {
            for (BenesNamedPoint benesNamedPoint2 : pointList2) {
                if (!benesNamedPoint.name.equals(benesNamedPoint2.name)) continue;
                pointList3.add(benesNamedPoint);
                continue block0;
            }
        }
        return pointList3;
    }

    public void print() {
        for (BenesNamedPoint benesNamedPoint : this.points) {
            System.out.println(benesNamedPoint.toString());
        }
    }

    public void addPointListListener(PointListListener pointListListener) {
        this.listeners.add(pointListListener);
    }

    public void removePointListListener(PointListListener pointListListener) {
        this.listeners.remove(pointListListener);
    }

    private void fireAdded(BenesNamedPoint benesNamedPoint) {
        for (PointListListener pointListListener : this.listeners) {
            pointListListener.added(benesNamedPoint);
        }
    }

    private void fireRemoved(BenesNamedPoint benesNamedPoint) {
        for (PointListListener pointListListener : this.listeners) {
            pointListListener.removed(benesNamedPoint);
        }
    }

    private void fireRenamed(BenesNamedPoint benesNamedPoint) {
        for (PointListListener pointListListener : this.listeners) {
            pointListListener.renamed(benesNamedPoint);
        }
    }

    private void fireMoved(BenesNamedPoint benesNamedPoint) {
        for (PointListListener pointListListener : this.listeners) {
            pointListListener.moved(benesNamedPoint);
        }
    }

    private void fireHighlighted(BenesNamedPoint benesNamedPoint) {
        for (PointListListener pointListListener : this.listeners) {
            pointListListener.highlighted(benesNamedPoint);
        }
    }

    private void fireReordered() {
        for (PointListListener pointListListener : this.listeners) {
            pointListListener.reordered();
        }
    }

    public static interface PointListListener {
        public void added(BenesNamedPoint var1);

        public void removed(BenesNamedPoint var1);

        public void renamed(BenesNamedPoint var1);

        public void moved(BenesNamedPoint var1);

        public void highlighted(BenesNamedPoint var1);

        public void reordered();
    }
}

