/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import math3d.Point3d;
import pal.math.ConjugateDirectionSearch;
import pal.math.MultivariateFunction;
import util.StupidLog;
import vib.FastMatrix;
import vib.VIB;

public abstract class RegistrationOptimizer {
    protected boolean verbose = false;
    double[] eulerParameters;
    double[][] cachedInitialGuesses;
    Point3d origC;
    Point3d transC;
    double translateMax;
    double angleMax;

    public abstract void getInitialCenters();

    public abstract double calculateBadness(FastMatrix var1);

    public FastMatrix doRegister(double d) {
        Object object;
        int n;
        if (this.verbose) {
            VIB.println("tol: " + d);
        }
        ConjugateDirectionSearch conjugateDirectionSearch = new ConjugateDirectionSearch();
        if (IJ.getInstance() != null && this.verbose) {
            conjugateDirectionSearch.prin = 1;
        }
        if (this.eulerParameters == null) {
            this.eulerParameters = this.searchInitialEulerParams()[0];
        }
        double[] dArray = (double[])this.eulerParameters.clone();
        double[] dArray2 = new double[6];
        for (n = 0; n < 6; ++n) {
            dArray2[n] = Double.MAX_VALUE;
        }
        n = 0;
        Refinement refinement = new Refinement(this.eulerParameters);
        refinement.showStatus = true;
        double[] dArray3 = new double[6];
        do {
            conjugateDirectionSearch.optimize(refinement, dArray3, d, d);
            dArray3 = refinement.best;
            if (Arrays.equals(dArray3, dArray2)) {
                StupidLog.log("       Got stuck: x is (and was): " + dArray3[0] + ", " + dArray3[1] + ", " + dArray3[2] + ", " + dArray3[3] + ", " + dArray3[4] + ", " + dArray3[5]);
                StupidLog.log("                   maxAdjust was: " + refinement.maxAdjust);
                StupidLog.log("                translateMax was: " + this.translateMax);
                StupidLog.log("                          tol is: " + d);
                object = dArray;
                StupidLog.log("    originalEulerParameters were: " + (double)object[0] + ", " + (double)object[1] + ", " + (double)object[2] + ", " + (double)object[3] + ", " + (double)object[4] + ", " + (double)object[5] + ", " + (double)object[6] + ", " + (double)object[7] + ", " + (double)object[8]);
                n = 1;
                break;
            }
            System.arraycopy(dArray3, 0, dArray2, 0, 6);
            this.eulerParameters = refinement.adjustInitial(dArray3);
            if (!this.verbose) continue;
            VIB.println("eulerParameters: " + this.eulerParameters[0] + ", " + this.eulerParameters[1] + ", " + this.eulerParameters[2] + "; " + this.eulerParameters[3] + ", " + this.eulerParameters[4] + ", " + this.eulerParameters[5] + "; " + this.eulerParameters[6] + ", " + this.eulerParameters[7] + ", " + this.eulerParameters[8]);
        } while (refinement.maxAdjust > this.translateMax / 8.0);
        if (n != 0) {
            object = new Refinement(dArray);
            for (int i = 0; i < dArray3.length; ++i) {
                dArray3[i] = 0.0;
            }
            return ((Refinement)object).getMatrix(dArray3);
        }
        return refinement.getMatrix(dArray3);
    }

    protected double[][] searchInitialEulerParams() {
        Refinement refinement;
        int n;
        if (this.cachedInitialGuesses != null) {
            return this.cachedInitialGuesses;
        }
        double[][] dArray = new double[24][9];
        this.angleMax = 0.7853981633974483;
        this.translateMax = 20.0;
        ConjugateDirectionSearch conjugateDirectionSearch = new ConjugateDirectionSearch();
        conjugateDirectionSearch.step = 10.0;
        double[][] dArray2 = new double[24][9];
        this.getInitialCenters();
        dArray[0][3] = this.origC.x - this.transC.x;
        dArray[0][4] = this.origC.y - this.transC.y;
        dArray[0][5] = this.origC.z - this.transC.z;
        dArray[0][6] = this.transC.x;
        dArray[0][7] = this.transC.y;
        dArray[0][8] = this.transC.z;
        for (int i = 1; i < 24; ++i) {
            System.arraycopy(dArray[0], 0, dArray[i], 0, 9);
        }
        double d = 1.5707963267948966;
        for (int i = 0; i < 4; ++i) {
            int n2;
            for (n2 = 0; n2 < 4; ++n2) {
                dArray[i * 6 + n2][0] = (double)i * d;
                dArray[i * 6 + n2][1] = (double)n2 * d;
            }
            for (n2 = 0; n2 < 2; ++n2) {
                dArray[i * 6 + 4 + n2][0] = (double)i * d;
                dArray[i * 6 + 4 + n2][1] = (double)(n2 * 2 + 1) * d;
                dArray[i * 6 + 4 + n2][2] = d;
            }
        }
        ArrayList<Refinement> arrayList = new ArrayList<Refinement>();
        double[][] dArray3 = new double[24][6];
        for (n = 0; n < 24; ++n) {
            if (this.verbose) {
                VIB.showStatus("Trying orientation " + (n + 1) + " of 24...");
            }
            refinement = new Refinement(dArray[n]);
            conjugateDirectionSearch.optimize(refinement, dArray3[n], 5.0, 5.0);
            arrayList.add(refinement);
            if (!this.verbose) continue;
            VIB.showProgress(n + 1, 24);
        }
        Collections.sort(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            refinement = (Refinement)arrayList.get(n);
            dArray3[n] = refinement.best;
            dArray2[n] = refinement.adjustInitial(dArray3[n]);
            if (!this.verbose) continue;
            VIB.println(n + 1 + " eulerParameters (" + refinement.min + "): " + dArray2[n][0] + ", " + dArray2[n][1] + ", " + dArray2[n][2] + "; " + dArray2[n][3] + ", " + dArray2[n][4] + ", " + dArray2[n][5] + "; " + dArray2[n][6] + ", " + dArray2[n][7] + ", " + dArray2[n][8]);
        }
        this.cachedInitialGuesses = dArray2;
        return dArray2;
    }

    public static final FastMatrix getEulerMatrix(double[] dArray) {
        return RegistrationOptimizer.getEulerMatrix(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7], dArray[8]);
    }

    public static final FastMatrix getEulerMatrix(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        FastMatrix fastMatrix = FastMatrix.translate(d4, d5, d6);
        FastMatrix fastMatrix2 = FastMatrix.rotateEulerAt(d, d2, d3, d7, d8, d9);
        return fastMatrix.times(fastMatrix2);
    }

    class Refinement
    implements MultivariateFunction,
    Comparable {
        public boolean showStatus = false;
        double min;
        double[] best;
        double[] initial;
        double angleFactor;
        double maxAdjust;

        public Refinement(double[] dArray) {
            if (RegistrationOptimizer.this.verbose) {
                VIB.println("translateMax: " + RegistrationOptimizer.this.translateMax + ", angleMax: " + RegistrationOptimizer.this.angleMax);
            }
            this.min = Double.MAX_VALUE;
            this.initial = dArray;
            this.evaluate(new double[9]);
            this.angleFactor = RegistrationOptimizer.this.angleMax / RegistrationOptimizer.this.translateMax;
        }

        public FastMatrix getMatrix(double[] dArray) {
            return RegistrationOptimizer.getEulerMatrix(dArray[0] * this.angleFactor + this.initial[0], dArray[1] * this.angleFactor + this.initial[1], dArray[2] * this.angleFactor + this.initial[2], dArray[3] + this.initial[3], dArray[4] + this.initial[4], dArray[5] + this.initial[5], this.initial[6], this.initial[7], this.initial[8]);
        }

        public double evaluate(double[] dArray) {
            double d = RegistrationOptimizer.this.calculateBadness(this.getMatrix(dArray));
            if (d < this.min) {
                this.best = (double[])dArray.clone();
                this.min = d;
                if (this.showStatus) {
                    VIB.showStatus("difference: " + this.min);
                }
            }
            return d;
        }

        public int getNumArguments() {
            return 6;
        }

        public double getLowerBound(int n) {
            return n < 3 ? -RegistrationOptimizer.this.angleMax / this.angleFactor : -RegistrationOptimizer.this.translateMax;
        }

        public double getUpperBound(int n) {
            return n < 3 ? RegistrationOptimizer.this.angleMax / this.angleFactor : RegistrationOptimizer.this.translateMax;
        }

        public double evaluate(double[] dArray, double[] dArray2) {
            double d = this.evaluate(dArray);
            this.computeGradient(dArray, dArray2);
            return d;
        }

        public void computeGradient(double[] dArray, double[] dArray2) {
            for (int i = 0; i < 6; ++i) {
                double d = dArray[i];
                dArray[i] = d + 1.0;
                double d2 = this.evaluate(dArray);
                dArray[i] = d - 1.0;
                double d3 = this.evaluate(dArray);
                dArray[i] = d;
                dArray2[i] = (d2 - d3) / 2.0;
            }
        }

        public double[] adjustInitial(double[] dArray) {
            this.maxAdjust = 0.0;
            for (int i = 0; i < 6; ++i) {
                if (i < 3) {
                    int n = i;
                    this.initial[n] = this.initial[n] + dArray[i] * this.angleFactor;
                } else {
                    int n = i;
                    this.initial[n] = this.initial[n] + dArray[i];
                }
                if (Math.abs(dArray[i]) > this.maxAdjust) {
                    this.maxAdjust = Math.abs(dArray[i]);
                }
                dArray[i] = 0.0;
            }
            return this.initial;
        }

        public int compareTo(Object object) {
            Refinement refinement = (Refinement)object;
            if (this.min < refinement.min) {
                return -1;
            }
            if (this.min > refinement.min) {
                return 1;
            }
            return 0;
        }
    }
}

