/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import vib.InterpolatedImage;

public class Relabel_
implements PlugInFilter,
ActionListener {
    ImagePlus image;
    GenericDialog gd;
    String[] materialList;

    public void run(ImageProcessor imageProcessor) {
        if (!AmiraParameters.isAmiraLabelfield(this.image)) {
            IJ.error((String)"No labelfield!");
            return;
        }
        AmiraParameters amiraParameters = new AmiraParameters(this.image);
        this.materialList = amiraParameters.getMaterialList();
        this.gd = new GenericDialog("Relabel Parameters");
        for (int i = 0; i < this.materialList.length; ++i) {
            this.gd.addChoice(this.materialList[i] + ":", this.materialList, this.materialList[i]);
        }
        Button button = new Button("Switch sides");
        button.addActionListener(this);
        Panel panel = new Panel();
        panel.add(button);
        this.gd.addPanel(panel);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return;
        }
        int[] nArray = new int[this.materialList.length];
        for (int i = 0; i < this.materialList.length; ++i) {
            nArray[i] = this.gd.getNextChoiceIndex();
        }
        InterpolatedImage interpolatedImage = new InterpolatedImage(this.image);
        for (int i = 0; i < interpolatedImage.d; ++i) {
            for (int j = 0; j < interpolatedImage.h; ++j) {
                for (int k = 0; k < interpolatedImage.w; ++k) {
                    int n = interpolatedImage.getNoInterpol(k, j, i);
                    interpolatedImage.set(k, j, i, nArray[n]);
                }
            }
            IJ.showProgress((int)(i + 1), (int)interpolatedImage.d);
        }
        this.image.updateAndDraw();
    }

    public int getOppositeMaterial(int n) {
        String string;
        String string2 = this.materialList[n];
        if (string2.endsWith("_r")) {
            string = "l";
        } else if (string2.endsWith("_l")) {
            string = "r";
        } else {
            return -1;
        }
        string = string2.substring(0, string2.length() - 1) + string;
        for (int i = 0; i < this.materialList.length; ++i) {
            if (!this.materialList[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Vector vector = this.gd.getChoices();
        for (int i = 0; i < this.materialList.length; ++i) {
            Choice choice = (Choice)vector.get(i);
            int n = this.getOppositeMaterial(choice.getSelectedIndex());
            if (n < 0) continue;
            choice.select(n);
        }
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 3;
    }
}

