/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import vib.InterpolatedImage;

public class Resample_
implements PlugInFilter {
    ImagePlus image;
    boolean verbose = false;

    private static int getPixel(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public void run(ImageProcessor imageProcessor) {
        ImagePlus imagePlus;
        GenericDialog genericDialog = new GenericDialog("Parameters");
        genericDialog.addNumericField("Factor x", 2.0, 0);
        genericDialog.addNumericField("Factor y", 2.0, 0);
        genericDialog.addNumericField("Factor z", 2.0, 0);
        genericDialog.addCheckbox("MinEntropy", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n = (int)genericDialog.getNextNumber();
        int n2 = (int)genericDialog.getNextNumber();
        int n3 = (int)genericDialog.getNextNumber();
        boolean bl = genericDialog.getNextBoolean();
        ImagePlus imagePlus2 = imagePlus = bl ? Resample_.resampleMinEnt(this.image, n, n2, n3) : Resample_.resample(this.image, n, n2, n3);
        if (AmiraParameters.isAmiraMesh(this.image)) {
            new AmiraParameters(this.image).setParameters(imagePlus);
        } else {
            Object object = this.image.getProperty("Info");
            if (object != null) {
                imagePlus.setProperty("Info", object);
            }
        }
        imagePlus.show();
    }

    public static ImagePlus resample(ImagePlus imagePlus, int n, int n2, int n3) {
        Accumulator accumulator = null;
        int n4 = imagePlus.getType();
        if (imagePlus.getProcessor().isColorLut()) {
            if (n4 == 0 || n4 == 3) {
                accumulator = new MaxLikelihood(255);
            } else if (n4 == 1) {
                accumulator = new MaxLikelihood(65535);
            }
        } else {
            accumulator = n4 == 4 ? new IntAverager() : new Averager();
        }
        return Resample_.resample(imagePlus, n, n2, n3, accumulator);
    }

    public static ImagePlus resample(ImagePlus imagePlus, int n) {
        return Resample_.resample(imagePlus, n, n, n);
    }

    public static ImagePlus resampleMinEnt(ImagePlus imagePlus, int n, int n2, int n3) {
        return Resample_.resample(imagePlus, n, n2, n3, new MinEntropy(imagePlus));
    }

    public static ImagePlus resampleMinEnt(ImagePlus imagePlus, int n) {
        return Resample_.resampleMinEnt(imagePlus, n, n, n);
    }

    public static ImagePlus resample(ImagePlus imagePlus, int n, int n2, int n3, Accumulator accumulator) {
        int n4 = imagePlus.getType();
        ImageStack imageStack = imagePlus.getStack();
        int n5 = imagePlus.getWidth();
        int n6 = imagePlus.getHeight();
        int n7 = imageStack.getSize();
        ImageStack imageStack2 = new ImageStack(n5 / n, n6 / n2, imageStack.getColorModel());
        for (int i = 0; i < n7; i += n3) {
            int n8;
            int n9 = i + n3 < n7 ? n3 : n7 - i;
            Object object = null;
            Object object2 = null;
            Object object3 = null;
            if (n4 == 0 || n4 == 3) {
                object = new byte[n9][];
                for (n8 = 0; n8 < n9; ++n8) {
                    object[n8] = (byte[])imageStack.getProcessor(i + n8 + 1).getPixels();
                }
            } else if (n4 == 1) {
                object2 = new short[n9][];
                for (n8 = 0; n8 < n9; ++n8) {
                    object2[n8] = (short[])imageStack.getProcessor(i + n8 + 1).getPixels();
                }
            } else if (n4 == 4) {
                object3 = new int[n9][];
                for (n8 = 0; n8 < n9; ++n8) {
                    object3[n8] = (int[])imageStack.getProcessor(i + n8 + 1).getPixels();
                }
            } else {
                IJ.error((String)"Resample only currently works on 8 bit and 16 bit images.");
                return null;
            }
            byte[] byArray = null;
            short[] sArray = null;
            int[] nArray = null;
            int n10 = (1 + (n5 - 1) / n) * (1 + (n6 - 1) / n2);
            if (n4 == 0 || n4 == 3) {
                byArray = new byte[n10];
            } else if (n4 == 1) {
                sArray = new short[n10];
            } else if (n4 == 4) {
                nArray = new int[n10];
            }
            for (int j = 0; j < n6; j += n2) {
                for (int k = 0; k < n5; k += n) {
                    int n11;
                    int n12;
                    int n13;
                    int n14 = k + n < n5 ? n : n5 - k;
                    int n15 = j + n2 < n6 ? n2 : n6 - j;
                    accumulator.reset();
                    if (n4 == 0 || n4 == 3) {
                        for (n13 = 0; n13 < n14; ++n13) {
                            for (n12 = 0; n12 < n15; ++n12) {
                                for (n11 = 0; n11 < n9; ++n11) {
                                    accumulator.add(Resample_.getPixel(object[n11], k + n13 + n5 * (j + n12)));
                                }
                            }
                        }
                        byArray[k / n + n5 / n * (j / n2)] = (byte)accumulator.get();
                        continue;
                    }
                    if (n4 == 1) {
                        for (n13 = 0; n13 < n14; ++n13) {
                            for (n12 = 0; n12 < n15; ++n12) {
                                for (n11 = 0; n11 < n9; ++n11) {
                                    accumulator.add(object2[n11][k + n13 + n5 * (j + n12)]);
                                }
                            }
                        }
                        sArray[k / n + n5 / n * (j / n2)] = (short)accumulator.get();
                        continue;
                    }
                    if (n4 != 4) continue;
                    for (n13 = 0; n13 < n14; ++n13) {
                        for (n12 = 0; n12 < n15; ++n12) {
                            for (n11 = 0; n11 < n9; ++n11) {
                                accumulator.add(object3[n11][k + n13 + n5 * (j + n12)]);
                            }
                        }
                    }
                    nArray[k / n + n5 / n * (j / n2)] = accumulator.get();
                }
                IJ.showProgress((int)(i * n6 + j + 1), (int)(n6 * n7));
            }
            if (n4 == 0 || n4 == 3) {
                imageStack2.addSlice(null, (Object)byArray);
                continue;
            }
            if (n4 == 1) {
                imageStack2.addSlice(null, (Object)sArray);
                continue;
            }
            if (n4 != 4) continue;
            imageStack2.addSlice(null, (Object)nArray);
        }
        ImagePlus imagePlus2 = new ImagePlus(imagePlus.getTitle() + " resampled", imageStack2);
        if (AmiraParameters.isAmiraMesh(imagePlus)) {
            AmiraParameters amiraParameters = new AmiraParameters(imagePlus);
            amiraParameters.setParameters(imagePlus2);
        }
        Calibration calibration = imagePlus.getCalibration().copy();
        calibration.pixelWidth *= (double)imagePlus.getWidth() / (double)imagePlus2.getWidth();
        calibration.pixelHeight *= (double)imagePlus.getHeight() / (double)imagePlus2.getHeight();
        calibration.pixelDepth *= (double)imagePlus.getStack().getSize() / (double)imagePlus2.getStack().getSize();
        imagePlus2.setCalibration(calibration);
        return imagePlus2;
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 151;
    }

    public static class MinEntropy
    implements Accumulator {
        int[] histogram;
        int currentValue;

        public MinEntropy(ImagePlus imagePlus) {
            this(new InterpolatedImage(imagePlus));
        }

        public MinEntropy(InterpolatedImage interpolatedImage) {
            block7: {
                InterpolatedImage.Iterator iterator;
                int n;
                block6: {
                    this.currentValue = -1;
                    n = interpolatedImage.image.getType();
                    if (n == 0 || n == 3) {
                        this.histogram = new int[256];
                    } else if (n == 1) {
                        this.histogram = new int[65536];
                    } else {
                        IJ.error((String)"MinEntropy only works on 8bit or 16bit gray images.");
                        return;
                    }
                    iterator = interpolatedImage.iterator();
                    if (n != 0 && n != 3) break block6;
                    while (iterator.next() != null) {
                        int n2 = interpolatedImage.getNoInterpol(iterator.i, iterator.j, iterator.k);
                        this.histogram[n2] = this.histogram[n2] + 1;
                    }
                    break block7;
                }
                if (n != 1) break block7;
                while (iterator.next() != null) {
                    short s = interpolatedImage.getNoInterpolShort(iterator.i, iterator.j, iterator.k);
                    this.histogram[s] = this.histogram[s] + 1;
                }
            }
        }

        public void reset() {
            this.currentValue = -1;
        }

        public void add(int n) {
            if (this.currentValue < 0 || this.histogram[n] < this.histogram[this.currentValue]) {
                this.currentValue = n;
            }
        }

        public int get() {
            return this.currentValue;
        }
    }

    public static class MaxLikelihood
    implements Accumulator {
        int[] histo;
        int[] empty;
        int max;
        int indexOfHighest = -1;
        int highest = -1;

        MaxLikelihood(int n) {
            this.max = n;
            this.histo = new int[n + 1];
            this.empty = new int[n + 1];
        }

        MaxLikelihood() {
            this(255);
        }

        public void reset() {
            this.highest = -1;
            this.indexOfHighest = -1;
            System.arraycopy(this.empty, 0, this.histo, 0, this.max + 1);
            this.max = 0;
        }

        public void add(int n) {
            int n2 = n;
            this.histo[n2] = this.histo[n2] + 1;
            if (this.histo[n] > this.highest) {
                this.highest = this.histo[n];
                this.indexOfHighest = n;
            }
        }

        public int get() {
            return this.indexOfHighest;
        }

        public String toString() {
            String string = "";
            for (int i = 0; i <= this.max; ++i) {
                if (i > 0) {
                    string = string + " ";
                }
                string = string + this.histo[i];
            }
            string = string + ": " + this.get();
            return string;
        }
    }

    public static class IntAverager
    implements Accumulator {
        long count;
        long cumulR;
        long cumulG;
        long cumulB;

        public void reset() {
            this.cumulB = 0L;
            this.cumulG = 0L;
            this.cumulR = 0L;
            this.count = 0L;
        }

        public void add(int n) {
            ++this.count;
            this.cumulR += (long)((n & 0xFF0000) >> 16);
            this.cumulG += (long)((n & 0xFF00) >> 8);
            this.cumulB += (long)(n & 0xFF);
        }

        public int get() {
            return (int)((this.cumulR / this.count << 16) + (this.cumulG / this.count << 8) + this.cumulB / this.count);
        }
    }

    public static class Averager
    implements Accumulator {
        long count;
        long cumul;

        public void reset() {
            this.count = 0L;
            this.cumul = 0L;
        }

        public void add(int n) {
            this.cumul += (long)n;
            ++this.count;
        }

        public int get() {
            return (int)(this.cumul / this.count);
        }
    }

    private static interface Accumulator {
        public void reset();

        public void add(int var1);

        public int get();
    }
}

