/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import distance.Correlation;
import distance.Euclidean;
import distance.MutualInformation;
import distance.PixelPairs;
import distance.Thresholded;
import distance.TwoValues;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Choice;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.StringTokenizer;
import math3d.Point3d;
import vib.FastMatrix;
import vib.InterpolatedImage;
import vib.RegistrationOptimizer;
import vib.TransformedImage;
import vib.VIB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RigidRegistration_
implements PlugInFilter {
    ImagePlus image;
    GenericDialog gd;
    String[] materials1;
    String[] materials2;
    private boolean verbose = false;
    static FastMatrix lastResult;

    public static int guessLevelFromWidth(int n) {
        int n2 = 0;
        while (n >> n2 > 20) {
            ++n2;
        }
        return n2;
    }

    public void run(ImageProcessor imageProcessor) {
        Object object;
        int n;
        Object object2;
        this.verbose = true;
        this.gd = new GenericDialog("Registration Parameters");
        this.gd.addMessage("Transforming: " + this.image.getTitle());
        this.gd.addStringField("initialTransform", "", 30);
        this.gd.addNumericField("n initial positions to try", 1.0, 0);
        int n2 = 0;
        while (this.image.getWidth() >> n2 > 20) {
            ++n2;
        }
        this.gd.addNumericField("tolerance", 1.0, 3);
        this.gd.addNumericField("level", (double)n2, 0);
        this.gd.addNumericField("stopLevel", (double)(n2 > 2 ? 2 : n2), 0);
        this.gd.addStringField("materialCenterAndBBox", "", 30);
        this.gd.addCheckbox("noOptimization", false);
        this.gd.addCheckbox("showTransformed", false);
        this.gd.addCheckbox("showDifferenceImage", false);
        this.gd.addCheckbox("Fast but inaccurate", false);
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error((String)"No images open");
            return;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = WindowManager.getImage((int)nArray[i]).getTitle();
        }
        ArrayList<ImagePlus> arrayList = new ArrayList<ImagePlus>();
        boolean bl = AmiraParameters.isAmiraLabelfield(this.image);
        if (bl) {
            object2 = new AmiraParameters(this.image);
            this.materials1 = object2.getMaterialList();
            this.gd.addChoice("material", this.materials1, this.materials1[0]);
            AmiraParameters.addAmiraLabelsList(this.gd, "Template");
            this.gd.addChoice("templateMaterial", this.materials1, this.materials1[0]);
            this.getMaterials2();
        } else {
            this.gd.addChoice("Template", stringArray, WindowManager.getCurrentImage().getTitle());
            object2 = new String[]{"Euclidean", "MutualInfo", "Threshold55", "Threshold155", "Correlation"};
            this.gd.addChoice("measure", object2, "Euclidean");
            this.gd.addMessage("Also transform these images:");
            for (n = 0; n < nArray.length; ++n) {
                ImagePlus imagePlus = WindowManager.getImage((int)nArray[n]);
                if (imagePlus.getWidth() != this.image.getWidth() || imagePlus.getHeight() != this.image.getHeight() || imagePlus.getStackSize() != this.image.getStackSize()) continue;
                arrayList.add(imagePlus);
                this.gd.addCheckbox(imagePlus.getTitle(), false);
            }
        }
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return;
        }
        object2 = this.gd.getNextString();
        n = (int)this.gd.getNextNumber();
        double d = this.gd.getNextNumber();
        n2 = (int)this.gd.getNextNumber();
        int n3 = (int)this.gd.getNextNumber();
        String string = this.gd.getNextString();
        boolean bl2 = this.gd.getNextBoolean();
        boolean bl3 = this.gd.getNextBoolean();
        boolean bl4 = this.gd.getNextBoolean();
        boolean bl5 = this.gd.getNextBoolean();
        int n4 = bl ? this.gd.getNextChoiceIndex() : -1;
        ImagePlus imagePlus = WindowManager.getImage((String)this.gd.getNextChoice());
        int n5 = bl ? this.gd.getNextChoiceIndex() : -1;
        TransformedImage transformedImage = new TransformedImage(imagePlus, this.image);
        ArrayList<ImagePlus> arrayList2 = new ArrayList<ImagePlus>();
        int n6 = imagePlus.getType();
        int n7 = this.image.getType();
        int n8 = imagePlus.getBitDepth();
        int n9 = this.image.getBitDepth();
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = this.image.getStack();
        if (n8 != n9) {
            IJ.error((String)"Images must both be of the same bit depth");
            return;
        }
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        if (n8 != 8) {
            if (n8 == 16) {
                object = transformedImage.getValuesRange();
                f = object[0];
                f2 = object[1];
            } else {
                IJ.error((String)("Unsupported bit depth: " + n8));
                return;
            }
        }
        if (bl) {
            transformedImage.measure = new TwoValues(n4, n5);
            if (this.verbose) {
                VIB.println("working on materials " + n4 + " " + n5);
            }
        } else {
            int n10 = this.gd.getNextChoiceIndex();
            if (n10 == 1) {
                if (n8 == 8) {
                    transformedImage.measure = new MutualInformation();
                } else if (n8 == 16) {
                    transformedImage.measure = new MutualInformation(f, f2, 256);
                }
            } else {
                transformedImage.measure = n10 == 2 ? new Thresholded(55) : (n10 == 3 ? new Thresholded(155) : (n10 == 4 ? new Correlation() : new Euclidean()));
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!this.gd.getNextBoolean()) continue;
                arrayList2.add((ImagePlus)arrayList.get(i));
            }
        }
        object = this.rigidRegistration(transformedImage, string, (String)object2, n4, n5, bl2, n2, n3, d, n, bl3, bl4, bl5, arrayList2);
        if (!Interpreter.isBatchMode() && this.verbose) {
            WindowManager.setWindow((Frame)new TextWindow("Matrix", ((FastMatrix)object).toStringForAmira(), 550, 150));
        }
        lastResult = object;
    }

    public FastMatrix rigidRegistration(TransformedImage transformedImage, String string, String string2, int n, int n2, boolean bl, int n3, int n4, double d, int n5, boolean bl2, boolean bl3, boolean bl4, ArrayList<ImagePlus> arrayList) {
        Object object;
        Object object2;
        FastMatrix fastMatrix;
        if (n >= 0) {
            transformedImage.narrowSearchToMaterial(n, 10);
        }
        Point3d point3d = null;
        if (string != null && !string.equals("")) {
            point3d = this.parseMaterialBBox(transformedImage, string);
        }
        double[] dArray = null;
        if (string2 != null && !string2.equals("")) {
            dArray = new double[9];
            try {
                if (point3d == null) {
                    point3d = this.getCenter(transformedImage.transform, n);
                }
                fastMatrix = FastMatrix.parseMatrix(string2);
                if (n2 >= 0) {
                    fastMatrix.apply(point3d);
                    object2 = this.getCenter(transformedImage.orig, n2);
                    object2 = ((Point3d)object2).minus(fastMatrix.getResult());
                    fastMatrix = FastMatrix.translate(((Point3d)object2).x, ((Point3d)object2).y, ((Point3d)object2).z).times(fastMatrix);
                }
                fastMatrix.guessEulerParameters(dArray, point3d);
            }
            catch (Exception exception) {
                object2 = new StringTokenizer(string2);
                for (int i = 0; i < 9; ++i) {
                    dArray[i] = Double.parseDouble(((StringTokenizer)object2).nextToken());
                }
            }
        }
        if (!bl) {
            object2 = bl4 ? new FastOptimizer(transformedImage, n3, n4, d, this.verbose) : new Optimizer(transformedImage, n3, n4, d, this.verbose);
            ((Optimizer)object2).eulerParameters = dArray;
            if (((Optimizer)object2).eulerParameters == null) {
                FastMatrix[] fastMatrixArray = new FastMatrix[n5];
                object = new double[n5];
                for (int i = 0; i < n5; ++i) {
                    ((Optimizer)object2).eulerParameters = null;
                    fastMatrixArray[i] = ((Optimizer)object2).doRegister(n3 - n4, i);
                    object[i] = ((Optimizer)object2).calculateBadness(fastMatrixArray[i]);
                }
                Object object3 = Double.MAX_VALUE;
                int n6 = -1;
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (!(object[i] < object3)) continue;
                    object3 = object[i];
                    n6 = i;
                }
                fastMatrix = fastMatrixArray[n6];
                if (this.verbose) {
                    System.out.println("winner was " + (n6 + 1) + " with matrix" + fastMatrix);
                    System.out.println("... and score: " + (double)object[n6]);
                }
            } else {
                fastMatrix = ((Optimizer)object2).doRegister(n3 - n4);
            }
            object2 = null;
        } else {
            try {
                fastMatrix = FastMatrix.parseMatrix(string2);
            }
            catch (Exception exception) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                for (int i = 0; i < 9; ++i) {
                    dArray[i] = Double.parseDouble(stringTokenizer.nextToken());
                }
                fastMatrix = RegistrationOptimizer.getEulerMatrix(dArray);
            }
        }
        transformedImage.setTransformation(fastMatrix);
        if (this.verbose) {
            VIB.println(fastMatrix.toString());
        }
        if (bl2) {
            transformedImage.getTransformed().show();
        }
        if (bl3) {
            transformedImage.getDifferenceImage().show();
        }
        object2 = transformedImage.getTemplate();
        PixelPairs pixelPairs = transformedImage.measure;
        transformedImage = null;
        System.gc();
        System.gc();
        if (arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                ImagePlus imagePlus = (ImagePlus)object.next();
                TransformedImage transformedImage2 = new TransformedImage((ImagePlus)object2, imagePlus);
                transformedImage2.measure = pixelPairs;
                transformedImage2.measure.reset();
                transformedImage2.setTransformation(fastMatrix);
                ImagePlus imagePlus2 = transformedImage2.getTransformed();
                transformedImage2 = null;
                System.gc();
                System.gc();
                imagePlus2.setTitle("Transformed " + imagePlus.getTitle());
                imagePlus2.show();
            }
        }
        return fastMatrix;
    }

    Point3d parseMaterialBBox(TransformedImage transformedImage, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            Point3d point3d = new Point3d();
            point3d.x = Double.parseDouble(stringTokenizer.nextToken());
            point3d.y = Double.parseDouble(stringTokenizer.nextToken());
            point3d.z = Double.parseDouble(stringTokenizer.nextToken());
            double d = Double.parseDouble(stringTokenizer.nextToken());
            double d2 = Double.parseDouble(stringTokenizer.nextToken());
            double d3 = Double.parseDouble(stringTokenizer.nextToken());
            double d4 = Double.parseDouble(stringTokenizer.nextToken());
            double d5 = Double.parseDouble(stringTokenizer.nextToken());
            double d6 = Double.parseDouble(stringTokenizer.nextToken());
            FastMatrix fastMatrix = transformedImage.fromOrig.inverse();
            fastMatrix.apply(d, d3, d5);
            Point3d point3d2 = fastMatrix.getResult();
            fastMatrix.apply(d2, d4, d6);
            Point3d point3d3 = fastMatrix.getResult();
            transformedImage.narrowBBox((int)point3d2.x - 10, (int)Math.ceil(point3d3.x) + 10, (int)point3d2.y - 10, (int)Math.ceil(point3d3.y) + 10, (int)point3d2.z - 10, (int)Math.ceil(point3d3.z) + 10);
            return point3d;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    Point3d getCenter(InterpolatedImage interpolatedImage, int n) {
        if (n >= 0) {
            return interpolatedImage.getCenterOfGravity(n);
        }
        return interpolatedImage.getCenterOfGravity();
    }

    public static String getLastResult() {
        return lastResult.toStringForAmira();
    }

    void getMaterials2() {
        Choice choice = (Choice)this.gd.getChoices().get(1);
        int n = choice.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        String string = choice.getItem(n);
        ImagePlus imagePlus = WindowManager.getImage((String)string);
        AmiraParameters amiraParameters = new AmiraParameters(imagePlus);
        this.materials2 = amiraParameters.getMaterialList();
        Choice choice2 = (Choice)this.gd.getChoices().get(2);
        String string2 = choice2 == null ? null : choice2.getItem(choice2.getSelectedIndex());
        choice2.removeAll();
        int n2 = 0;
        for (int i = 0; i < this.materials2.length; ++i) {
            choice2.addItem(this.materials2[i]);
            if (string2 == null || !this.materials2[i].equals(string2)) continue;
            n2 = i;
        }
        if (string2 == null) {
            this.adjustMaterial(false);
        } else {
            choice2.select(n2);
        }
    }

    void adjustMaterial(boolean bl) {
        Choice choice = (Choice)this.gd.getChoices().get(0);
        Choice choice2 = (Choice)this.gd.getChoices().get(2);
        if (bl) {
            Choice choice3 = choice;
            choice = choice2;
            choice2 = choice3;
        }
        int n = choice.getSelectedIndex();
        String string = choice.getItem(n);
        for (int i = 0; i < choice2.getItemCount(); ++i) {
            if (!string.equals(choice2.getItem(i))) continue;
            choice2.select(i);
            return;
        }
        if (choice2.getSelectedIndex() < 0) {
            choice2.select(0);
        }
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 135;
    }

    static class FastOptimizer
    extends Optimizer {
        private int centerX;
        private int centerY;
        private int centerZ;
        private Point3d start;
        private Point3d stop;
        private Point3d current = new Point3d();

        public FastOptimizer(TransformedImage transformedImage, int n, int n2, double d, boolean bl) {
            super(transformedImage, n, n2, d, bl);
        }

        public void getInitialCenters() {
            super.getInitialCenters();
            Calibration calibration = this.t.orig.getImage().getCalibration();
            this.centerX = (int)Math.round((this.origC.x - calibration.xOrigin) / calibration.pixelWidth);
            this.centerY = (int)Math.round((this.origC.y - calibration.yOrigin) / calibration.pixelHeight);
            this.centerZ = (int)Math.round((this.origC.z - calibration.zOrigin) / calibration.pixelDepth);
        }

        public void initStartStop(int n, int n2, int n3, int n4, int n5, int n6) {
            this.t.matrix.apply(n, n2, n3);
            this.start = this.t.matrix.getResult();
            this.t.matrix.apply(n4, n5, n6);
            this.stop = this.t.matrix.getResult().minus(this.start);
        }

        public void calculateCurrent(int n, int n2) {
            this.current.x = this.start.x + (double)n * this.stop.x / (double)n2;
            this.current.y = this.start.y + (double)n * this.stop.y / (double)n2;
            this.current.z = this.start.z + (double)n * this.stop.z / (double)n2;
        }

        public double calculateBadness(FastMatrix fastMatrix) {
            float f;
            float f2;
            int n;
            int n2;
            this.t.setTransformation(fastMatrix);
            this.t.measure.reset();
            for (n2 = 0; n2 < this.t.orig.w; ++n2) {
                this.initStartStop(n2, 0, this.centerZ, n2, this.t.orig.h, this.centerZ);
                for (n = 0; n < this.t.orig.h; ++n) {
                    this.calculateCurrent(n, this.t.orig.h);
                    f2 = this.t.orig.getNoInterpol(n2, n, this.centerZ);
                    f = (float)this.t.transform.interpol.get(this.current.x, this.current.y, this.current.z);
                    this.t.measure.add(f2, f);
                }
            }
            for (n2 = 0; n2 < this.t.orig.d; ++n2) {
                this.initStartStop(0, this.centerY, n2, this.t.orig.w, this.centerY, n2);
                for (n = 0; n < this.t.orig.w; ++n) {
                    this.calculateCurrent(n, this.t.orig.w);
                    f2 = this.t.orig.getNoInterpol(n, this.centerY, n2);
                    f = (float)this.t.transform.interpol.get(this.current.x, this.current.y, this.current.z);
                    this.t.measure.add(f2, f);
                }
            }
            for (n2 = 0; n2 < this.t.orig.d; ++n2) {
                this.initStartStop(this.centerX, 0, n2, this.centerX, this.t.orig.h, n2);
                for (n = 0; n < this.t.orig.h; ++n) {
                    this.calculateCurrent(n, this.t.orig.h);
                    f2 = this.t.orig.getNoInterpol(this.centerX, n, n2);
                    f = (float)this.t.transform.interpol.get(this.current.x, this.current.y, this.current.z);
                    this.t.measure.add(f2, f);
                }
            }
            return this.t.measure.distance();
        }
    }

    static class Optimizer
    extends RegistrationOptimizer {
        TransformedImage t;
        int start;
        int stop;
        double tolerance;

        public Optimizer(TransformedImage transformedImage, int n, int n2, double d, boolean bl) {
            this.verbose = bl;
            this.t = n2 < 2 ? transformedImage : transformedImage.resample(1 << n2 - 1);
            this.start = n;
            this.stop = n2;
            this.tolerance = d;
        }

        public FastMatrix doRegister(int n) {
            return this.doRegister(n, 0);
        }

        public FastMatrix doRegister(int n, int n2) {
            if (n > 0) {
                TransformedImage transformedImage = this.t;
                this.t = this.t.resample(2);
                this.t.setTransformation(this.doRegister(n - 1));
                this.t = transformedImage;
                System.gc();
                System.gc();
            }
            if (this.verbose) {
                VIB.println("level is " + (this.start - n));
            }
            double d = 1 << this.start - n;
            int n3 = 1 << this.start;
            this.angleMax = 0.7853981633974483 * d / (double)n3;
            this.translateMax = 20.0 * d / (double)n3;
            if (this.eulerParameters == null) {
                this.eulerParameters = this.searchInitialEulerParams()[n2];
            }
            return this.doRegister(this.tolerance / d);
        }

        public void getInitialCenters() {
            if (this.t.measure instanceof TwoValues) {
                TwoValues twoValues = (TwoValues)this.t.measure;
                int n = twoValues.getMaterial(0);
                int n2 = twoValues.getMaterial(1);
                this.transC = this.t.transform.getCenterOfGravity(n);
                this.origC = this.t.orig.getCenterOfGravity(n2);
            } else {
                this.transC = this.t.transform.getCenterOfGravity();
                this.origC = this.t.orig.getCenterOfGravity();
            }
        }

        public double calculateBadness(FastMatrix fastMatrix) {
            this.t.setTransformation(fastMatrix);
            return this.t.getDistance();
        }
    }
}

