/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;

public class SegmentationViewerCanvas
extends ImageCanvas {
    static final int OUTLINE = 1;
    static final int FILL = 2;
    int mode = 2;
    int alpha = 128;
    protected ImagePlus labels;
    int w;
    int h;
    int d;
    Color[] label_colors = new Color[256];
    Vector[] contours;
    Vector[] colors;
    Vector[] indices;
    private final boolean debug = false;
    private int backBufferWidth;
    private int backBufferHeight;
    private Graphics backBufferGraphics;
    private Image backBufferImage;

    public SegmentationViewerCanvas(ImagePlus imagePlus) {
        super(imagePlus);
        this.w = imagePlus.getWidth();
        this.h = imagePlus.getHeight();
        this.d = imagePlus.getStack().getSize();
        this.contours = new Vector[this.d];
        this.colors = new Vector[this.d];
        this.indices = new Vector[this.d];
    }

    public SegmentationViewerCanvas(ImagePlus imagePlus, ImagePlus imagePlus2) {
        this(imagePlus);
        this.setLabels(imagePlus2);
    }

    public ImagePlus getLabels() {
        return this.labels;
    }

    public void setLabels(ImagePlus imagePlus) {
        this.labels = imagePlus;
        this.contours = new Vector[this.d];
        this.colors = new Vector[this.d];
        this.indices = new Vector[this.d];
        if (imagePlus == null) {
            return;
        }
        AmiraParameters amiraParameters = new AmiraParameters(imagePlus);
        int n = amiraParameters.getMaterialCount();
        for (int i = 0; i < this.label_colors.length; ++i) {
            if (i >= n) {
                this.label_colors[i] = Color.RED;
                continue;
            }
            double[] dArray = amiraParameters.getMaterialColor(i);
            int n2 = (int)(255.0 * dArray[0]);
            int n3 = (int)(255.0 * dArray[1]);
            int n4 = (int)(255.0 * dArray[2]);
            this.label_colors[i] = new Color(n2, n3, n4);
        }
        if (this.backBufferGraphics != null) {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSlice(int n) {
        SegmentationViewerCanvas segmentationViewerCanvas = this;
        synchronized (segmentationViewerCanvas) {
            this.colors[n - 1] = null;
            this.contours[n - 1] = null;
            this.indices[n - 1] = null;
            this.createContoursIfNotExist(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeneralPath getOutline(int n, int n2) {
        SegmentationViewerCanvas segmentationViewerCanvas = this;
        synchronized (segmentationViewerCanvas) {
            this.createContoursIfNotExist(n);
            for (int i = 0; i < this.indices[n - 1].size(); ++i) {
                if ((Integer)this.indices[n - 1].get(i) != n2) continue;
                return (GeneralPath)this.contours[n - 1].get(i);
            }
            return null;
        }
    }

    public void createContoursIfNotExist(int n) {
        if (this.labels == null || this.contours[n - 1] != null) {
            return;
        }
        ContourFinder contourFinder = new ContourFinder(n - 1);
        contourFinder.initContours();
    }

    private void resetBackBuffer() {
        if (this.backBufferGraphics != null) {
            this.backBufferGraphics.dispose();
            this.backBufferGraphics = null;
        }
        if (this.backBufferImage != null) {
            this.backBufferImage.flush();
            this.backBufferImage = null;
        }
        this.backBufferWidth = this.getSize().width;
        this.backBufferHeight = this.getSize().height;
        this.backBufferImage = this.createImage(this.backBufferWidth, this.backBufferHeight);
        this.backBufferGraphics = this.backBufferImage.getGraphics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (this.backBufferWidth != this.getSize().width || this.backBufferHeight != this.getSize().height || this.backBufferImage == null || this.backBufferGraphics == null) {
            this.resetBackBuffer();
        }
        int n = this.imp.getCurrentSlice();
        SegmentationViewerCanvas segmentationViewerCanvas = this;
        synchronized (segmentationViewerCanvas) {
            this.createContoursIfNotExist(n);
            super.paint(this.backBufferGraphics);
            this.drawOverlay(this.backBufferGraphics, n);
        }
        graphics.drawImage(this.backBufferImage, 0, 0, (ImageObserver)((Object)this));
    }

    void drawOverlay(Graphics graphics, int n) {
        if (this.labels == null) {
            return;
        }
        double d = this.getMagnification();
        for (int i = 0; i < this.contours[n - 1].size(); ++i) {
            Serializable serializable;
            graphics.setColor((Color)this.colors[n - 1].get(i));
            Shape shape = (Shape)this.contours[n - 1].get(i);
            if (d != 1.0) {
                serializable = ((Graphics2D)graphics).getDeviceConfiguration().getDefaultTransform();
                ((AffineTransform)serializable).setTransform(d, 0.0, 0.0, d, (double)(-this.srcRect.x) * d, (double)(-this.srcRect.y) * d);
                shape = ((AffineTransform)serializable).createTransformedShape(shape);
            }
            ((Graphics2D)graphics).draw(shape);
            if (this.mode != 2) continue;
            serializable = (Color)this.colors[n - 1].get(i);
            Color color = new Color(((Color)serializable).getRed(), ((Color)serializable).getGreen(), ((Color)serializable).getBlue(), this.alpha);
            graphics.setColor(color);
            ((Graphics2D)graphics).fill(shape);
        }
    }

    class ContourFinder {
        int slice;
        byte[] pixels;
        GeneralPath[] paths;
        Outline[] outline;

        public ContourFinder(int n) {
            this.slice = n;
            this.pixels = (byte[])SegmentationViewerCanvas.this.labels.getStack().getProcessor(n + 1).getPixels();
            this.paths = new GeneralPath[255];
        }

        final byte get(int n, int n2) {
            return this.pixels[n2 * SegmentationViewerCanvas.this.w + n];
        }

        public void initContours() {
            int n;
            SegmentationViewerCanvas.this.contours[this.slice] = new Vector();
            SegmentationViewerCanvas.this.colors[this.slice] = new Vector();
            SegmentationViewerCanvas.this.indices[this.slice] = new Vector();
            ArrayList arrayList = new ArrayList();
            this.outline = new Outline[2 * SegmentationViewerCanvas.this.w + 2];
            for (n = 0; n <= SegmentationViewerCanvas.this.h; ++n) {
                for (int i = 0; i < SegmentationViewerCanvas.this.w; ++i) {
                    this.handle(i, n);
                }
            }
            for (n = 1; n < this.paths.length; ++n) {
                if (this.paths[n] == null) continue;
                SegmentationViewerCanvas.this.contours[this.slice].add(this.paths[n]);
                SegmentationViewerCanvas.this.colors[this.slice].add(SegmentationViewerCanvas.this.label_colors[n]);
                SegmentationViewerCanvas.this.indices[this.slice].add(new Integer(n));
            }
        }

        private final Outline newOutline(int n, int n2, int n3, int n4, int n5) {
            this.outline[n] = this.outline[n2] = new Outline();
            this.outline[n].push(n3, n5);
            this.outline[n].push(n4, n5);
            return this.outline[n];
        }

        private final Outline mergeOutlines(Outline outline, Outline outline2) {
            outline.push(outline2);
            for (int i = 0; i < this.outline.length; ++i) {
                if (this.outline[i] != outline2) continue;
                this.outline[i] = outline;
                return this.outline[i];
            }
            throw new RuntimeException("assertion failed!");
        }

        private final Outline moveOutline(int n, int n2) {
            this.outline[n2] = this.outline[n];
            this.outline[n] = null;
            return this.outline[n2];
        }

        private void closeOutline(byte by, Outline outline) {
            int n = by & 0xFF;
            if (by == -1) {
                n = 0;
            }
            if (this.paths[n] == null) {
                this.paths[n] = new GeneralPath(0);
            }
            this.paths[n].append(outline.getPolygon(), false);
        }

        private void handle(int n, int n2) {
            int n3;
            int n4;
            byte by = n2 < SegmentationViewerCanvas.this.h ? this.get(n, n2) : (byte)0;
            byte by2 = n2 > 0 ? this.get(n, n2 - 1) : (byte)0;
            byte by3 = n > 0 && n2 < SegmentationViewerCanvas.this.h ? this.get(n - 1, n2) : (byte)0;
            byte by4 = n < SegmentationViewerCanvas.this.w - 1 && n2 < SegmentationViewerCanvas.this.h ? this.get(n + 1, n2) : (byte)0;
            byte by5 = n > 0 && n2 > 0 ? this.get(n - 1, n2 - 1) : (byte)0;
            byte by6 = n < SegmentationViewerCanvas.this.w - 1 && n2 > 0 ? this.get(n + 1, n2 - 1) : (byte)0;
            Outline outline = this.outline[2 * n];
            Outline outline2 = this.outline[2 * n + 1];
            Outline outline3 = this.outline[2 * n + 2];
            Outline outline4 = this.outline[2 * n + 3];
            this.outline[2 * n + 3] = null;
            this.outline[2 * n] = null;
            this.outline[2 * n + 2] = null;
            this.outline[2 * n + 1] = null;
            if (by2 != 0 && by2 != by) {
                n4 = 2 * n;
                n3 = 2 * n + 3;
                if (outline2 == null && outline3 == null) {
                    this.newOutline(n4, n3, n, n + 1, n2);
                } else if (outline2 == null) {
                    this.outline[n4] = outline3.shift(n, n2);
                } else if (outline3 == null) {
                    this.outline[n3] = outline2.push(n + 1, n2);
                } else if (outline2 == outline3) {
                    this.closeOutline(by2, outline2);
                } else {
                    this.mergeOutlines(outline2, outline3);
                }
                outline3 = null;
                outline2 = null;
            }
            if (by != 0 && by2 != by) {
                n4 = 2 * n + 1;
                n3 = 2 * n + 2;
                if (outline != null && by3 != by) {
                    this.outline[2 * n] = outline;
                    outline = null;
                }
                if (outline4 != null && (by4 != by || by6 != by)) {
                    this.outline[2 * n + 3] = outline4;
                    outline4 = null;
                }
                if (outline == null && outline4 == null) {
                    this.newOutline(n4, n3, n + 1, n, n2);
                } else if (outline == null) {
                    this.outline[n4] = outline4.push(n, n2);
                } else if (outline4 == null) {
                    this.outline[n3] = outline.shift(n + 1, n2);
                } else if (outline == outline4) {
                    this.closeOutline(by, outline);
                } else {
                    this.mergeOutlines(outline4, outline);
                }
                outline4 = null;
                outline = null;
            }
            if (outline != null) {
                this.outline[2 * n] = outline;
            }
            if (outline2 != null) {
                this.outline[2 * n + 1] = outline2;
            }
            if (outline4 != null) {
                this.outline[2 * n + 3] = outline4;
            }
            if (outline3 != null) {
                this.outline[2 * n + 2] = outline3;
            }
            if (by != 0 && by3 != by) {
                n4 = 2 * n + 1;
                if (this.outline[n4] == null) {
                    this.outline[n4] = outline2;
                }
                this.outline[n4].push(n, n2 + 1);
            }
            if (by3 != 0 && by3 != by) {
                n4 = 2 * n + 0;
                if (this.outline[n4] == null) {
                    this.outline[n4] = outline;
                }
                this.outline[n4].shift(n, n2 + 1);
            }
        }
    }

    static class Outline {
        int[] x = new int[this.reserved];
        int[] y = new int[this.reserved];
        int first = 5;
        int last = 5;
        int reserved = 10;
        final int GROW = 10;

        private void needs(int n, int n2) {
            if (n > this.reserved || n2 > this.first) {
                if (n < this.reserved + 10 + 1) {
                    n = this.reserved + 10 + 1;
                }
                int[] nArray = new int[n];
                int[] nArray2 = new int[n];
                System.arraycopy(this.x, 0, nArray, n2, this.last);
                System.arraycopy(this.y, 0, nArray2, n2, this.last);
                this.x = nArray;
                this.y = nArray2;
                this.first += n2;
                this.last += n2;
                this.reserved = n;
            }
        }

        public Outline push(int n, int n2) {
            this.needs(this.last + 1, 0);
            this.x[this.last] = n;
            this.y[this.last] = n2;
            ++this.last;
            return this;
        }

        public Outline shift(int n, int n2) {
            this.needs(this.last + 1, 10);
            --this.first;
            this.x[this.first] = n;
            this.y[this.first] = n2;
            return this;
        }

        public Outline push(Outline outline) {
            int n = outline.last - outline.first;
            this.needs(this.last + n, 0);
            System.arraycopy(outline.x, outline.first, this.x, this.last, n);
            System.arraycopy(outline.y, outline.first, this.y, this.last, n);
            this.last += n;
            return this;
        }

        public Outline shift(Outline outline) {
            int n = outline.last - outline.first;
            this.needs(this.last + n + 10, n + 10);
            this.first -= n;
            System.arraycopy(outline.x, outline.first, this.x, this.first, n);
            System.arraycopy(outline.y, outline.first, this.y, this.first, n);
            return this;
        }

        public Polygon getPolygon() {
            int n = this.last - this.first;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            System.arraycopy(this.x, this.first, nArray, 0, n);
            System.arraycopy(this.y, this.first, nArray2, 0, n);
            return new Polygon(nArray, nArray2, n);
        }

        public String toString() {
            String string = "(first:" + this.first + ",last:" + this.last + ",reserved:" + this.reserved + ":";
            if (this.last > this.x.length) {
                System.err.println("ERROR!");
            }
            for (int i = this.first; i < this.last && i < this.x.length; ++i) {
                string = string + "(" + this.x[i] + "," + this.y[i] + ")";
            }
            return string + ")";
        }
    }
}

