/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class ShowHistogram
extends ImageWindow
implements Measurements,
ActionListener,
ClipboardOwner {
    static final int WIN_WIDTH = 300;
    static final int WIN_HEIGHT = 240;
    static final int HIST_WIDTH = 256;
    static final int HIST_HEIGHT = 128;
    static final int BAR_HEIGHT = 12;
    static final int XMARGIN = 20;
    static final int YMARGIN = 10;
    protected double[] histogram;
    protected double histMin;
    protected double binSize;
    protected Rectangle frame = null;
    protected Button list;
    protected Button save;
    protected Button copy;
    protected Button log;
    protected Label value;
    protected Label count;
    protected static String defaultDirectory = null;
    protected int decimalPlaces;
    protected int digits;
    protected int newMinCount;
    protected int newMaxCount;
    protected int plotScale = 1;
    protected boolean logScale;
    protected int yMax;
    public static int nBins = 256;

    public ShowHistogram(double[] dArray, double d, double d2) {
        super(NewImage.createByteImage((String)"Histogram", (int)300, (int)240, (int)1, (int)4));
        this.histogram = dArray;
        this.histMin = d;
        this.binSize = d2;
        this.showHistogram(0.0, 0.0);
    }

    public ShowHistogram(long[] lArray, int n) {
        super(NewImage.createByteImage((String)"Histogram", (int)300, (int)240, (int)1, (int)4));
        this.histogram = new double[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            this.histogram[i] = lArray[i];
        }
        this.histMin = n;
        this.binSize = 1.0;
        this.showHistogram(0.0, 0.0);
    }

    public void showHistogram(double d, double d2) {
        this.setup();
        this.drawHistogram(this.imp.getProcessor());
        this.imp.updateAndDraw();
    }

    public void setup() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.list = new Button("List");
        this.list.addActionListener(this);
        panel.add(this.list);
        this.copy = new Button("Copy");
        this.copy.addActionListener(this);
        panel.add(this.copy);
        this.log = new Button("Log");
        this.log.addActionListener(this);
        panel.add(this.log);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(2, 1));
        this.value = new Label("                  ");
        this.value.setFont(new Font("Monospaced", 0, 12));
        panel2.add(this.value);
        this.count = new Label("                  ");
        this.count.setFont(new Font("Monospaced", 0, 12));
        panel2.add(this.count);
        panel.add(panel2);
        this.add(panel);
        this.pack();
    }

    public void mouseMoved(int n, int n2) {
        if (this.value == null || this.count == null) {
            return;
        }
        if (this.frame != null && n >= this.frame.x && n <= this.frame.x + this.frame.width) {
            if ((n -= this.frame.x) > 255) {
                n = 255;
            }
            int n3 = (int)((double)n * (double)this.histogram.length / 256.0);
            this.value.setText("  Value: " + IJ.d2s((double)(this.histMin + (double)n3 * this.binSize), (int)this.digits));
            this.count.setText("  Count: " + this.histogram[n3]);
        } else {
            this.value.setText("");
            this.count.setText("");
        }
    }

    protected void drawHistogram(ImageProcessor imageProcessor) {
        double d = this.histogram[0];
        double d2 = this.histogram[0];
        int n = 0;
        imageProcessor.setColor(Color.black);
        imageProcessor.setLineWidth(1);
        this.decimalPlaces = Analyzer.getPrecision();
        this.digits = this.binSize != 1.0 ? this.decimalPlaces : 0;
        for (int i = 1; i < this.histogram.length; ++i) {
            if (this.histogram[i] > d2) {
                d2 = this.histogram[i];
                n = i;
                continue;
            }
            if (!(this.histogram[i] < d)) continue;
            d = this.histogram[i];
        }
        this.drawPlot(d, d2, imageProcessor);
        int n2 = 21;
        int n3 = 140;
        this.drawText(imageProcessor, n2, n3 += 27);
    }

    void drawPlot(double d, double d2, ImageProcessor imageProcessor) {
        if (d2 <= d) {
            d2 = d + 1.0;
        }
        this.newMinCount = (int)d;
        this.newMaxCount = (int)d2;
        System.err.println("min/max: " + d + "/" + d2);
        this.frame = new Rectangle(20, 10, 256, 128);
        imageProcessor.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        for (int i = 0; i < 256; ++i) {
            int n = (int)((double)i * (double)this.histogram.length / 256.0);
            int n2 = (int)(128.0 * (this.histogram[n] - d) / (d2 - d));
            if (n2 > 128) {
                n2 = 128;
            }
            imageProcessor.drawLine(i + 20, 138, i + 20, 138 - n2);
        }
    }

    void drawLogPlot(int n, ImageProcessor imageProcessor) {
        this.frame = new Rectangle(20, 10, 256, 128);
        imageProcessor.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        double d = Math.log(n);
        imageProcessor.setColor(Color.gray);
        for (int i = 0; i < 256; ++i) {
            int n2;
            int n3 = (int)((double)i * (double)this.histogram.length / 256.0);
            int n4 = n2 = this.histogram[n3] == 0.0 ? 0 : (int)(128.0 * Math.log(this.histogram[n3]) / d);
            if (n2 > 128) {
                n2 = 128;
            }
            imageProcessor.drawLine(i + 20, 138, i + 20, 138 - n2);
        }
        imageProcessor.setColor(Color.black);
    }

    void drawText(ImageProcessor imageProcessor, int n, int n2) {
        imageProcessor.setFont(new Font("SansSerif", 0, 12));
        imageProcessor.setAntialiasedText(true);
        double d = this.histMin;
        double d2 = this.histMin + this.binSize * (double)(this.histogram.length - 1);
        imageProcessor.drawString(this.d2s(d), n - 4, n2);
        imageProcessor.drawString(this.d2s(d2), n + 256 - this.getWidth(d2, imageProcessor) + 10, n2);
        this.binSize = Math.abs(this.binSize);
        boolean bl = this.binSize != 1.0;
        int n3 = 25;
        int n4 = 148;
        int n5 = n2 + 25;
        if (bl) {
            n5 -= 8;
        }
        int n6 = n5 + 15;
        int n7 = n6 + 15;
        int n8 = n7 + 15;
        imageProcessor.drawString("Count: " + this.histogram.length, n3, n5);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = Double.MAX_VALUE;
        double d7 = Double.MIN_VALUE;
        for (int i = 0; i < this.histogram.length; ++i) {
            d4 += (double)i * this.histogram[i];
            d5 += (double)(i * i) * this.histogram[i];
            d3 += this.histogram[i];
            if (d6 > this.histogram[i]) {
                d6 = this.histogram[i];
            }
            if (!(d7 < this.histogram[i])) continue;
            d7 = this.histogram[i];
        }
        if (d3 > 0.0) {
            d4 /= d3;
            d5 /= d3;
        }
        double d8 = Math.sqrt(d5 - d4 * d4) * this.binSize;
        d4 = this.histMin + d4 * this.binSize;
        imageProcessor.drawString("Mean: " + this.d2s(d4), n3, n6);
        imageProcessor.drawString("StdDev: " + this.d2s(d8), n3, n7);
        imageProcessor.drawString("Min: " + this.d2s(d6), n4, n5);
        imageProcessor.drawString("Max: " + this.d2s(d7), n4, n6);
        if (bl) {
            imageProcessor.drawString("Bins: " + this.d2s(this.histogram.length), n3, n8);
            imageProcessor.drawString("Bin Width: " + this.d2s(this.binSize), n4, n8);
        }
    }

    String d2s(double d) {
        if (d == Double.MAX_VALUE || d == -1.7976931348623157E308) {
            return "0";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return "Infinity";
        }
        if ((double)((int)d) == d) {
            return IJ.d2s((double)d, (int)0);
        }
        return IJ.d2s((double)d, (int)this.decimalPlaces);
    }

    int getWidth(double d, ImageProcessor imageProcessor) {
        return imageProcessor.getStringWidth(this.d2s(d));
    }

    protected void showList() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.binSize == 1.0 ? "value" : "bin start";
        for (int i = 0; i < this.histogram.length; ++i) {
            stringBuffer.append(IJ.d2s((double)(this.histMin + (double)i * this.binSize), (int)this.digits) + "\t" + this.histogram[i] + "\n");
        }
        TextWindow textWindow = new TextWindow(this.getTitle(), string + "\tcount", stringBuffer.toString(), 200, 400);
    }

    protected void copyToClipboard() {
        Clipboard clipboard = null;
        try {
            clipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            clipboard = null;
        }
        if (clipboard == null) {
            IJ.error((String)"Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus((String)"Copying histogram values...");
        CharArrayWriter charArrayWriter = new CharArrayWriter(this.histogram.length * 4);
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        for (int i = 0; i < this.histogram.length; ++i) {
            printWriter.print(IJ.d2s((double)(this.histMin + (double)i * this.binSize), (int)this.digits) + "\t" + this.histogram[i] + "\n");
        }
        String string = charArrayWriter.toString();
        printWriter.close();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, this);
        IJ.showStatus((String)(string.length() + " characters copied to Clipboard"));
    }

    void replot() {
        this.logScale = !this.logScale;
        ImageProcessor imageProcessor = this.imp.getProcessor();
        this.frame = new Rectangle(20, 10, 256, 128);
        imageProcessor.setColor(Color.white);
        imageProcessor.setRoi(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height);
        imageProcessor.fill();
        imageProcessor.resetRoi();
        imageProcessor.setColor(Color.black);
        if (this.logScale) {
            this.drawLogPlot(this.newMaxCount, imageProcessor);
            this.drawPlot(this.newMinCount, this.newMaxCount, imageProcessor);
        } else {
            this.drawPlot(this.newMinCount, this.newMaxCount, imageProcessor);
        }
        this.imp.updateAndDraw();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.list) {
            this.showList();
        } else if (object == this.copy) {
            this.copyToClipboard();
        } else if (object == this.log) {
            this.replot();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public double[] getHistogram() {
        return this.histogram;
    }
}

