/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import amira.AmiraTable;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextPanel;
import ij.util.Tools;
import java.util.ArrayList;
import math3d.Point3d;
import vib.InterpolatedImage;

public class Show_centers
implements PlugInFilter {
    private ImagePlus image;

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Center Transformation");
        AmiraParameters.addAmiraTableList(genericDialog, "Statistics");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        String string = genericDialog.getNextChoice();
        AmiraTable amiraTable = (AmiraTable)((Object)WindowManager.getFrame((String)string));
        ImagePlus imagePlus = this.getCenters(amiraTable);
        imagePlus.show();
        imagePlus.updateAndDraw();
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }

    public void setImage(ImagePlus imagePlus) {
        this.image = imagePlus;
    }

    public ImagePlus getCenters(AmiraTable amiraTable) {
        Point3d[] point3dArray = Show_centers.getList(amiraTable);
        ImagePlus imagePlus = new InterpolatedImage(this.image).cloneDimensionsOnly().getImage();
        imagePlus.setTitle("Centers");
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getStackSize();
        Calibration calibration = imagePlus.getCalibration();
        for (int i = 0; i < n3; ++i) {
            double d = Math.abs((double)i * calibration.pixelDepth);
            byte[] byArray = (byte[])imagePlus.getStack().getProcessor(i + 1).getPixels();
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    int n4 = k * n + j;
                    double d2 = (double)j * calibration.pixelWidth;
                    double d3 = (double)k * calibration.pixelHeight;
                    Point3d point3d = new Point3d(d2, d3, d);
                    for (int i2 = 0; i2 < point3dArray.length; ++i2) {
                        if (!(point3d.distance2(point3dArray[i2]) < 200.0)) continue;
                        byArray[n4] = -1;
                    }
                }
            }
        }
        return imagePlus;
    }

    public static Point3d[] getList(AmiraTable amiraTable) {
        TextPanel textPanel = amiraTable.getTextPanel();
        int n = textPanel.getLineCount();
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        for (int i = 1; i < n; ++i) {
            String[] stringArray = Tools.split((String)textPanel.getLine(i), (String)"\t");
            int n2 = Integer.parseInt(stringArray[2]);
            if (n2 == 0) continue;
            arrayList.add(new Point3d(Double.parseDouble(stringArray[4]), Double.parseDouble(stringArray[5]), Double.parseDouble(stringArray[6])));
        }
        return arrayList.toArray(new Point3d[0]);
    }
}

