/*
 * Decompiled with CFR 0.152.
 */
package vib;

import distance.Correlation;
import distance.Euclidean;
import distance.MutualInformation;
import distance.TwoValues;
import ij.ImageJ;
import ij.ImagePlus;
import ij.io.FileSaver;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.BatchOpener;
import vib.FastMatrix;
import vib.RigidRegistration_;
import vib.TransformedImage;

public class TestRigidRegistration {
    RigidRegistration_ plugin;
    ImageJ imageJ;
    static final int fanShapedBody = 11;
    static final int protocerebralBridge = 12;
    String centralComplex_Labels_71yAAeastmost = "test-images" + File.separator + "71yAAeastmost.labels";
    String centralComplex_Labels_c005BA = "test-images" + File.separator + "c005BA.labels";

    @Before
    public void loadImagesAndImageJ() {
        this.imageJ = new ImageJ();
    }

    @After
    public void closeImageAndImageJ() {
        this.imageJ.quit();
    }

    @Test
    public void testRegistration8BitGray() {
        String string = "test-images" + File.separator + "CantonF41c-reduced.tif";
        String string2 = "test-images" + File.separator + "tidied-mhl-62yxUAS-lacZ0-reduced.tif";
        float f = -0.3f;
        float f2 = 25.0f;
        ImagePlus imagePlus = BatchOpener.openFirstChannel(string);
        ImagePlus imagePlus2 = BatchOpener.openFirstChannel(string2);
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((imagePlus != null ? 1 : 0) != 0);
            Assert.assertTrue((imagePlus2 != null ? 1 : 0) != 0);
            this.plugin = new RigidRegistration_();
            this.plugin.setup("", imagePlus2);
            int n = RigidRegistration_.guessLevelFromWidth(imagePlus.getWidth());
            TransformedImage transformedImage = new TransformedImage(imagePlus, imagePlus2);
            String string3 = null;
            float f3 = Float.MIN_VALUE;
            if (i == 0) {
                string3 = "eu";
                transformedImage.measure = new Euclidean();
                f3 = 35.0f;
            } else if (i == 1) {
                string3 = "mi";
                transformedImage.measure = new MutualInformation();
                f3 = -0.2f;
            } else if (i == 2) {
                string3 = "co";
                transformedImage.measure = new Correlation();
                f3 = 0.5f;
            }
            FastMatrix fastMatrix = this.plugin.rigidRegistration(transformedImage, "", "", -1, -1, false, n, n > 2 ? 2 : n, 1.0, 1, false, false, false, null);
            File file = new File("test-images" + File.separator + "output");
            file.mkdir();
            String string4 = file.getPath() + File.separator + "testRegistration8BitGray-" + string3 + "-transformed.tif";
            String string5 = file.getPath() + File.separator + "testRegistration8BitGray-" + string3 + "-difference.tif";
            boolean bl = new FileSaver(transformedImage.getTransformed()).saveAsTiffStack(string4);
            Assert.assertTrue((String)("Saving to: " + string4 + " failed."), (boolean)bl);
            bl = new FileSaver(transformedImage.getDifferenceImage()).saveAsTiffStack(string5);
            Assert.assertTrue((String)("Saving to: " + string5 + " failed."), (boolean)bl);
            float f4 = transformedImage.getDistance();
            System.out.println("Distance with " + string3 + " was: " + f4);
            Assert.assertTrue((String)("On run: " + string3 + " distance (" + f4 + "), more than what we expect (" + f3 + ")"), (f4 <= f3 ? 1 : 0) != 0);
        }
        imagePlus.close();
        imagePlus2.close();
    }

    @Test
    public void testRegistrationMaterials() {
        ImagePlus imagePlus = BatchOpener.openFirstChannel(this.centralComplex_Labels_71yAAeastmost);
        ImagePlus imagePlus2 = BatchOpener.openFirstChannel(this.centralComplex_Labels_c005BA);
        int[] nArray = new int[]{11, 12};
        float[] fArray = new float[]{15.5f, 5.5555556E7f};
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            float f = fArray[i];
            if (n == 12) continue;
            ImagePlus imagePlus3 = imagePlus2;
            ImagePlus imagePlus4 = imagePlus;
            Assert.assertTrue((imagePlus3 != null ? 1 : 0) != 0);
            Assert.assertTrue((imagePlus4 != null ? 1 : 0) != 0);
            this.plugin = new RigidRegistration_();
            this.plugin.setup("", imagePlus4);
            int n2 = RigidRegistration_.guessLevelFromWidth(imagePlus3.getWidth());
            TransformedImage transformedImage = new TransformedImage(imagePlus3, imagePlus4);
            transformedImage.measure = new TwoValues(n, n);
            FastMatrix fastMatrix = this.plugin.rigidRegistration(transformedImage, "", "", n, n, false, n2, n2 > 2 ? 2 : n2, 1.0, 1, false, false, false, null);
            File file = new File("test-images" + File.separator + "output");
            file.mkdir();
            String string = file.getPath() + File.separator + "testRegistrationMaterials-" + n + "-transformed.tif";
            String string2 = file.getPath() + File.separator + "testRegistrationMaterials-" + n + "-difference.tif";
            boolean bl = new FileSaver(transformedImage.getTransformed()).saveAsTiffStack(string);
            Assert.assertTrue((boolean)bl);
            bl = new FileSaver(transformedImage.getDifferenceImage()).saveAsTiffStack(string2);
            Assert.assertTrue((boolean)bl);
            float f2 = transformedImage.getDistance();
            System.out.println("Distance was " + f2 + " when registering material " + n);
            Assert.assertTrue((String)("For material " + n + ", distance (" + f2 + "), more than what we expect (" + f + ")"), (f2 <= f ? 1 : 0) != 0);
        }
        imagePlus.close();
        imagePlus2.close();
    }

    @Test
    public void testRegistration12BitGray() {
        String string = "test-images" + File.separator + "181y-12bit-aaarrg-dark-detail-reduced.tif";
        String string2 = "test-images" + File.separator + "181y-12bit-aaarrg-mid-detail-reduced.tif";
        String string3 = "test-images" + File.separator + "181y-12bit-aaarrg-bright-reduced.tif";
        ImagePlus imagePlus = BatchOpener.openFirstChannel(string);
        ImagePlus imagePlus2 = BatchOpener.openFirstChannel(string2);
        ImagePlus imagePlus3 = BatchOpener.openFirstChannel(string3);
        for (int i = 0; i < 2; ++i) {
            ImagePlus imagePlus4 = null;
            ImagePlus imagePlus5 = null;
            float[] fArray = new float[3];
            if (i == 0) {
                imagePlus4 = imagePlus2;
                imagePlus5 = imagePlus;
                fArray[0] = 555555.0f;
                fArray[1] = -1.0f;
                fArray[2] = 0.1f;
            } else if (i == 1) {
                imagePlus4 = imagePlus2;
                imagePlus5 = imagePlus3;
                fArray[0] = 555555.0f;
                fArray[1] = -1.0f;
                fArray[2] = 0.1f;
            }
            Assert.assertTrue((imagePlus4 != null ? 1 : 0) != 0);
            Assert.assertTrue((imagePlus5 != null ? 1 : 0) != 0);
            for (int j = 0; j < 3; ++j) {
                this.plugin = new RigidRegistration_();
                this.plugin.setup("", imagePlus5);
                int n = RigidRegistration_.guessLevelFromWidth(imagePlus4.getWidth());
                TransformedImage transformedImage = new TransformedImage(imagePlus4, imagePlus5);
                String string4 = null;
                if (j == 0) {
                    string4 = "eu";
                    transformedImage.measure = new Euclidean();
                    continue;
                }
                if (j == 1) {
                    string4 = "mi";
                    transformedImage.measure = new MutualInformation(0.0f, 4095.0f, 256);
                } else if (j == 2) {
                    string4 = "co";
                    transformedImage.measure = new Correlation();
                }
                FastMatrix fastMatrix = this.plugin.rigidRegistration(transformedImage, "", "", -1, -1, false, n, n > 2 ? 2 : n, 1.0, 1, false, false, false, null);
                File file = new File("test-images" + File.separator + "output");
                file.mkdir();
                String string5 = file.getPath() + File.separator + "testRegistration12BitGray-" + i + "-" + string4 + "-transformed.tif";
                String string6 = file.getPath() + File.separator + "testRegistration12BitGray-" + i + "-" + string4 + "-difference.tif";
                boolean bl = new FileSaver(transformedImage.getTransformed()).saveAsTiffStack(string5);
                Assert.assertTrue((String)("Saving to: " + string5 + " failed."), (boolean)bl);
                bl = new FileSaver(transformedImage.getDifferenceImage()).saveAsTiffStack(string6);
                Assert.assertTrue((String)("Saving to: " + string6 + " failed."), (boolean)bl);
                float f = transformedImage.getDistance();
                System.out.println("distance on timeThrough " + i + " (measure: " + string4 + "): " + f);
                Assert.assertTrue((String)("On time through " + i + " distance (" + f + "), more than what we expect (" + fArray[j] + ")"), (f <= fArray[j] ? 1 : 0) != 0);
            }
        }
        imagePlus.close();
        imagePlus2.close();
        imagePlus3.close();
    }
}

