/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import amira.AmiraTable;
import ij.IJ;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import vib.InterpolatedImage;

public class TissueStatistics_
implements PlugInFilter {
    ImagePlus image;

    public void run(ImageProcessor imageProcessor) {
        AmiraTable amiraTable = TissueStatistics_.calculateStatistics(this.image);
        amiraTable.show();
    }

    public static AmiraTable calculateStatistics(ImagePlus imagePlus) {
        if (!AmiraParameters.isAmiraLabelfield(imagePlus)) {
            IJ.error((String)"Need a labelfield!");
            return null;
        }
        String string = "Statistics for " + imagePlus.getTitle();
        String string2 = "Nr\tMaterial\tCount\tVolume\tCenterX\tCenterY\tCenterZ\tMinX\tMaxX\tMinY\tMaxY\tMinZ\tMaxZ";
        Statistics statistics = TissueStatistics_.getStatistics(imagePlus);
        AmiraTable amiraTable = new AmiraTable(string, string2, statistics.getResult(), true);
        return amiraTable;
    }

    public static Statistics getStatistics(ImagePlus imagePlus) {
        InterpolatedImage interpolatedImage = new InterpolatedImage(imagePlus);
        return new Statistics(interpolatedImage);
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 3;
    }

    public static class Statistics {
        Calibration cal;
        AmiraParameters parameters;
        public String[] materials;
        public long[] count;
        public long[] cX;
        public long[] cY;
        public long[] cZ;
        public int[] minX;
        public int[] maxX;
        public int[] minY;
        public int[] maxY;
        public int[] minZ;
        public int[] maxZ;

        public Statistics(InterpolatedImage interpolatedImage) {
            this.cal = interpolatedImage.image.getCalibration();
            this.parameters = new AmiraParameters(interpolatedImage.image);
            this.materials = this.parameters.getMaterialList();
            this.count = new long[this.materials.length];
            this.cX = new long[this.materials.length];
            this.cY = new long[this.materials.length];
            this.cZ = new long[this.materials.length];
            this.minX = new int[this.materials.length];
            this.maxX = new int[this.materials.length];
            this.minY = new int[this.materials.length];
            this.maxY = new int[this.materials.length];
            this.minZ = new int[this.materials.length];
            this.maxZ = new int[this.materials.length];
            for (int i = 0; i < this.materials.length; ++i) {
                this.minZ[i] = Integer.MAX_VALUE;
                this.minY[i] = Integer.MAX_VALUE;
                this.minX[i] = Integer.MAX_VALUE;
            }
            this.doit(interpolatedImage);
        }

        public void doit(InterpolatedImage interpolatedImage) {
            InterpolatedImage.Iterator iterator = interpolatedImage.iterator(true);
            while (iterator.next() != null) {
                int n;
                int n2 = n = interpolatedImage.getNoInterpol(iterator.i, iterator.j, iterator.k);
                this.count[n2] = this.count[n2] + 1L;
                int n3 = n;
                this.cX[n3] = this.cX[n3] + (long)iterator.i;
                int n4 = n;
                this.cY[n4] = this.cY[n4] + (long)iterator.j;
                int n5 = n;
                this.cZ[n5] = this.cZ[n5] + (long)iterator.k;
                if (this.minX[n] > iterator.i) {
                    this.minX[n] = iterator.i;
                } else if (this.maxX[n] < iterator.i) {
                    this.maxX[n] = iterator.i;
                }
                if (this.minY[n] > iterator.j) {
                    this.minY[n] = iterator.j;
                } else if (this.maxY[n] < iterator.j) {
                    this.maxY[n] = iterator.j;
                }
                if (this.minZ[n] > iterator.k) {
                    this.minZ[n] = iterator.k;
                    continue;
                }
                if (this.maxZ[n] >= iterator.k) continue;
                this.maxZ[n] = iterator.k;
            }
        }

        public double x(double d) {
            return this.cal.xOrigin + (d + 0.5) * this.cal.pixelWidth;
        }

        public double y(double d) {
            return this.cal.yOrigin + (d + 0.5) * this.cal.pixelHeight;
        }

        public double z(double d) {
            return this.cal.yOrigin + (d + 0.5) * this.cal.pixelDepth;
        }

        public double voxelVolume() {
            return this.cal.pixelWidth * this.cal.pixelHeight * this.cal.pixelDepth;
        }

        public double centerX(int n) {
            return this.x((double)this.cX[n] / (double)this.count[n]);
        }

        public double centerY(int n) {
            return this.y((double)this.cY[n] / (double)this.count[n]);
        }

        public double centerZ(int n) {
            return this.z((double)this.cZ[n] / (double)this.count[n]);
        }

        public String getResult() {
            double d = this.voxelVolume();
            String string = "";
            for (int i = 0; i < this.materials.length; ++i) {
                string = string + (i + 1) + "\t";
                string = string + this.materials[i] + "\t";
                string = string + this.count[i] + "\t";
                if (this.count[i] == 0L) {
                    string = string + "0\t0\t0\t0\t0\t0\t0\t0\t0\t0\n";
                    continue;
                }
                string = string + (double)this.count[i] * d + "\t";
                string = string + this.centerX(i) + "\t";
                string = string + this.centerY(i) + "\t";
                string = string + this.centerZ(i) + "\t";
                string = string + this.x(this.minX[i]) + "\t";
                string = string + this.x(this.maxX[i]) + "\t";
                string = string + this.y(this.minY[i]) + "\t";
                string = string + this.y(this.maxY[i]) + "\t";
                string = string + this.z(this.minZ[i]) + "\t";
                string = string + this.z(this.maxZ[i]) + "\n";
            }
            return string;
        }
    }
}

