/*
 * Decompiled with CFR 0.152.
 */
package vib;

import distance.Correlation;
import distance.Euclidean;
import distance.MutualInformation;
import distance.PixelPairs;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import math3d.Point3d;
import vib.FastMatrix;
import vib.InterpolatedImage;
import vib.Resample_;

public class TransformedImage {
    InterpolatedImage orig;
    InterpolatedImage transform;
    FastMatrix fromOrig;
    private FastMatrix transformation;
    FastMatrix toTransform;
    public PixelPairs measure;
    FastMatrix matrix;
    int imageType = -1;
    int x0;
    int y0;
    int z0;
    int x1;
    int y1;
    int z1;

    public TransformedImage(ImagePlus imagePlus, ImagePlus imagePlus2) {
        this.orig = new InterpolatedImage(imagePlus);
        this.transform = new InterpolatedImage(imagePlus2);
        this.fromOrig = FastMatrix.fromCalibration(imagePlus);
        this.toTransform = FastMatrix.fromCalibration(imagePlus2).inverse();
        this.z0 = 0;
        this.y0 = 0;
        this.x0 = 0;
        this.x1 = this.orig.w;
        this.y1 = this.orig.h;
        this.z1 = this.orig.d;
        if (imagePlus.getType() != imagePlus2.getType()) {
            throw new RuntimeException("TransformedImage needs two images of the same bit depth.");
        }
        this.imageType = imagePlus.getType();
        switch (this.imageType) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new RuntimeException("Not yet implemented! (Bit depths != 8 or 16 in TransformedImage.)");
            }
        }
    }

    public ImagePlus getTemplate() {
        return this.orig.getImage();
    }

    public float[] getValuesRange() {
        int n;
        int n2;
        Object[] objectArray;
        int n3;
        int n4 = this.orig.image.getStackSize();
        int n5 = this.transform.image.getStackSize();
        ImageStack imageStack = this.orig.image.getStack();
        ImageStack imageStack2 = this.transform.image.getStack();
        int n6 = this.orig.image.getBitDepth();
        int n7 = this.transform.image.getBitDepth();
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        for (n3 = 0; n3 < n4; ++n3) {
            if (8 == n6) {
                objectArray = (byte[])imageStack.getPixels(n3 + 1);
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    n = objectArray[n2] & 0xFF;
                    if ((float)n > f2) {
                        f2 = n;
                    }
                    if (!((float)n < f)) continue;
                    f = n;
                }
                continue;
            }
            if (16 != n6) continue;
            objectArray = (short[])imageStack.getPixels(n3 + 1);
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = (int)objectArray[n2];
                if ((float)n > f2) {
                    f2 = n;
                }
                if (!((float)n < f)) continue;
                f = n;
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            if (8 == n7) {
                objectArray = (byte[])imageStack2.getPixels(n3 + 1);
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    n = objectArray[n2] & 0xFF;
                    if ((float)n > f2) {
                        f2 = n;
                    }
                    if (!((float)n < f)) continue;
                    f = n;
                }
                continue;
            }
            if (16 != n7) continue;
            objectArray = (short[])imageStack2.getPixels(n3 + 1);
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = (int)objectArray[n2];
                if ((float)n > f2) {
                    f2 = n;
                }
                if (!((float)n < f)) continue;
                f = n;
            }
        }
        objectArray = new float[]{f, f2};
        return objectArray;
    }

    public void setTransformation(FastMatrix fastMatrix) {
        this.transformation = fastMatrix.inverse();
        this.matrix = this.toTransform.times(this.transformation.times(this.fromOrig));
    }

    public TransformedImage resample(int n) {
        ImagePlus imagePlus;
        ImagePlus imagePlus2;
        if (this.measure instanceof MutualInformation) {
            imagePlus2 = Resample_.resampleMinEnt(this.orig.image, n);
            imagePlus = Resample_.resampleMinEnt(this.transform.image, n);
        } else {
            imagePlus2 = Resample_.resample(this.orig.image, n);
            imagePlus = Resample_.resample(this.transform.image, n);
        }
        TransformedImage transformedImage = new TransformedImage(imagePlus2, imagePlus);
        transformedImage.transformation = this.transformation;
        transformedImage.measure = this.measure;
        transformedImage.x0 = this.x0 / n;
        transformedImage.y0 = this.y0 / n;
        transformedImage.z0 = this.z0 / n;
        transformedImage.x1 = (this.x1 + n - 1) / n;
        transformedImage.y1 = (this.y1 + n - 1) / n;
        transformedImage.z1 = (this.z1 + n - 1) / n;
        return transformedImage;
    }

    public Iterator iterator() {
        return this.iterator(false);
    }

    public Iterator iterator(boolean bl) {
        return this.iterator(bl, 0, 0, 0, this.orig.w, this.orig.h, this.orig.d);
    }

    public Iterator iterator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        return new Iterator(bl, n, n2, n3, n4, n5, n6);
    }

    public float getDistance() {
        this.measure.reset();
        Iterator iterator = new Iterator(false, this.x0, this.y0, this.z0, this.x1, this.y1, this.z1);
        while (iterator.next() != null) {
            float f = -1.0f;
            switch (this.imageType) {
                case 0: 
                case 3: {
                    f = this.orig.getNoInterpol(iterator.i, iterator.j, iterator.k);
                    break;
                }
                case 1: {
                    f = this.orig.getNoInterpolShort(iterator.i, iterator.j, iterator.k);
                }
            }
            float f2 = (float)this.transform.interpol.get(iterator.x, iterator.y, iterator.z);
            this.measure.add(f, f2);
        }
        return this.measure.distance();
    }

    public ImagePlus getTransformed() {
        InterpolatedImage interpolatedImage = this.orig.cloneDimensionsOnly();
        Iterator iterator = this.iterator();
        switch (this.imageType) {
            case 0: 
            case 3: {
                while (iterator.next() != null) {
                    interpolatedImage.set(iterator.i, iterator.j, iterator.k, this.transform.getNoInterpol((int)iterator.x, (int)iterator.y, (int)iterator.z));
                }
                break;
            }
            case 1: {
                while (iterator.next() != null) {
                    interpolatedImage.setShort(iterator.i, iterator.j, iterator.k, this.transform.getNoInterpolShort((int)iterator.x, (int)iterator.y, (int)iterator.z));
                }
                break;
            }
        }
        interpolatedImage.image.setTitle("transformed");
        return interpolatedImage.image;
    }

    public ImagePlus getDifferenceImage() {
        int n = -1;
        switch (this.imageType) {
            case 0: 
            case 3: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
            }
        }
        InterpolatedImage interpolatedImage = InterpolatedImage.cloneDimensionsOnly(this.orig.image, n);
        PixelPairs pixelPairs = null;
        pixelPairs = this.measure instanceof MutualInformation || this.measure instanceof Correlation ? new Euclidean() : this.measure;
        Iterator iterator = this.iterator(false, this.x0, this.y0, this.z0, this.x1, this.y1, this.z1);
        while (iterator.next() != null) {
            pixelPairs.reset();
            switch (this.imageType) {
                case 0: 
                case 3: {
                    pixelPairs.add(this.orig.getNoInterpol(iterator.i, iterator.j, iterator.k), this.transform.getNoInterpol((int)iterator.x, (int)iterator.y, (int)iterator.z));
                    break;
                }
                case 1: {
                    pixelPairs.add(this.orig.getNoInterpolShort(iterator.i, iterator.j, iterator.k), this.transform.getNoInterpolShort((int)iterator.x, (int)iterator.y, (int)iterator.z));
                }
            }
            switch (n) {
                case 0: 
                case 3: {
                    interpolatedImage.set(iterator.i, iterator.j, iterator.k, (byte)pixelPairs.distance());
                    break;
                }
                case 1: {
                    interpolatedImage.setShort(iterator.i, iterator.j, iterator.k, (short)pixelPairs.distance());
                }
            }
        }
        interpolatedImage.image.setTitle("difference");
        return interpolatedImage.image;
    }

    public void narrowBBox(int n, int n2, int n3, int n4, int n5, int n6) {
        System.err.println("bbox: " + n + " " + n2 + " " + n3 + " " + n4 + " " + n5 + " " + n6);
        if (n < 0) {
            n = 0;
        } else if (n >= this.orig.w) {
            n = this.orig.w - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.orig.h) {
            n3 = this.orig.h - 1;
        }
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 >= this.orig.d) {
            n5 = this.orig.d - 1;
        }
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > this.orig.w) {
            n2 = this.orig.w;
        }
        if (n4 < 1) {
            n4 = 1;
        } else if (n4 > this.orig.h) {
            n4 = this.orig.h;
        }
        if (n6 < 1) {
            n6 = 1;
        } else if (n6 > this.orig.d) {
            n6 = this.orig.d;
        }
        this.x0 = n;
        this.x1 = n2;
        this.y0 = n3;
        this.y1 = n4;
        this.z0 = n5;
        this.z1 = n6;
    }

    public void narrowSearchToMaterial(int n, int n2) {
        this.x0 = this.orig.w;
        this.y0 = this.orig.h;
        this.z0 = this.orig.d;
        this.z1 = 0;
        this.y1 = 0;
        this.x1 = 0;
        for (int i = 0; i < this.orig.d; ++i) {
            for (int j = 0; j < this.orig.h; ++j) {
                for (int k = 0; k < this.orig.w; ++k) {
                    int n3 = this.orig.getNoInterpol(k, j, i);
                    if (n3 != n) continue;
                    if (this.x0 > k) {
                        this.x0 = k;
                    } else if (this.x1 < k) {
                        this.x1 = k;
                    }
                    if (this.y0 > j) {
                        this.y0 = j;
                    } else if (this.y1 < j) {
                        this.y1 = j;
                    }
                    if (this.z0 > i) {
                        this.z0 = i;
                        continue;
                    }
                    if (this.z1 >= i) continue;
                    this.z1 = i;
                }
            }
        }
        this.x0 -= n2;
        this.y0 -= n2;
        this.z0 -= n2;
        this.x1 += n2 + 1;
        this.y1 += n2 + 1;
        this.z1 += n2 + 1;
        if (this.x0 < 0) {
            this.x0 = 0;
        }
        if (this.y0 < 0) {
            this.y0 = 0;
        }
        if (this.z0 < 0) {
            this.z0 = 0;
        }
        if (this.x1 > this.orig.w) {
            this.x1 = this.orig.w;
        }
        if (this.y1 > this.orig.h) {
            this.y1 = this.orig.h;
        }
        if (this.z1 > this.orig.d) {
            this.z1 = this.orig.d;
        }
    }

    int getOrig(int n, int n2, int n3) {
        return this.orig.getNoCheck(n, n2, n3);
    }

    float getTransformed(double d, double d2, double d3) {
        this.matrix.apply(d, d2, d3);
        return (float)this.transform.interpol.get(this.matrix.x, this.matrix.y, this.matrix.z);
    }

    float getTransformedNoInterpol(double d, double d2, double d3) {
        this.matrix.apply(d, d2, d3);
        return this.transform.getNoInterpol((int)Math.round(this.matrix.x), (int)Math.round(this.matrix.y), (int)Math.round(this.matrix.z));
    }

    public class Iterator
    implements java.util.Iterator {
        int i;
        int j;
        int k;
        double x;
        double y;
        double z;
        public boolean showProgress;
        int x0;
        int y0;
        int z0;
        int x1;
        int y1;
        int z1;
        int xd;
        int zd;
        private boolean isIdentity;
        private Point3d start;
        private Point3d stop;

        public Iterator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
            this.showProgress = bl;
            this.x0 = n;
            this.y0 = n2;
            this.z0 = n3;
            this.x1 = n4;
            this.y1 = n5;
            this.z1 = n6;
            this.xd = n4 - n;
            this.zd = n6 - n3;
            this.i = n4;
            this.j = n2 - 1;
            this.k = n3;
            this.isIdentity = TransformedImage.this.matrix.isIdentity();
        }

        public boolean hasNext() {
            return this.i + 1 < this.x1 || this.j + 1 < this.y1 || this.k + 1 < this.z1;
        }

        public Object next() {
            if (++this.i >= this.x1) {
                this.i = this.x0;
                if (++this.j >= this.y1) {
                    this.j = this.y0;
                    if (++this.k >= this.z1) {
                        return null;
                    }
                    if (this.showProgress) {
                        IJ.showProgress((int)(this.k - this.z0 + 1), (int)this.zd);
                    }
                }
                if (!this.isIdentity) {
                    TransformedImage.this.matrix.apply(0.0, this.j, this.k);
                    this.start = TransformedImage.this.matrix.getResult();
                    TransformedImage.this.matrix.apply(this.x1, this.j, this.k);
                    this.stop = TransformedImage.this.matrix.getResult().minus(this.start);
                }
            }
            if (this.isIdentity) {
                this.x = this.i;
                this.y = this.j;
                this.z = this.k;
            } else {
                this.x = this.start.x + this.stop.x * (double)this.i / (double)this.x1;
                this.y = this.start.y + this.stop.y * (double)this.i / (double)this.x1;
                this.z = this.start.z + this.stop.z * (double)this.i / (double)this.x1;
            }
            return this;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

