/*
 * Decompiled with CFR 0.152.
 */
package vib.app.gui;

import ij.ImagePlus;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.io.File;
import vib.app.Options;
import vib.app.module.AverageBrain;
import vib.app.module.Label;
import vib.app.module.Module;
import vib.app.module.ModuleListener;
import vib.app.module.Resample;
import vib.app.module.SplitChannels;
import vib.app.module.TissueStatistics;
import vib.app.module.TransformImages;

public class ProgressIndicator
implements ModuleListener {
    private String[] modules = new String[]{new SplitChannels().getName(), new Label().getName(), new Resample().getName(), new TissueStatistics().getName(), new TransformImages().getName(), new AverageBrain().getName()};
    private String[] files;
    private int[][] done;
    private static final int NOT_DONE = 0;
    private static final int DONE = 1;
    private static final int EXCEPTION = 2;
    private static final int WIDTH = 800;
    private static final int HEIGHT = 500;
    private Garten garten;

    public ProgressIndicator(Options options) {
        this.done = new int[options.fileGroup.size() + 1][this.modules.length];
        this.files = new String[options.fileGroup.size()];
        for (int i = 0; i < options.fileGroup.size(); ++i) {
            this.files[i] = ((File)options.fileGroup.get(i)).getName();
        }
        this.showDialog();
    }

    public static void main(String[] stringArray) {
        Options options = new Options();
        options.loadFrom("/home/bene/PhD/brains/VIB_Protocol/options.config");
        new ProgressIndicator(options);
    }

    public void moduleFinished(Module module, int n) {
        if (n < 0) {
            return;
        }
        int n2 = this.getModuleIndex(module.getName());
        if (n2 != -1 && this.done[n][n2] != 1) {
            this.done[n][n2] = 1;
            this.garten.draw();
        }
    }

    public void exceptionOccurred(Module module, int n) {
        if (n < 0) {
            return;
        }
        int n2 = this.getModuleIndex(module.getName());
        if (n2 != -1) {
            this.done[n][n2] = 2;
            this.garten.draw();
        }
    }

    private int getModuleIndex(String string) {
        for (int i = 0; i < this.modules.length; ++i) {
            if (!this.modules[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void showDialog() {
        this.garten = new Garten();
        this.garten.image.show();
        this.garten.draw();
    }

    class Garten {
        Font f = new Font("Verdana", 1, 12);
        int colW = this.calculateColWidth();
        int rowH = this.calculateRowHeight();
        int cols = ProgressIndicator.access$000(ProgressIndicator.this).length;
        int rows = ProgressIndicator.access$100(ProgressIndicator.this).length;
        final int xIndent = 10;
        final int yIndent = 10;
        final int strIndent = 5;
        ImagePlus image;
        ImageProcessor ip;
        final float SIN45 = (float)(0.5 * Math.sqrt(2.0));

        Garten() {
            this.ip = new ColorProcessor(this.colW * (this.cols + 1) + 20, this.rowH * (this.rows + 1) + 20);
            this.ip.setBackgroundValue(0.0);
            this.image = new ImagePlus("Progress", this.ip);
        }

        public void draw() {
            int n;
            this.ip.setFont(this.f);
            this.ip.setColor(Color.WHITE);
            for (n = 0; n < this.rows; ++n) {
                this.ip.drawLine(10, 15 + (n + 1) * this.rowH, (this.cols + 1) * this.colW, 15 + (n + 1) * this.rowH);
            }
            for (n = 0; n < this.cols; ++n) {
                this.ip.drawLine(10 + (n + 1) * this.colW, 10, 10 + (n + 1) * this.colW, 15 + (this.rows + 1) * this.rowH);
            }
            for (n = 0; n < ProgressIndicator.this.modules.length; ++n) {
                this.ip.drawString(ProgressIndicator.this.modules[n], (n + 1) * this.colW + 10 + 5, this.rowH + 10);
            }
            for (n = 0; n < ProgressIndicator.this.files.length; ++n) {
                this.ip.drawString(ProgressIndicator.this.files[n], 15, 10 + (n + 2) * this.rowH);
            }
            for (n = 0; n < ProgressIndicator.this.files.length; ++n) {
                block10: for (int i = 0; i < ProgressIndicator.this.modules.length; ++i) {
                    switch (ProgressIndicator.this.done[n][i]) {
                        case 1: {
                            this.drawOK(n, i);
                            continue block10;
                        }
                        case 0: {
                            this.drawNY(n, i);
                            continue block10;
                        }
                        case 2: {
                            this.drawEX(n, i);
                        }
                    }
                }
            }
            this.image.updateAndDraw();
        }

        public void drawNY(int n, int n2) {
            int n3 = 10 + (n2 + 1) * this.colW;
            int n4 = 15 + (n + 1) * this.rowH;
            int n5 = (this.rowH - 5) / 2;
            int n6 = n3 + this.colW / 2;
            int n7 = n4 + this.rowH / 2;
            this.ip.setColor(Color.GRAY);
            this.ip.fillOval(n6 - n5, n7 - n5, 2 * n5, 2 * n5);
            this.ip.setColor(Color.BLACK);
            this.ip.drawOval(n6 - n5, n7 - n5, 2 * n5, 2 * n5);
        }

        public void drawOK(int n, int n2) {
            int n3 = 10 + (n2 + 1) * this.colW;
            int n4 = 15 + (n + 1) * this.rowH;
            int n5 = (this.rowH - 5) / 2;
            int n6 = n3 + this.colW / 2;
            int n7 = n4 + this.rowH / 2;
            this.ip.setColor(Color.GREEN);
            this.ip.fillOval(n6 - n5, n7 - n5, 2 * n5, 2 * n5);
            this.ip.setColor(Color.BLACK);
            int n8 = (int)((float)n5 * this.SIN45);
            this.ip.drawLine(n6 - n8, n7, n6, n7 + n8);
            this.ip.drawLine(n6, n7 + n8, n6 + n8, n7 - n8);
            this.ip.setColor(Color.WHITE);
            this.ip.drawLine(n6 + n8, n7 - n8, n6 + n5, n7 - n5);
        }

        public void drawEX(int n, int n2) {
            int n3 = 10 + (n2 + 1) * this.colW;
            int n4 = 15 + (n + 1) * this.rowH;
            int n5 = (this.rowH - 5) / 2;
            int n6 = n3 + this.colW / 2;
            int n7 = n4 + this.rowH / 2;
            this.ip.setColor(Color.RED);
            this.ip.fillOval(n6 - n5, n7 - n5, 2 * n5, 2 * n5);
            this.ip.setColor(Color.BLACK);
            this.ip.drawOval(n6 - n5, n7 - n5, 2 * n5, 2 * n5);
            int n8 = (int)((float)n5 * this.SIN45);
            this.ip.drawLine(n6 - n8, n7 - n8, n6 + n8, n7 + n8);
            this.ip.drawLine(n6 - n8, n7 + n8, n6 + n8, n7 - n8);
        }

        public int calculateColWidth() {
            int n;
            int n2;
            int n3 = 0;
            FontMetrics fontMetrics = new Frame().getFontMetrics(this.f);
            for (n2 = 0; n2 < ProgressIndicator.this.modules.length; ++n2) {
                n = fontMetrics.stringWidth(ProgressIndicator.this.modules[n2]);
                if (n3 >= n) continue;
                n3 = n;
            }
            for (n2 = 0; n2 < ProgressIndicator.this.files.length; ++n2) {
                n = fontMetrics.stringWidth(ProgressIndicator.this.files[n2]);
                if (n3 >= n) continue;
                n3 = n;
            }
            return n3 + 10;
        }

        public int calculateRowHeight() {
            return new Frame().getFontMetrics(this.f).getHeight() + 10;
        }
    }
}

