/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import distance.TwoValues;
import ij.ImagePlus;
import util.StupidLog;
import vib.FastMatrix;
import vib.FloatMatrix;
import vib.RigidRegistration_;
import vib.TransformedImage;
import vib.app.ImageMetaData;
import vib.app.module.CenterTransformation;
import vib.app.module.Module;
import vib.app.module.State;

public class LabelCenterTransformation
extends Module {
    public String getName() {
        return "LabelCenterTransformation";
    }

    protected String getMessage() {
        return "Registering the individual neuropils";
    }

    protected void run(State state, int n) {
        new CenterTransformation().runOnOneImage(state, n);
        this.prereqsDone(state, n);
        String string = state.getResampledPath(-1, n);
        String string2 = state.getStatisticsPath(n);
        ImageMetaData imageMetaData = state.getStatistics(-1);
        ImageMetaData imageMetaData2 = new ImageMetaData(string2);
        boolean bl = !State.upToDate(string, string2);
        String string3 = state.getTransformLabel(3);
        String string4 = state.getTransformLabel(2);
        FloatMatrix floatMatrix = imageMetaData2.getMatrix(string4);
        ImagePlus imagePlus = null;
        ImagePlus imagePlus2 = null;
        int n2 = imageMetaData2.materials.length;
        for (int i = 1; i < n2; ++i) {
            int n3;
            ImageMetaData.Material material = imageMetaData2.materials[i];
            if (material.count == 0 || (n3 = imageMetaData.getMaterialIndex(material.name)) < 0) continue;
            String string5 = string3 + material.name;
            if (!bl && imageMetaData2.upToDate(string, string5)) continue;
            String string6 = floatMatrix.toStringForAmira();
            int n4 = 4;
            int n5 = 2;
            double d = 4.0;
            String string7 = "";
            boolean bl2 = false;
            int n6 = 1;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (imagePlus == null) {
                imagePlus = state.getImage(string);
            }
            if (imagePlus2 == null) {
                imagePlus2 = state.getTemplateLabels();
            }
            while (n4 > 0 && imagePlus2.getWidth() >> n4 < 32) {
                --n4;
            }
            if (n5 > n4) {
                n5 = n4;
            }
            TransformedImage transformedImage = new TransformedImage(imagePlus2, imagePlus);
            transformedImage.measure = new TwoValues(n3, i);
            RigidRegistration_ rigidRegistration_ = new RigidRegistration_();
            StupidLog.log("registering neuropil: " + material.name + " between:");
            StupidLog.log("           labelPath: " + string);
            StupidLog.log("      templateLabels: " + imagePlus2.getTitle());
            FastMatrix fastMatrix = rigidRegistration_.rigidRegistration(transformedImage, string7, string6, n3, i, bl2, n4, n5, d, n6, bl3, bl4, bl5, null);
            String string8 = fastMatrix.toStringForAmira();
            FloatMatrix floatMatrix2 = FloatMatrix.parseMatrix(string8);
            imageMetaData2.setMatrix(string5, floatMatrix2);
            if (imageMetaData2.saveTo(string2)) continue;
            throw new RuntimeException("Could not save " + string2);
        }
    }
}

