/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.ImagePlus;
import vib.Resample_;
import vib.app.module.Label;
import vib.app.module.Module;
import vib.app.module.State;

public class ResampleLabels
extends Module {
    public String getName() {
        return "ResampleLabels";
    }

    protected String getMessage() {
        return "Resampling label";
    }

    protected void run(State state, int n) {
        if (n < 0) {
            new Label().runOnAllImagesAndTemplate(state);
        }
        this.prereqsDone(state, n);
        if (state.options.resamplingFactor == 1) {
            return;
        }
        String string = state.getImagePath(-1, n);
        String string2 = state.getResampledPath(-1, n);
        if (State.upToDate(string, string2)) {
            return;
        }
        ImagePlus imagePlus = state.getImage(string);
        ImagePlus imagePlus2 = Resample_.resample(imagePlus, state.options.resamplingFactor);
        if (!state.save(imagePlus2, string2)) {
            throw new RuntimeException("Could not save " + string2);
        }
    }
}

