/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileSaver;
import java.io.File;
import vib.FloatMatrix;
import vib.app.ImageMetaData;
import vib.app.Options;

public class State {
    public Options options;
    public static boolean debug = true;
    private String[][] channels;
    private String imagesPath;
    private String labelPath;
    private String resampledPath;
    private String warpedPath;
    private String outputPath;
    private String statisticsPath;
    private String currentImagePath;
    private ImagePlus currentImage;
    private ImagePlus templateLabels;
    private ImagePlus templ;

    public State(Options options) {
        int n;
        this.options = options;
        this.imagesPath = this.createDirname("images");
        this.labelPath = this.createDirname("labels");
        this.mkdir(this.labelPath);
        this.resampledPath = options.resamplingFactor > 1 ? this.createDirname("resampled") : null;
        if (options.transformationMethod == 3) {
            this.warpedPath = this.createDirname("warped");
        }
        this.outputPath = this.createDirname("output");
        this.statisticsPath = this.createDirname("statistics");
        this.mkdir(this.statisticsPath);
        for (n = -1; n < options.numChannels; ++n) {
            if (this.warpedPath != null) {
                this.mkdir(this.warpedPath + this.getChannelName(n));
            }
            if (n >= 0 && options.numChannels > 1) {
                this.mkdir(this.imagesPath + this.getChannelName(n));
            }
            if (this.resampledPath != null) {
                this.mkdir(this.resampledPath + this.getChannelName(n));
            }
            this.mkdir(this.outputPath + this.getChannelName(n));
        }
        n = options.fileGroup.size();
        this.channels = new String[options.numChannels][n];
        for (int i = 0; i < n; ++i) {
            File file = (File)options.fileGroup.get(i);
            String string = file.getName();
            for (int j = 0; j < options.numChannels; ++j) {
                this.channels[j][i] = file.getAbsolutePath();
            }
        }
    }

    public String getBaseName(int n) {
        if (n < 0) {
            return this.getTemplateBaseName();
        }
        return State.getBaseName(this.channels[0][n]);
    }

    public String getTemplateBaseName() {
        return State.getBaseName(this.options.templatePath);
    }

    public static String getBaseName(String string) {
        int n;
        int n2 = string.lastIndexOf(File.separator);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        if ((n = string.lastIndexOf(46)) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public String getChannelName(int n) {
        return n < 0 ? "_labels" : (this.options.numChannels < 2 ? "" : "_" + (n + 1));
    }

    public String getImagePath(int n, int n2) {
        if (n < 0) {
            return this.labelPath + File.separator + this.getBaseName(n2) + ".labels";
        }
        if (n2 < 0 && this.options.numChannels == 1) {
            return this.options.templatePath;
        }
        if (this.options.numChannels < 2) {
            return this.channels[n][n2];
        }
        String string = this.imagesPath + this.getChannelName(n) + File.separator + this.getBaseName(n2) + ".tif";
        return string;
    }

    public String getResampledPath(int n, int n2) {
        if (this.options.resamplingFactor == 1) {
            return this.getImagePath(n, n2);
        }
        return this.resampledPath + this.getChannelName(n) + File.separator + this.getBaseName(n2) + ".tif";
    }

    public String getWarpedPath(int n, int n2) {
        if (this.warpedPath == null) {
            return this.getResampledPath(n, n2);
        }
        return this.warpedPath + this.getChannelName(n) + File.separator + this.getBaseName(n2) + ".warped";
    }

    public String getOutputPath(int n) {
        return this.outputPath + this.getChannelName(n) + File.separator + this.getTemplateBaseName() + ".tif";
    }

    public String getStatisticsPath() {
        return this.statisticsPath;
    }

    public String getStatisticsPath(int n) {
        return this.statisticsPath + File.separator + this.getBaseName(n) + ".statistics";
    }

    public ImageMetaData getStatistics(int n) {
        try {
            return new ImageMetaData(this.getStatisticsPath(n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getTransformLabel() {
        return this.getTransformLabel(this.options.transformationMethod);
    }

    public String getTransformLabel(int n) {
        return this.getTemplateBaseName() + Options.TRANSFORM_LABELS[n];
    }

    public FloatMatrix getTransformMatrix(int n) {
        ImageMetaData imageMetaData = this.getStatistics(n);
        FloatMatrix floatMatrix = imageMetaData.getMatrix(this.getTransformLabel());
        return floatMatrix != null ? floatMatrix : new FloatMatrix(1.0f);
    }

    public int getImageCount() {
        return this.channels[0].length;
    }

    public static boolean upToDate(String[] stringArray, String string) {
        File file = new File(string);
        if (!file.exists()) {
            if (debug) {
                System.err.println("File " + string + " is not up-to-date, since it " + "does not exist");
            }
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(stringArray[i]);
            if (!file2.exists()) continue;
            try {
                if (file2.lastModified() <= file.lastModified()) continue;
                if (debug) {
                    System.err.println("File " + string + " is older than " + stringArray[i]);
                }
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static boolean upToDate(String string, String string2) {
        return State.upToDate(new String[]{string}, string2);
    }

    public boolean save(ImagePlus imagePlus, String string) {
        this.currentImagePath = string;
        this.currentImage = imagePlus;
        return new FileSaver(imagePlus).saveAsTiffStack(string);
    }

    public ImagePlus getImage(String string) {
        if (!string.equals(this.currentImagePath)) {
            File file = new File(string);
            if (!file.exists()) {
                return null;
            }
            this.currentImage = null;
            this.currentImagePath = string;
            this.currentImage = IJ.openImage((String)this.currentImagePath);
        }
        return this.currentImage;
    }

    public ImagePlus getTemplateLabels() {
        if (this.templateLabels == null) {
            this.templateLabels = IJ.openImage((String)this.getResampledPath(-1, -1));
        }
        return this.templateLabels;
    }

    public ImagePlus getTemplate() {
        if (this.templ == null) {
            String string = this.getResampledPath(this.options.refChannel - 1, -1);
            this.templ = IJ.openImage((String)string);
        }
        return this.templ;
    }

    private void mkdir(String string) {
        new File(string).mkdir();
    }

    private String createDirname(String string) {
        return this.options.workingDirectory + File.separator + string;
    }
}

