/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.ImagePlus;
import vib.TissueStatistics_;
import vib.app.ImageMetaData;
import vib.app.module.Module;
import vib.app.module.ResampleLabels;
import vib.app.module.State;

public class TissueStatistics
extends Module {
    public String getName() {
        return "TissueStatistics";
    }

    protected String getMessage() {
        return "Calculating tissue statistics";
    }

    protected void run(State state, int n) {
        new ResampleLabels().runOnOneImage(state, n);
        this.prereqsDone(state, n);
        String string = state.getStatisticsPath(n);
        String string2 = state.getImagePath(-1, n);
        if (State.upToDate(string2, string)) {
            return;
        }
        ImagePlus imagePlus = state.getImage(string2);
        TissueStatistics_.Statistics statistics = TissueStatistics_.getStatistics(imagePlus);
        ImageMetaData imageMetaData = new ImageMetaData();
        for (int i = 0; i < statistics.materials.length; ++i) {
            imageMetaData.setMaterial(statistics.materials[i], (int)statistics.count[i], (double)statistics.count[i] * statistics.voxelVolume(), statistics.centerX(i), statistics.centerY(i), statistics.centerZ(i));
        }
        if (!imageMetaData.saveTo(string)) {
            throw new RuntimeException("Could not save " + string);
        }
    }
}

