/*
 * Decompiled with CFR 0.152.
 */
package vib.oldregistration;

import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import vib.transforms.Threshold;

class IntensityMap
implements PlugInFilter {
    private ImagePlus image;
    private String arg;
    private int[] domainToTemplate;
    private int[] templateToDomain;

    IntensityMap() {
    }

    public static int[] histogramToCumulative(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = n += nArray[i];
        }
        return nArray2;
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }

    public void run(ImageProcessor imageProcessor) {
        ImageStack imageStack = this.image.getStack();
        for (int i = 0; i < this.image.getStackSize(); ++i) {
            byte[] byArray = (byte[])imageStack.getPixels(i + 1);
            for (int j = 0; j < byArray.length; ++j) {
                int n = this.domainToTemplate[byArray[j] & 0xFF];
                byArray[j] = (byte)n;
            }
            imageStack.setPixels((Object)byArray, i + 1);
        }
    }

    public static IntensityMap fromHistograms(int[] nArray, int[] nArray2) {
        return IntensityMap.fromHistograms(nArray, nArray2, new Threshold(0, 0L), new Threshold(0, 0L));
    }

    public static IntensityMap fromHistograms(int[] nArray, int[] nArray2, Threshold threshold, Threshold threshold2) {
        float f;
        int n;
        int n2;
        int n3;
        IntensityMap intensityMap = new IntensityMap();
        int[] nArray3 = (int[])nArray.clone();
        int[] nArray4 = (int[])nArray2.clone();
        for (n3 = 0; n3 < threshold.value; ++n3) {
            nArray3[n3] = 0;
        }
        for (n3 = 0; n3 < threshold2.value; ++n3) {
            nArray4[n3] = 0;
        }
        int[] nArray5 = IntensityMap.histogramToCumulative(nArray3);
        int[] nArray6 = IntensityMap.histogramToCumulative(nArray4);
        long l = nArray5[nArray5.length - 1];
        long l2 = nArray6[nArray6.length - 1];
        float[] fArray = new float[nArray5.length];
        float[] fArray2 = new float[nArray6.length];
        for (n2 = 0; n2 < nArray5.length; ++n2) {
            fArray[n2] = (float)nArray5[n2] / (float)l;
        }
        for (n2 = 0; n2 < nArray6.length; ++n2) {
            fArray2[n2] = (float)nArray6[n2] / (float)l2;
        }
        int[] nArray7 = new int[nArray4.length];
        int[] nArray8 = new int[nArray3.length];
        int n4 = threshold.value;
        for (n = threshold2.value; n < nArray4.length; ++n) {
            f = fArray2[n];
            while (f > fArray[n4]) {
                ++n4;
            }
            nArray7[n] = n4;
        }
        n4 = 0;
        for (n = 1; n < nArray3.length; ++n) {
            f = fArray[n];
            while (f > fArray2[n4]) {
                ++n4;
            }
            nArray8[n] = n4;
        }
        intensityMap.domainToTemplate = nArray7;
        intensityMap.templateToDomain = nArray8;
        return intensityMap;
    }
}

