/*
 * Decompiled with CFR 0.152.
 */
package vib.oldregistration;

import java.util.Arrays;
import java.util.Comparator;
import vib.transforms.FastMatrixTransform;

class PrincipalComponents {
    public double[][] vectors;
    public double[] values;
    public double[] meanXYZ;
    public FastMatrixTransform correctAspect;

    public String toString() {
        String string = "Means in each dimension: ( " + this.meanXYZ[0] + ", " + this.meanXYZ[1] + ", " + this.meanXYZ[2] + ")\n";
        for (int i = 0; i < 3; ++i) {
            string = string + "  [ " + this.vectors[i][0] + ",   (eigenvalue: " + this.values[i] + ")\n";
            string = string + "    " + this.vectors[i][1] + ",\n";
            string = string + "    " + this.vectors[i][2] + " ]\n";
        }
        return string;
    }

    public PrincipalComponents(double[] dArray, double[][] dArray2, double[] dArray3, double d, double d2, double d3) {
        int n;
        this.correctAspect = new FastMatrixTransform(1.0).scale(d, d2, d3);
        if (dArray.length != 3) {
            throw new IllegalArgumentException("There must be 3 eigenvalues (not " + dArray.length + ")");
        }
        Double[] doubleArray = new Double[3];
        for (n = 0; n < 3; ++n) {
            doubleArray[n] = dArray[n];
        }
        Arrays.sort(doubleArray, new MagnitudeComparator());
        this.values = new double[3];
        for (n = 0; n < 3; ++n) {
            this.values[n] = doubleArray[n];
        }
        if (dArray2.length != 3 || dArray2[0].length != 3 || dArray2[1].length != 3 || dArray2[2].length != 3) {
            throw new IllegalArgumentException("The eigenvecctors must be passed as double[3][3] array");
        }
        boolean[] blArray = new boolean[3];
        blArray[2] = false;
        blArray[1] = false;
        blArray[0] = false;
        this.vectors = new double[3][];
        for (int i = 0; i < 3; ++i) {
            int n2 = 0;
            while (blArray[n2] || this.values[n2] != dArray[i]) {
                ++n2;
            }
            this.vectors[n2] = (double[])dArray2[i].clone();
            blArray[n2] = true;
        }
        if (dArray3.length != 3) {
            throw new IllegalArgumentException("There must be 3 mean values (not " + dArray3.length + ")");
        }
        this.meanXYZ = (double[])dArray3.clone();
        assert (this.values != null);
        assert (this.vectors[0] != null);
        assert (this.vectors[1] != null);
        assert (this.vectors[2] != null);
        assert (this.meanXYZ != null);
    }

    class MagnitudeComparator
    implements Comparator {
        MagnitudeComparator() {
        }

        public int compare(Object object, Object object2) {
            double d = (Double)object;
            double d2 = (Double)object2;
            return Double.compare(Math.abs(d), Math.abs(d2));
        }
    }
}

