/*
 * Decompiled with CFR 0.152.
 */
package vib.segment;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageLayout;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import vib.IDT_Interpolate_Binary;
import vib.segment.CustomCanvas;
import vib.segment.Sidebar;

public class CustomStackWindow
extends StackWindow
implements AdjustmentListener,
KeyListener,
ActionListener,
MouseMotionListener,
MouseWheelListener {
    private Roi[] savedRois;
    private int oldSlice;
    private ActionListener al;
    private Sidebar sidebar;
    private CustomCanvas cc = (CustomCanvas)this.getCanvas();
    private Button ok;

    public CustomStackWindow(ImagePlus imagePlus) {
        super(imagePlus, (ImageCanvas)new CustomCanvas(imagePlus));
        this.savedRois = new Roi[imagePlus.getStack().getSize() + 1];
        this.oldSlice = this.sliceSelector.getValue();
        this.sliceSelector.addAdjustmentListener(this);
        this.cc.removeKeyListener((KeyListener)this.ij);
        this.cc.addKeyListener(this);
        this.cc.addMouseMotionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.LIGHT_GRAY);
        this.remove(this.sliceSelector);
        this.remove((Component)((Object)this.cc));
        this.sidebar = new Sidebar(this.cc, this);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridheight = 2;
        gridBagLayout.setConstraints(this.sidebar, gridBagConstraints);
        this.add(this.sidebar, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.sliceSelector, gridBagConstraints);
        this.add(this.sliceSelector, gridBagConstraints);
        Container container = new Container();
        container.setLayout((LayoutManager)new ImageLayout((ImageCanvas)this.cc));
        container.add((Component)((Object)this.cc));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(container, gridBagConstraints);
        this.add(container, gridBagConstraints);
        Panel panel = new Panel(new FlowLayout());
        this.ok = new Button("Ok");
        this.ok.addActionListener(this);
        panel.add(this.ok);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel, gridBagConstraints);
        this.pack();
        this.cc.requestFocus();
    }

    public void cleanUp() {
        this.savedRois = null;
        this.al = null;
        this.sidebar.getMaterials().labels = null;
        this.sidebar = null;
        this.ok = null;
        this.cc.releaseImage();
        this.cc = null;
        this.imp.close();
        this.imp = null;
    }

    public ImagePlus getLabels() {
        return this.cc.getLabels();
    }

    public void setLabels(ImagePlus imagePlus) {
        this.sidebar.setLabelImage(imagePlus);
    }

    public void addActionListener(ActionListener actionListener) {
        this.al = actionListener;
    }

    public Sidebar getSidebar() {
        return this.sidebar;
    }

    public CustomCanvas getCustomCanvas() {
        return this.cc;
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public void processPlusButton() {
        int n = this.cc.getImage().getCurrentSlice();
        Roi roi = this.cc.getImage().getRoi();
        this.assignSliceTo(n, roi, this.sidebar.currentMaterialID());
        this.cc.getImage().killRoi();
        if (this.sidebar.is3d()) {
            for (int i = 0; i < this.savedRois.length; ++i) {
                roi = this.savedRois[i];
                if (roi == null) continue;
                this.assignSliceTo(i, roi, this.sidebar.currentMaterialID());
                this.savedRois[i] = null;
            }
        }
        this.cc.getImage().setSlice(n);
        this.cc.getLabels().setSlice(n);
        this.cc.getImage().updateAndDraw();
        this.cc.getLabels().updateAndDraw();
        this.cc.requestFocus();
    }

    public void processMinusButton() {
        int n = this.cc.getImage().getCurrentSlice();
        Roi roi = this.cc.getImage().getRoi();
        this.releaseSliceFrom(n, roi, this.sidebar.currentMaterialID());
        this.cc.getImage().killRoi();
        if (this.sidebar.is3d()) {
            for (int i = 0; i < this.savedRois.length; ++i) {
                roi = this.savedRois[i];
                if (roi == null) continue;
                this.releaseSliceFrom(i, roi, this.sidebar.currentMaterialID());
                this.savedRois[i] = null;
            }
        }
        this.cc.getImage().setSlice(n);
        this.cc.getLabels().setSlice(n);
        this.cc.getImage().updateAndDraw();
        this.cc.getLabels().updateAndDraw();
        this.cc.requestFocus();
    }

    public void processInterpolateButton() {
        this.updateRois();
        new Thread(new Runnable(){

            public void run() {
                CustomStackWindow.this.setCursor(3);
                new IDT_Interpolate_Binary().run(CustomStackWindow.this.cc.getImage(), CustomStackWindow.this.savedRois);
                CustomStackWindow.this.setCursor(0);
            }
        }).start();
        this.cc.requestFocus();
    }

    public void processThresholdButton() {
        IJ.runPlugIn((String)"vib.Local_Threshold", (String)"");
    }

    public void processCloseButton() {
        ImagePlus imagePlus = this.cc.getImage();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        ByteProcessor byteProcessor = new ByteProcessor(imageProcessor.getWidth(), imageProcessor.getHeight());
        byteProcessor.setBackgroundValue(0.0);
        byteProcessor.setRoi(imagePlus.getRoi());
        byteProcessor.setValue(255.0);
        byteProcessor.fill(byteProcessor.getMask());
        byteProcessor.dilate();
        byteProcessor.erode();
        byteProcessor.setThreshold(255.0, 255.0, 2);
        ImagePlus imagePlus2 = new ImagePlus(" ", (ImageProcessor)byteProcessor);
        ThresholdToSelection thresholdToSelection = new ThresholdToSelection();
        thresholdToSelection.setup("", imagePlus2);
        thresholdToSelection.run((ImageProcessor)byteProcessor);
        byteProcessor.resetThreshold();
        imagePlus.setRoi(imagePlus2.getRoi());
    }

    public void processOpenButton() {
        ImagePlus imagePlus = this.cc.getImage();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        ByteProcessor byteProcessor = new ByteProcessor(imageProcessor.getWidth(), imageProcessor.getHeight());
        byteProcessor.setBackgroundValue(0.0);
        byteProcessor.setRoi(imagePlus.getRoi());
        byteProcessor.setValue(255.0);
        byteProcessor.fill(byteProcessor.getMask());
        byteProcessor.erode();
        byteProcessor.dilate();
        byteProcessor.setThreshold(255.0, 255.0, 2);
        ImagePlus imagePlus2 = new ImagePlus(" ", (ImageProcessor)byteProcessor);
        ThresholdToSelection thresholdToSelection = new ThresholdToSelection();
        thresholdToSelection.setup("", imagePlus2);
        thresholdToSelection.run((ImageProcessor)byteProcessor);
        byteProcessor.resetThreshold();
        imagePlus.setRoi(imagePlus2.getRoi());
    }

    public void assignSliceTo(int n, Roi roi, int n2) {
        ImagePlus imagePlus = this.cc.getImage();
        ImagePlus imagePlus2 = this.cc.getLabels();
        if (imagePlus == null || imagePlus2 == null) {
            return;
        }
        if (roi == null) {
            return;
        }
        int n3 = imagePlus2.getWidth();
        int n4 = imagePlus2.getHeight();
        ImageProcessor imageProcessor = imagePlus2.getStack().getProcessor(n);
        imageProcessor.setRoi(roi);
        Rectangle rectangle = roi.getBoundingRect();
        int n5 = rectangle.x > 0 ? rectangle.x : 0;
        int n6 = rectangle.y > 0 ? rectangle.y : 0;
        int n7 = n5 + rectangle.width <= n3 ? n5 + rectangle.width : n3;
        int n8 = n6 + rectangle.height <= n4 ? n6 + rectangle.height : n4;
        for (int i = n5; i < n7; ++i) {
            for (int j = n6; j < n8; ++j) {
                if (!roi.contains(i, j)) continue;
                int n9 = imageProcessor.get(i, j);
                if (this.sidebar.getMaterials().isLocked(n9)) continue;
                imageProcessor.set(i, j, n2);
            }
        }
        this.cc.updateSlice(n);
    }

    public void releaseSliceFrom(int n, Roi roi, int n2) {
        ImagePlus imagePlus = this.cc.getImage();
        ImagePlus imagePlus2 = this.cc.getLabels();
        if (imagePlus == null || imagePlus2 == null) {
            return;
        }
        if (roi == null) {
            return;
        }
        if (this.sidebar.getMaterials().isLocked(n2)) {
            return;
        }
        int n3 = imagePlus2.getWidth();
        int n4 = imagePlus2.getHeight();
        ImageProcessor imageProcessor = imagePlus2.getStack().getProcessor(n);
        imageProcessor.setRoi(roi);
        Rectangle rectangle = roi.getBoundingRect();
        int n5 = rectangle.x > 0 ? rectangle.x : 0;
        int n6 = rectangle.y > 0 ? rectangle.y : 0;
        int n7 = n5 + rectangle.width <= n3 ? n5 + rectangle.width : n3;
        int n8 = n6 + rectangle.height <= n4 ? n6 + rectangle.height : n4;
        for (int i = n5; i < n7; ++i) {
            for (int j = n6; j < n8; ++j) {
                if (!roi.contains(i, j) || imageProcessor.get(i, j) != n2) continue;
                imageProcessor.set(i, j, this.sidebar.getMaterials().getDefaultMaterialID());
            }
        }
        this.cc.updateSlice(n);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.cc.offScreenX(mouseEvent.getX());
        int n2 = this.cc.offScreenY(mouseEvent.getY());
        if (n < this.imp.getWidth() && n2 < this.imp.getHeight()) {
            Calibration calibration = this.imp.getCalibration();
            double d = calibration.getX((double)n);
            d = Double.valueOf(IJ.d2s((double)d));
            double d2 = calibration.getY((double)n2);
            d2 = Double.valueOf(IJ.d2s((double)d2));
            int n3 = this.imp.getCurrentSlice() - 1;
            double d3 = calibration.getZ((double)n3);
            d3 = Double.valueOf(IJ.d2s((double)d3));
            int n4 = this.imp.getProcessor().get(n, n2);
            int n5 = this.cc.getLabels().getStack().getProcessor(n3 + 1).get(n, n2);
            String string = this.sidebar.getMaterials().params.getMaterialName(n5);
            IJ.showStatus((String)("x=" + d + ", y=" + d2 + ", z=" + d3 + ", value=" + n4 + ", material=" + string));
        }
    }

    public void paint(Graphics graphics) {
        this.drawInfo(graphics);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("zoomin")) {
            this.cc.zoomIn(this.cc.getWidth() / 2, this.cc.getHeight() / 2);
            this.cc.requestFocus();
        } else if (string.equals("zoomout")) {
            this.cc.zoomOut(this.cc.getWidth() / 2, this.cc.getHeight() / 2);
            this.cc.requestFocus();
        } else if (string.equals("plus")) {
            this.processPlusButton();
        } else if (string.equals("minus")) {
            this.processMinusButton();
        } else if (string.equals("interpolate")) {
            this.processInterpolateButton();
        } else if (string.equals("threshold")) {
            this.processThresholdButton();
        } else if (string.equals("open")) {
            this.processOpenButton();
        } else if (string.equals("close")) {
            this.processCloseButton();
        } else if (string.equals("Ok")) {
            if (this.al != null) {
                this.al.actionPerformed(actionEvent);
            }
            if (this.getImagePlus() != null) {
                new StackWindow(this.getImagePlus());
            }
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        super.adjustmentValueChanged(adjustmentEvent);
        this.updateRois();
    }

    public synchronized void updateRois() {
        this.savedRois[this.oldSlice] = this.imp.getRoi();
        this.oldSlice = this.sliceSelector.getValue();
        if (this.savedRois[this.oldSlice] == null) {
            this.imp.killRoi();
        } else {
            this.imp.setRoi(this.savedRois[this.oldSlice]);
        }
        this.repaint();
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        super.mouseWheelMoved(mouseWheelEvent);
        this.updateRois();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (n == 40 || n == 39 || c == '>') {
            this.imp.setSlice(this.oldSlice + 1);
            this.adjustmentValueChanged(new AdjustmentEvent(this.sliceSelector, 601, 4, this.oldSlice + 1));
        } else if (n == 38 || n == 37 || c == '<') {
            this.imp.setSlice(this.oldSlice - 1);
            this.adjustmentValueChanged(new AdjustmentEvent(this.sliceSelector, 601, 3, this.oldSlice - 1));
        } else if (n == 33) {
            this.imp.setSlice(this.oldSlice - 5);
            this.adjustmentValueChanged(new AdjustmentEvent(this.sliceSelector, 601, 3, this.oldSlice - 5));
        } else if (n == 34) {
            this.imp.setSlice(this.oldSlice + 5);
            this.adjustmentValueChanged(new AdjustmentEvent(this.sliceSelector, 601, 3, this.oldSlice + 5));
        } else if (c == '+' || c == '=') {
            this.processPlusButton();
        } else if (c == '-') {
            this.processMinusButton();
        } else if (c == 'i') {
            this.processInterpolateButton();
        } else if (c == 't') {
            this.processThresholdButton();
        } else if (c == 'o') {
            this.processOpenButton();
        } else if (c == 'c') {
            this.processCloseButton();
        }
    }
}

