/*
 * Decompiled with CFR 0.152.
 */
package vib.segment;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.util.Vector;
import vib.segment.Border;
import vib.segment.DefaultImageButtonBorder;
import vib.segment.DisableImageFilter;

public class ImageButton
extends Canvas
implements MouseListener {
    public static final int UNARMED = 0;
    public static final int ARMED = 1;
    public static final int OVER = 2;
    public static final int DISABLED = 3;
    private static final Border defaultUnarmedBorder = new DefaultImageButtonBorder(false);
    private static final Border defaultArmedBorder = new DefaultImageButtonBorder(true);
    private MediaTracker tracker;
    private Image[] images = new Image[4];
    private Border[] borders = new Border[4];
    private boolean generatedDisabled = false;
    private boolean mousedown = false;
    private int buttonState = 0;
    private String command = "";
    Color borderColor = Color.GRAY;
    Vector actionListeners = new Vector();

    public ImageButton() {
        this.tracker = new MediaTracker(this);
        this.setUnarmedBorder(defaultUnarmedBorder);
        this.setArmedBorder(defaultArmedBorder);
        this.addMouseListener(this);
    }

    public ImageButton(Image image) {
        this();
        this.setUnarmedImage(image);
    }

    private synchronized void setImage(int n, Image image) {
        if (image == null) {
            throw new RuntimeException("Image is null!");
        }
        if (this.images[n] != image) {
            this.images[n] = image;
            if (image != null) {
                this.tracker.addImage(image, n);
                this.tracker.checkID(n, true);
            }
            if (this.buttonState == n) {
                this.repaint();
            }
        }
    }

    public void setUnarmedImage(Image image) {
        this.setImage(0, image);
        if (this.images[1] == null) {
            this.setArmedImage(image);
        }
        if (this.images[2] == null) {
            this.setOverImage(image);
        }
        if (this.images[3] == null || this.generatedDisabled) {
            this.setDisabledImage(null);
        }
    }

    public void setArmedImage(Image image) {
        if (image != null) {
            this.setImage(1, image);
        } else {
            this.setImage(1, this.images[0]);
        }
    }

    public void setOverImage(Image image) {
        if (image != null) {
            this.setImage(2, image);
        } else {
            this.setImage(2, this.images[0]);
        }
    }

    public void setDisabledImage(Image image) {
        this.generatedDisabled = false;
        if (image == null && this.images[0] != null) {
            this.generatedDisabled = true;
            image = this.createImage(new FilteredImageSource(this.images[0].getSource(), new DisableImageFilter()));
        }
        this.setImage(3, image);
    }

    public Image getUnarmedImage() {
        return this.images[0];
    }

    public Image getArmedImage() {
        return this.images[1];
    }

    public Image getOverImage() {
        return this.images[2];
    }

    public Image getDisabledImage() {
        return this.images[3];
    }

    private synchronized void setBorder(int n, Border border) {
        if (this.borders[n] != border) {
            this.borders[n] = border;
            if (this.buttonState == n) {
                this.repaint();
            }
        }
    }

    public void setUnarmedBorder(Border border) {
        this.setBorder(0, border);
        if (this.borders[1] == null) {
            this.setArmedBorder(border);
        }
        if (this.borders[2] == null) {
            this.setOverBorder(border);
        }
        if (this.borders[3] == null) {
            this.setDisabledBorder(border);
        }
    }

    public void setArmedBorder(Border border) {
        if (border != null) {
            this.setBorder(1, border);
        } else {
            this.setBorder(1, this.borders[0]);
        }
    }

    public void setOverBorder(Border border) {
        if (border != null) {
            this.setBorder(2, border);
        } else {
            this.setBorder(2, this.borders[0]);
        }
        this.setBorder(2, border);
    }

    public void setDisabledBorder(Border border) {
        if (border != null) {
            this.setBorder(3, border);
        } else {
            this.setBorder(3, this.borders[0]);
        }
        if (this.buttonState == 3) {
            this.repaint();
        }
    }

    public Border getUnarmedBorder() {
        return this.borders[0];
    }

    public Border getArmedBorder() {
        return this.borders[1];
    }

    public Border getOverBorder() {
        return this.borders[2];
    }

    public Border getDisabledBorder() {
        return this.borders[3];
    }

    public int getButtonState() {
        return this.buttonState;
    }

    protected void setButtonState(int n) {
        if (n != this.buttonState) {
            this.buttonState = n;
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.setBackground(this.borderColor);
        this.borders[this.buttonState].paint(graphics, this.borderColor, 0, 0, dimension.width, dimension.height);
        try {
            if (!this.tracker.checkID(this.buttonState)) {
                this.tracker.waitForID(this.buttonState);
            }
            if (!this.tracker.isErrorID(this.buttonState)) {
                Insets insets = this.borders[this.buttonState].getInsets();
                int n = this.images[this.buttonState].getWidth(this);
                int n2 = this.images[this.buttonState].getHeight(this);
                int n3 = insets.left + (dimension.width - (insets.left + insets.right) - n) / 2;
                int n4 = insets.top + (dimension.height - (insets.top + insets.bottom) - n2) / 2;
                graphics.drawImage(this.images[this.buttonState], n3, n4, this);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        try {
            if (!this.tracker.checkID(this.buttonState)) {
                this.tracker.waitForID(this.buttonState);
            }
            if (!this.tracker.isErrorID(this.buttonState)) {
                Dimension dimension2 = this.getSize();
                dimension.width = this.images[this.buttonState].getWidth(this);
                dimension.height = this.images[this.buttonState].getHeight(this);
            }
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < 3; ++i) {
                Insets insets = this.borders[i].getInsets();
                n = Math.max(n, insets.left + insets.right);
                n2 = Math.max(n2, insets.top + insets.bottom);
            }
            dimension.width += n;
            dimension.height += n2;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return dimension;
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mousedown = true;
        this.setButtonState(1);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mousedown = false;
        this.setButtonState(0);
        this.processActionEvent(new ActionEvent(this, 0, this.command));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

