/*
 * Decompiled with CFR 0.152.
 */
package vib.segment;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.ColorChooser;
import ij.gui.GenericDialog;
import java.awt.Canvas;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import vib.segment.CustomCanvas;

public class MaterialList
extends ScrollPane
implements ActionListener,
ItemListener {
    PopupMenu popup;
    ImagePlus labels;
    AmiraParameters params;
    CustomCanvas cc;
    Font font;
    int lineHeight;
    int lineWidth;
    List list;
    private boolean[] locked;
    MenuItem remove;
    MenuItem add;
    MenuItem rename;
    MenuItem color;
    CheckboxMenuItem lock;

    public MaterialList(CustomCanvas customCanvas) {
        this.cc = customCanvas;
        this.createPopup();
        this.font = new Font("Monospaced", 0, 12);
        this.lineHeight = this.font.getSize() + 1;
        this.lineWidth = 200;
        this.list = new List();
        this.add(this.list);
        this.locked = new boolean[0];
    }

    public MaterialList(ImagePlus imagePlus, CustomCanvas customCanvas) {
        this(customCanvas);
        this.initFrom(imagePlus);
    }

    public void releaseImage() {
        this.labels = null;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.list.setBackground(color);
    }

    private int getSelectedIndex() {
        return this.list.selectedIndex;
    }

    private void select(int n) {
        this.list.selectedIndex = n;
    }

    public int getItemCount() {
        return this.params.getMaterialCount();
    }

    public String getItem(int n) {
        return this.params.getMaterialName(n);
    }

    public String getSelectedItem() {
        return this.getItem(this.getSelectedIndex());
    }

    public int getIndexOf(String string) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItem(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void createPopup() {
        this.popup = new PopupMenu("");
        this.add = new MenuItem("Add Material");
        this.popup.add(this.add);
        this.remove = new MenuItem("Remove Material");
        this.rename = new MenuItem("Rename Material");
        this.popup.add(this.rename);
        this.color = new MenuItem("Change Color");
        this.popup.add(this.color);
        this.popup.addSeparator();
        this.lock = new CheckboxMenuItem("Locked");
        this.popup.add(this.lock);
        this.add.addActionListener(this);
        this.remove.addActionListener(this);
        this.rename.addActionListener(this);
        this.color.addActionListener(this);
        this.lock.addItemListener(this);
        this.add(this.popup);
    }

    public void initFrom(ImagePlus imagePlus) {
        this.labels = imagePlus;
        this.params = new AmiraParameters(imagePlus);
        if (this.params.getMaterialCount() == 0) {
            this.params.addMaterial("Exterior", 0.0, 0.0, 0.0);
            this.params.addMaterial("Interior", 1.0, 0.0, 0.0);
            this.params.setParameters(this.labels);
        }
        this.locked = new boolean[this.params.getMaterialCount()];
        if (this.list != null) {
            this.list.invalidate();
            this.list.repaint();
        }
    }

    public void setMaterials(String string) {
        this.params = new AmiraParameters(string);
        this.locked = new boolean[this.params.getMaterialCount()];
        if (this.list != null) {
            this.list.invalidate();
            this.list.repaint();
        }
    }

    public void addMaterial() {
        int n = this.getItemCount();
        this.params.addMaterial("Material" + ++n, 1.0, 0.0, 0.0);
        this.params.setParameters(this.labels);
        boolean[] blArray = new boolean[n];
        System.arraycopy(this.locked, 0, blArray, 0, this.locked.length);
        this.locked = blArray;
        this.select(n - 1);
        this.doLayout();
        this.list.repaint();
    }

    public void delMaterial() {
        int n = this.getSelectedIndex();
        if (n < 1) {
            IJ.error((String)"Cannot delete first material!");
            return;
        }
        throw new RuntimeException("delete not yet implemented");
    }

    private void renameMaterial() {
        GenericDialog genericDialog = new GenericDialog("Rename");
        genericDialog.addStringField("name", this.getSelectedItem());
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.params.editMaterial(this.currentMaterialID(), genericDialog.getNextString(), -1.0, -1.0, -1.0);
        this.params.setParameters(this.labels);
        this.list.repaint();
    }

    private void setColor() {
        int n = this.currentMaterialID();
        double[] dArray = this.params.getMaterialColor(n);
        Color color = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
        String string = this.params.getMaterialName(n) + " Color";
        ColorChooser colorChooser = new ColorChooser(string, color, false);
        Color color2 = colorChooser.getColor();
        if (color2 != null) {
            this.params.editMaterial(n, null, (double)color2.getRed() / 255.0, (double)color2.getGreen() / 255.0, (double)color2.getBlue() / 255.0);
            this.params.setParameters(this.labels);
            this.labels.updateAndDraw();
            this.list.repaint();
            if (this.cc != null) {
                this.cc.setLabels(this.labels);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.remove) {
            this.delMaterial();
        } else if (actionEvent.getSource() == this.add) {
            this.addMaterial();
        } else if (actionEvent.getSource() == this.rename) {
            this.renameMaterial();
        } else if (actionEvent.getSource() == this.color) {
            this.setColor();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.lock) {
            boolean bl;
            this.locked[this.getSelectedIndex()] = bl = this.lock.getState();
        }
    }

    public int currentMaterialID() {
        if (this.getSelectedIndex() == -1) {
            return -1;
        }
        return this.params.getMaterialID(this.getSelectedItem());
    }

    public double[] currentMaterialColor() {
        int n = this.currentMaterialID();
        if (n == -1) {
            return null;
        }
        return this.params.getMaterialColor(n);
    }

    public int getDefaultMaterialID() {
        return this.params.getMaterialID(this.getItem(0));
    }

    public boolean isLocked(int n) {
        return this.locked[this.getIndexOf(this.params.getMaterialName(n))];
    }

    private class List
    extends Canvas {
        Color fgCol = Color.BLACK;
        Color bgCol = Color.LIGHT_GRAY;
        private int selectedIndex = 0;

        public List() {
            this.enableEvents(24L);
        }

        public void setBackground(Color color) {
            this.bgCol = color;
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getID() == 502) {
                this.selectedIndex = mouseEvent.getY() / MaterialList.this.lineHeight;
                this.repaint();
            }
            if (mouseEvent.isPopupTrigger() && (n = mouseEvent.getY() / MaterialList.this.lineHeight) < MaterialList.this.getItemCount()) {
                this.selectedIndex = n;
                this.repaint();
                MaterialList.this.lock.setState(MaterialList.this.locked[n]);
                MaterialList.this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401) {
                int n = keyEvent.getKeyCode();
                if (n == 38 && this.selectedIndex > 0) {
                    this.ensureVisible(--this.selectedIndex, true);
                } else if (n == 40 && this.selectedIndex < MaterialList.this.getItemCount() - 1) {
                    this.ensureVisible(++this.selectedIndex, true);
                }
            }
        }

        public void ensureVisible(int n, boolean bl) {
            Point point = MaterialList.this.getScrollPosition();
            Dimension dimension = MaterialList.this.getViewportSize();
            if (point.y + dimension.height < (n + 1) * MaterialList.this.lineHeight || point.y > n * MaterialList.this.lineHeight) {
                MaterialList.this.setScrollPosition(point.x, n * MaterialList.this.lineHeight);
                this.repaint();
            } else if (bl) {
                this.repaint();
            }
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            int n;
            graphics.setFont(MaterialList.this.font);
            for (n = 0; n < MaterialList.this.getItemCount(); ++n) {
                graphics.setColor(n == this.selectedIndex ? this.fgCol : this.bgCol);
                graphics.fillRect(0, n * MaterialList.this.lineHeight, MaterialList.this.lineWidth, MaterialList.this.lineHeight);
                double[] dArray = MaterialList.this.params.getMaterialColor(n);
                graphics.setColor(new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]));
                graphics.fillRect(1, n * MaterialList.this.lineHeight + 1, MaterialList.this.lineHeight - 2, MaterialList.this.lineHeight - 2);
                graphics.setColor(n == this.selectedIndex ? this.bgCol : this.fgCol);
                graphics.drawString(MaterialList.this.getItem(n), MaterialList.this.lineHeight, (n + 1) * MaterialList.this.lineHeight - 1);
            }
            n = MaterialList.this.lineHeight * MaterialList.this.getItemCount();
            if (n < this.getHeight()) {
                graphics.setColor(this.bgCol);
                graphics.fillRect(0, n, MaterialList.this.lineWidth, this.getHeight() - n);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(MaterialList.this.lineWidth, MaterialList.this.getItemCount() * (MaterialList.this.font.getSize() + 1) + 1);
        }
    }
}

