/*
 * Decompiled with CFR 0.152.
 */
package vib.transforms;

import math3d.Bookstein;
import math3d.Point3d;
import vib.transforms.Transform;

public class BooksteinTransform
extends Bookstein
implements Transform {
    protected Point3d[] originalPoints;
    protected Point3d[] transformedPoints;

    public BooksteinTransform inverse() {
        return new BooksteinTransform(this.transformedPoints, this.originalPoints);
    }

    public Transform composeWith(Transform transform) {
        return null;
    }

    public boolean isIdentity() {
        return false;
    }

    public int getTransformType() {
        return 0;
    }

    public String toStringIndented(String string) {
        return string + "FIXME: implement this...\n";
    }

    public BooksteinTransform(Point3d[] point3dArray, Point3d[] point3dArray2) {
        super(point3dArray, point3dArray2);
        this.originalPoints = point3dArray;
        this.transformedPoints = point3dArray2;
    }

    public void apply(double d, double d2, double d3, double[] dArray) {
        Point3d point3d = new Point3d(d, d2, d3);
        dArray[0] = this.bx.evalInit(point3d);
        dArray[1] = this.by.evalInit(point3d);
        dArray[2] = this.bz.evalInit(point3d);
        for (int i = 0; i < this.points.length; ++i) {
            double d4 = BooksteinTransform.U(point3d.distanceTo(this.points[i]));
            dArray[0] = dArray[0] + this.bx.w[i] * d4;
            dArray[1] = dArray[1] + this.by.w[i] * d4;
            dArray[2] = dArray[2] + this.bz.w[i] * d4;
        }
    }

    public void apply(double d, double d2, double d3) {
        this.apply(new Point3d(d, d2, d3));
    }
}

