/*
 * Decompiled with CFR 0.152.
 */
package vib.transforms;

import ij.ImagePlus;
import ij.measure.Calibration;
import math3d.Point3d;
import vib.FastMatrix;
import vib.transforms.Transform;

public class FastMatrixTransform
extends FastMatrix
implements Transform {
    public FastMatrixTransform() {
    }

    public FastMatrixTransform(double d) {
        super(d);
    }

    public FastMatrixTransform(double[][] dArray) {
        super(dArray);
    }

    public FastMatrixTransform(FastMatrix fastMatrix) {
        super(fastMatrix);
    }

    private FastMatrixTransform invert3x3() {
        double d = this.a11 * this.a22 - this.a12 * this.a21;
        double d2 = this.a10 * this.a22 - this.a12 * this.a20;
        double d3 = this.a10 * this.a21 - this.a11 * this.a20;
        double d4 = this.a01 * this.a22 - this.a02 * this.a21;
        double d5 = this.a00 * this.a22 - this.a02 * this.a20;
        double d6 = this.a00 * this.a21 - this.a01 * this.a20;
        double d7 = this.a01 * this.a12 - this.a02 * this.a11;
        double d8 = this.a00 * this.a12 - this.a02 * this.a10;
        double d9 = this.a00 * this.a11 - this.a01 * this.a10;
        double d10 = this.a00 * d - this.a01 * d2 + this.a02 * d3;
        FastMatrixTransform fastMatrixTransform = new FastMatrixTransform();
        fastMatrixTransform.a00 = d / d10;
        fastMatrixTransform.a01 = -d4 / d10;
        fastMatrixTransform.a02 = d7 / d10;
        fastMatrixTransform.a10 = -d2 / d10;
        fastMatrixTransform.a11 = d5 / d10;
        fastMatrixTransform.a12 = -d8 / d10;
        fastMatrixTransform.a20 = d3 / d10;
        fastMatrixTransform.a21 = -d6 / d10;
        fastMatrixTransform.a22 = d9 / d10;
        return fastMatrixTransform;
    }

    public FastMatrixTransform inverse() {
        FastMatrixTransform fastMatrixTransform = this.invert3x3();
        fastMatrixTransform.apply(-this.a03, -this.a13, -this.a23);
        fastMatrixTransform.a03 = fastMatrixTransform.x;
        fastMatrixTransform.a13 = fastMatrixTransform.y;
        fastMatrixTransform.a23 = fastMatrixTransform.z;
        return fastMatrixTransform;
    }

    public int getTransformType() {
        return 1;
    }

    public Transform composeWith(Transform transform) {
        switch (transform.getTransformType()) {
            case 0: {
                return null;
            }
            case 1: {
                FastMatrix fastMatrix = (FastMatrix)((Object)transform);
                return this.composeWithFastMatrix(fastMatrix);
            }
        }
        return null;
    }

    public FastMatrixTransform composeWithFastMatrix(FastMatrix fastMatrix) {
        FastMatrixTransform fastMatrixTransform = this;
        FastMatrixTransform fastMatrixTransform2 = new FastMatrixTransform(fastMatrix);
        FastMatrixTransform fastMatrixTransform3 = new FastMatrixTransform();
        fastMatrixTransform3.a00 = fastMatrixTransform.a00 * fastMatrixTransform2.a00 + fastMatrixTransform.a10 * fastMatrixTransform2.a01 + fastMatrixTransform.a20 * fastMatrixTransform2.a02;
        fastMatrixTransform3.a10 = fastMatrixTransform.a00 * fastMatrixTransform2.a10 + fastMatrixTransform.a10 * fastMatrixTransform2.a11 + fastMatrixTransform.a20 * fastMatrixTransform2.a12;
        fastMatrixTransform3.a20 = fastMatrixTransform.a00 * fastMatrixTransform2.a20 + fastMatrixTransform.a10 * fastMatrixTransform2.a21 + fastMatrixTransform.a20 * fastMatrixTransform2.a22;
        fastMatrixTransform3.a01 = fastMatrixTransform.a01 * fastMatrixTransform2.a00 + fastMatrixTransform.a11 * fastMatrixTransform2.a01 + fastMatrixTransform.a21 * fastMatrixTransform2.a02;
        fastMatrixTransform3.a11 = fastMatrixTransform.a01 * fastMatrixTransform2.a10 + fastMatrixTransform.a11 * fastMatrixTransform2.a11 + fastMatrixTransform.a21 * fastMatrixTransform2.a12;
        fastMatrixTransform3.a21 = fastMatrixTransform.a01 * fastMatrixTransform2.a20 + fastMatrixTransform.a11 * fastMatrixTransform2.a21 + fastMatrixTransform.a21 * fastMatrixTransform2.a22;
        fastMatrixTransform3.a02 = fastMatrixTransform.a02 * fastMatrixTransform2.a00 + fastMatrixTransform.a12 * fastMatrixTransform2.a01 + fastMatrixTransform.a22 * fastMatrixTransform2.a02;
        fastMatrixTransform3.a12 = fastMatrixTransform.a02 * fastMatrixTransform2.a10 + fastMatrixTransform.a12 * fastMatrixTransform2.a11 + fastMatrixTransform.a22 * fastMatrixTransform2.a12;
        fastMatrixTransform3.a22 = fastMatrixTransform.a02 * fastMatrixTransform2.a20 + fastMatrixTransform.a12 * fastMatrixTransform2.a21 + fastMatrixTransform.a22 * fastMatrixTransform2.a22;
        fastMatrixTransform3.a03 = fastMatrixTransform.a03 * fastMatrixTransform2.a00 + fastMatrixTransform.a13 * fastMatrixTransform2.a01 + fastMatrixTransform.a23 * fastMatrixTransform2.a02 + fastMatrixTransform2.a03;
        fastMatrixTransform3.a13 = fastMatrixTransform.a03 * fastMatrixTransform2.a10 + fastMatrixTransform.a13 * fastMatrixTransform2.a11 + fastMatrixTransform.a23 * fastMatrixTransform2.a12 + fastMatrixTransform2.a13;
        fastMatrixTransform3.a23 = fastMatrixTransform.a03 * fastMatrixTransform2.a20 + fastMatrixTransform.a13 * fastMatrixTransform2.a21 + fastMatrixTransform.a23 * fastMatrixTransform2.a22 + fastMatrixTransform2.a23;
        return fastMatrixTransform3;
    }

    public FastMatrixTransform[] decomposeFully() {
        FastMatrixTransform[] fastMatrixTransformArray = new FastMatrixTransform[4];
        FastMatrixTransform fastMatrixTransform = new FastMatrixTransform(this);
        fastMatrixTransformArray[3] = new FastMatrixTransform(1.0);
        fastMatrixTransformArray[3].a03 = this.a03;
        fastMatrixTransformArray[3].a13 = this.a13;
        fastMatrixTransformArray[3].a23 = this.a23;
        fastMatrixTransform.a03 = 0.0;
        fastMatrixTransform.a13 = 0.0;
        fastMatrixTransform.a23 = 0.0;
        Point3d point3d = new Point3d(1.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(0.0, 1.0, 0.0);
        Point3d point3d3 = new Point3d(0.0, 0.0, 1.0);
        fastMatrixTransform.apply(point3d);
        Point3d point3d4 = fastMatrixTransform.getResult();
        fastMatrixTransform.apply(point3d2);
        Point3d point3d5 = fastMatrixTransform.getResult();
        fastMatrixTransform.apply(point3d3);
        Point3d point3d6 = fastMatrixTransform.getResult();
        fastMatrixTransformArray[2] = new FastMatrixTransform(FastMatrixTransform.rotateToAlignVectors(point3d4.toArray(), point3d5.toArray(), point3d.toArray(), point3d2.toArray()));
        FastMatrixTransform fastMatrixTransform2 = fastMatrixTransformArray[2].inverse();
        fastMatrixTransform = fastMatrixTransform.composeWithFastMatrix(fastMatrixTransform2);
        fastMatrixTransformArray[1] = new FastMatrixTransform(point3d4.length());
        FastMatrixTransform fastMatrixTransform3 = fastMatrixTransformArray[1].inverse();
        fastMatrixTransformArray[0] = fastMatrixTransform = fastMatrixTransform.composeWithFastMatrix(fastMatrixTransform3);
        return fastMatrixTransformArray;
    }

    public void apply(double d, double d2, double d3, double[] dArray) {
        dArray[0] = d * this.a00 + d2 * this.a01 + d3 * this.a02 + this.a03;
        dArray[1] = d * this.a10 + d2 * this.a11 + d3 * this.a12 + this.a13;
        dArray[2] = d * this.a20 + d2 * this.a21 + d3 * this.a22 + this.a23;
    }

    public void setTranslation(double d, double d2, double d3) {
        this.a03 = d;
        this.a13 = d2;
        this.a23 = d3;
    }

    public static FastMatrixTransform fromCalibrationWithoutOrigin(ImagePlus imagePlus) {
        throw new RuntimeException("BUG: it's very unlikely that you really want to be calling fromCalibrationWithoutOrigin");
    }

    public static FastMatrixTransform fromCalibrationWithoutOrigin(Calibration calibration) {
        throw new RuntimeException("BUG: it's very unlikely that you really want to be calling fromCalibrationWithoutOrigin");
    }

    public FastMatrixTransform scale(double d, double d2, double d3) {
        FastMatrixTransform fastMatrixTransform = new FastMatrixTransform();
        fastMatrixTransform.a00 = this.a00 * d;
        fastMatrixTransform.a01 = this.a01 * d;
        fastMatrixTransform.a02 = this.a02 * d;
        fastMatrixTransform.a03 = this.a03 * d;
        fastMatrixTransform.a10 = this.a10 * d2;
        fastMatrixTransform.a11 = this.a11 * d2;
        fastMatrixTransform.a12 = this.a12 * d2;
        fastMatrixTransform.a13 = this.a13 * d2;
        fastMatrixTransform.a20 = this.a20 * d3;
        fastMatrixTransform.a21 = this.a21 * d3;
        fastMatrixTransform.a22 = this.a22 * d3;
        fastMatrixTransform.a23 = this.a23 * d3;
        return fastMatrixTransform;
    }

    public FastMatrixTransform times(FastMatrixTransform fastMatrixTransform) {
        FastMatrixTransform fastMatrixTransform2 = new FastMatrixTransform();
        fastMatrixTransform2.a00 = fastMatrixTransform.a00 * this.a00 + fastMatrixTransform.a10 * this.a01 + fastMatrixTransform.a20 * this.a02;
        fastMatrixTransform2.a10 = fastMatrixTransform.a00 * this.a10 + fastMatrixTransform.a10 * this.a11 + fastMatrixTransform.a20 * this.a12;
        fastMatrixTransform2.a20 = fastMatrixTransform.a00 * this.a20 + fastMatrixTransform.a10 * this.a21 + fastMatrixTransform.a20 * this.a22;
        fastMatrixTransform2.a01 = fastMatrixTransform.a01 * this.a00 + fastMatrixTransform.a11 * this.a01 + fastMatrixTransform.a21 * this.a02;
        fastMatrixTransform2.a11 = fastMatrixTransform.a01 * this.a10 + fastMatrixTransform.a11 * this.a11 + fastMatrixTransform.a21 * this.a12;
        fastMatrixTransform2.a21 = fastMatrixTransform.a01 * this.a20 + fastMatrixTransform.a11 * this.a21 + fastMatrixTransform.a21 * this.a22;
        fastMatrixTransform2.a02 = fastMatrixTransform.a02 * this.a00 + fastMatrixTransform.a12 * this.a01 + fastMatrixTransform.a22 * this.a02;
        fastMatrixTransform2.a12 = fastMatrixTransform.a02 * this.a10 + fastMatrixTransform.a12 * this.a11 + fastMatrixTransform.a22 * this.a12;
        fastMatrixTransform2.a22 = fastMatrixTransform.a02 * this.a20 + fastMatrixTransform.a12 * this.a21 + fastMatrixTransform.a22 * this.a22;
        this.apply(fastMatrixTransform.a03, fastMatrixTransform.a13, fastMatrixTransform.a23);
        fastMatrixTransform2.a03 = this.x;
        fastMatrixTransform2.a13 = this.y;
        fastMatrixTransform2.a23 = this.z;
        return fastMatrixTransform2;
    }

    public FastMatrixTransform plus(FastMatrixTransform fastMatrixTransform) {
        FastMatrixTransform fastMatrixTransform2 = new FastMatrixTransform();
        fastMatrixTransform2.a00 = fastMatrixTransform.a00 + this.a00;
        fastMatrixTransform2.a01 = fastMatrixTransform.a01 + this.a01;
        fastMatrixTransform2.a02 = fastMatrixTransform.a02 + this.a02;
        fastMatrixTransform2.a03 = fastMatrixTransform.a03 + this.a03;
        fastMatrixTransform2.a10 = fastMatrixTransform.a10 + this.a10;
        fastMatrixTransform2.a11 = fastMatrixTransform.a11 + this.a11;
        fastMatrixTransform2.a12 = fastMatrixTransform.a12 + this.a12;
        fastMatrixTransform2.a13 = fastMatrixTransform.a13 + this.a13;
        fastMatrixTransform2.a20 = fastMatrixTransform.a20 + this.a20;
        fastMatrixTransform2.a21 = fastMatrixTransform.a21 + this.a21;
        fastMatrixTransform2.a22 = fastMatrixTransform.a22 + this.a22;
        fastMatrixTransform2.a23 = fastMatrixTransform.a23 + this.a23;
        return fastMatrixTransform2;
    }

    public static FastMatrixTransform translate(double d, double d2, double d3) {
        FastMatrixTransform fastMatrixTransform = new FastMatrixTransform();
        fastMatrixTransform.a22 = 1.0;
        fastMatrixTransform.a11 = 1.0;
        fastMatrixTransform.a00 = 1.0;
        fastMatrixTransform.a03 = d;
        fastMatrixTransform.a13 = d2;
        fastMatrixTransform.a23 = d3;
        return fastMatrixTransform;
    }
}

