/*
 * Decompiled with CFR 0.152.
 */
package view4d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij3d.Content;
import ij3d.Executer;
import ij3d.Image3DUniverse;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;

public class Viewer4D {
    private String directory = null;
    private Image3DUniverse univ;
    private Content[] contents = null;
    private int current = 0;
    private boolean shouldPause = false;
    private int delay = 1000;

    public Viewer4D(Image3DUniverse image3DUniverse) {
        this.univ = image3DUniverse;
    }

    public int size() {
        if (this.contents == null) {
            return 0;
        }
        return this.contents.length;
    }

    public void faster() {
        if (this.delay >= 100) {
            this.delay -= 100;
        }
    }

    public void slower() {
        this.delay += 100;
    }

    public synchronized void play() {
        new Thread(new Runnable(){

            public void run() {
                while (!Viewer4D.this.shouldPause) {
                    if (Viewer4D.this.current < Viewer4D.this.contents.length - 1) {
                        Viewer4D.this.next();
                    } else {
                        Viewer4D.this.first();
                    }
                    try {
                        Thread.sleep(Viewer4D.this.delay);
                    }
                    catch (Exception exception) {
                        Viewer4D.this.shouldPause = false;
                    }
                }
                Viewer4D.this.shouldPause = false;
            }
        }).start();
    }

    public synchronized void pause() {
        this.shouldPause = true;
    }

    public void next() {
        if (this.contents == null || this.contents.length == 0) {
            return;
        }
        if (this.current == this.contents.length - 1) {
            return;
        }
        this.contents[this.current].setVisible(false);
        ++this.current;
        this.contents[this.current].setVisible(true);
        this.univ.setStatus(this.current + 1 + "/" + this.contents.length);
    }

    public void previous() {
        if (this.contents == null || this.contents.length == 0) {
            return;
        }
        if (this.current == 0) {
            return;
        }
        this.contents[this.current].setVisible(false);
        --this.current;
        this.contents[this.current].setVisible(true);
        this.univ.setStatus(this.current + 1 + "/" + this.contents.length);
    }

    public void first() {
        if (this.contents == null || this.contents.length == 0) {
            return;
        }
        if (this.current == 0) {
            return;
        }
        this.contents[this.current].setVisible(false);
        this.current = 0;
        this.contents[this.current].setVisible(true);
        this.univ.setStatus(this.current + 1 + "/" + this.contents.length);
    }

    public void last() {
        if (this.contents == null || this.contents.length == 0) {
            return;
        }
        if (this.current == this.contents.length - 1) {
            return;
        }
        this.contents[this.current].setVisible(false);
        this.current = this.contents.length - 1;
        this.contents[this.current].setVisible(true);
        this.univ.setStatus(this.current + 1 + "/" + this.contents.length);
    }

    public void releaseContents() {
        this.pause();
        this.directory = null;
        for (int i = 0; i < this.contents.length; ++i) {
            if (i == this.current) continue;
            this.univ.removeContent(this.contents[i].getName());
        }
        this.contents = null;
        this.current = 0;
        this.univ.setStatus("");
    }

    public boolean loadContents() {
        ImagePlus[] imagePlusArray;
        this.univ.removeAllContents();
        GenericDialog genericDialog = new GenericDialog("Load time lapse");
        genericDialog.addMessage("Select either a file containing a hyperstack\nor a directory containing your time lapse data");
        Panel panel = new Panel(new FlowLayout());
        Label label = new Label("Time lapse data");
        final TextField textField = new TextField(30);
        Button button = new Button("...");
        panel.add(label);
        panel.add(textField);
        panel.add(button);
        genericDialog.addPanel(panel);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpenDialog openDialog = new OpenDialog("Time lapse dir", null);
                String string = openDialog.getDirectory();
                String string2 = openDialog.getFileName();
                if (string == null || string2 == null) {
                    return;
                }
                textField.setText(new File(string, string2).getAbsolutePath());
            }
        });
        String[] stringArray = new String[]{"Volume", "Orthoslice", "Surface"};
        int n = 0;
        int n2 = 2;
        int n3 = 0;
        genericDialog.addChoice("Display as", stringArray, stringArray[0]);
        genericDialog.addNumericField("Threshold", (double)n, 0);
        genericDialog.addNumericField("Resampling factor", (double)n2, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        this.directory = textField.getText();
        this.directory = this.directory.replace('\\', '/');
        if (!this.directory.endsWith("/")) {
            this.directory = this.directory + "/";
        }
        n3 = genericDialog.getNextChoiceIndex();
        n = (int)genericDialog.getNextNumber();
        n2 = (int)genericDialog.getNextNumber();
        File file = new File(this.directory);
        if (!file.exists()) {
            IJ.showMessage((String)(this.directory + " does not exist"));
            return false;
        }
        ImagePlus[] imagePlusArray2 = imagePlusArray = file.isDirectory() ? this.getImages(file) : this.getImages(IJ.openImage((String)file.getAbsolutePath()));
        if (imagePlusArray == null || imagePlusArray.length == 0) {
            return false;
        }
        if (imagePlusArray.length == 0) {
            IJ.showMessage((String)"Could not load any of the images");
            return false;
        }
        this.load(imagePlusArray, n, n2, n3);
        return true;
    }

    public void load(ImagePlus[] imagePlusArray, int n, int n2, int n3) {
        Content[] contentArray = new Content[imagePlusArray.length];
        for (int i = 0; i < imagePlusArray.length; ++i) {
            this.univ.setStatus("Adding " + (i + 1) + "/" + imagePlusArray.length);
            ImagePlus imagePlus = imagePlusArray[i];
            Executer.convert(imagePlus);
            contentArray[i] = this.univ.addContent(imagePlus, null, imagePlus.getTitle(), n, new boolean[]{true, true, true}, n2, n3);
            contentArray[i].showCoordinateSystem(false);
            if (i == 0) continue;
            contentArray[i].setVisible(false);
        }
        this.contents = new Content[imagePlusArray.length];
        System.arraycopy(contentArray, 0, this.contents, 0, this.contents.length);
        this.univ.setStatus("");
        this.current = 0;
    }

    public ImagePlus[] getImages(ImagePlus imagePlus) {
        int n = imagePlus.getNChannels();
        if (n != 1) {
            IJ.showMessage((String)"Currently, images with one channel are\nsupported.");
            return null;
        }
        int n2 = imagePlus.getNSlices();
        int n3 = imagePlus.getNFrames();
        ImagePlus[] imagePlusArray = new ImagePlus[n3];
        int n4 = imagePlus.getWidth();
        int n5 = imagePlus.getHeight();
        ImageStack imageStack = imagePlus.getStack();
        String string = imagePlus.getTitle();
        int n6 = 1;
        for (int i = 0; i < n3; ++i) {
            ImageStack imageStack2 = new ImageStack(n4, n5);
            int n7 = 0;
            while (n7 < n2) {
                imageStack2.addSlice(imageStack.getSliceLabel(n6), imageStack.getPixels(n6));
                ++n7;
                ++n6;
            }
            imagePlusArray[i] = new ImagePlus(string + " (frame " + i + ")", imageStack2);
        }
        return imagePlusArray;
    }

    public ImagePlus[] getImages(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        Object[] objectArray = file.list();
        if (objectArray.length == 0) {
            IJ.showMessage((String)("No files in " + file.getName()));
            return null;
        }
        Arrays.sort(objectArray);
        ImagePlus[] imagePlusArray = new ImagePlus[objectArray.length];
        int n = 0;
        for (int i = 0; i < imagePlusArray.length; ++i) {
            this.univ.setStatus("Loading " + (n + 1) + "/" + objectArray.length);
            File file2 = new File(file, (String)objectArray[i]);
            ImagePlus imagePlus = IJ.openImage((String)file2.getAbsolutePath());
            if (imagePlus == null) continue;
            imagePlusArray[n++] = imagePlus;
        }
        return imagePlusArray;
    }
}

