/*
 * Decompiled with CFR 0.152.
 */
package voltex;

import ij3d.AxisConstants;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Vector4f;
import voltex.VoltexVolume;

public class AppearanceCreator
implements AxisConstants {
    private VoltexVolume volume;
    private int textureMode;
    private boolean opaque = false;
    private TexCoordGeneration xTg;
    private TexCoordGeneration yTg;
    private TexCoordGeneration zTg;
    private TextureAttributes texAttr;
    private TransparencyAttributes transAttr;
    private PolygonAttributes polyAttr;
    private Material material;
    private ColoringAttributes colAttr;
    private RenderingAttributes rendAttr;

    public AppearanceCreator(VoltexVolume voltexVolume) {
        this(voltexVolume, null, 0.1f);
    }

    public AppearanceCreator(VoltexVolume voltexVolume, Color3f color3f, float f) {
        this.initAttributes(color3f, f);
        this.setVolume(voltexVolume);
    }

    public void release() {
        this.xTg = null;
        this.yTg = null;
        this.zTg = null;
        this.volume = null;
    }

    public void setVolume(VoltexVolume voltexVolume) {
        boolean bl;
        this.volume = voltexVolume;
        this.zTg = new TexCoordGeneration();
        this.zTg.setPlaneS(new Vector4f(voltexVolume.xTexGenScale, 0.0f, 0.0f, -((float)((double)voltexVolume.xTexGenScale * voltexVolume.minCoord.x))));
        this.zTg.setPlaneT(new Vector4f(0.0f, voltexVolume.yTexGenScale, 0.0f, -((float)((double)voltexVolume.yTexGenScale * voltexVolume.minCoord.y))));
        this.yTg = new TexCoordGeneration();
        this.yTg.setPlaneS(new Vector4f(voltexVolume.xTexGenScale, 0.0f, 0.0f, -((float)((double)voltexVolume.xTexGenScale * voltexVolume.minCoord.x))));
        this.yTg.setPlaneT(new Vector4f(0.0f, 0.0f, voltexVolume.zTexGenScale, -((float)((double)voltexVolume.zTexGenScale * voltexVolume.minCoord.z))));
        this.xTg = new TexCoordGeneration();
        this.xTg.setPlaneS(new Vector4f(0.0f, voltexVolume.yTexGenScale, 0.0f, -((float)((double)voltexVolume.yTexGenScale * voltexVolume.minCoord.y))));
        this.xTg.setPlaneT(new Vector4f(0.0f, 0.0f, voltexVolume.zTexGenScale, -((float)((double)voltexVolume.zTexGenScale * voltexVolume.minCoord.z))));
        boolean bl2 = bl = voltexVolume.getDataType() == 0;
        this.textureMode = bl ? (this.opaque ? 5 : 6) : (this.opaque ? 2 : 1);
    }

    public void setOpaqueTextures(boolean bl) {
        if (this.opaque != bl) {
            boolean bl2;
            this.opaque = bl;
            boolean bl3 = bl2 = this.volume.getDataType() == 0;
            this.textureMode = bl2 ? (bl ? 5 : 6) : (bl ? 2 : 1);
        }
    }

    public Appearance getAppearance(int n, int n2) {
        Appearance appearance = new Appearance();
        appearance.setCapability(3);
        appearance.setCapability(5);
        appearance.setMaterial(this.material);
        appearance.setTransparencyAttributes(this.transAttr);
        appearance.setPolygonAttributes(this.polyAttr);
        appearance.setColoringAttributes(this.colAttr);
        appearance.setRenderingAttributes(this.rendAttr);
        appearance.setTexture((Texture)this.getTexture(n, n2));
        appearance.setTexCoordGeneration(this.getTg(n));
        appearance.setTextureAttributes(this.texAttr);
        return appearance;
    }

    public void setTransparency(float f) {
        this.transAttr.setTransparency(f);
    }

    public void setThreshold(float f) {
        this.rendAttr.setAlphaTestValue(f);
    }

    public void setColor(Color3f color3f) {
        this.colAttr.setColor(color3f);
    }

    public Texture2D getTexture(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        ImageComponent2D imageComponent2D = null;
        switch (n) {
            case 2: {
                n3 = this.volume.xTexSize;
                n4 = this.volume.yTexSize;
                imageComponent2D = this.volume.getImageComponentZ(n2);
                break;
            }
            case 1: {
                n3 = this.volume.xTexSize;
                n4 = this.volume.zTexSize;
                imageComponent2D = this.volume.getImageComponentY(n2);
                break;
            }
            case 0: {
                n3 = this.volume.yTexSize;
                n4 = this.volume.zTexSize;
                imageComponent2D = this.volume.getImageComponentX(n2);
            }
        }
        Texture2D texture2D = new Texture2D(1, this.textureMode, n3, n4);
        texture2D.setImage(0, (ImageComponent)imageComponent2D);
        texture2D.setEnable(true);
        texture2D.setMinFilter(3);
        texture2D.setMagFilter(3);
        texture2D.setBoundaryModeS(2);
        texture2D.setBoundaryModeT(2);
        return texture2D;
    }

    public TexCoordGeneration getTg(int n) {
        switch (n) {
            case 0: {
                return this.xTg;
            }
            case 1: {
                return this.yTg;
            }
            case 2: {
                return this.zTg;
            }
        }
        return null;
    }

    private void initAttributes(Color3f color3f, float f) {
        this.texAttr = new TextureAttributes();
        this.texAttr.setTextureMode(6);
        this.texAttr.setCombineRgbMode(1);
        this.texAttr.setPerspectiveCorrectionMode(1);
        this.transAttr = new TransparencyAttributes();
        this.transAttr.setTransparency(0.1f);
        this.transAttr.setCapability(3);
        this.transAttr.setTransparencyMode(2);
        this.transAttr.setTransparency(f);
        this.polyAttr = new PolygonAttributes();
        this.polyAttr.setCullFace(0);
        this.material = new Material();
        this.material.setLightingEnable(false);
        this.colAttr = new ColoringAttributes();
        this.colAttr.setCapability(1);
        this.colAttr.setShadeModel(1);
        if (color3f == null) {
            this.colAttr.setColor(1.0f, 1.0f, 1.0f);
        } else {
            this.colAttr.setColor(color3f);
        }
        this.rendAttr = new RenderingAttributes();
        this.rendAttr.setCapability(1);
        this.rendAttr.setAlphaTestValue(0.1f);
        this.rendAttr.setAlphaTestFunction(6);
    }
}

