/*
 * Decompiled with CFR 0.152.
 */
package voltex;

import ij3d.AxisConstants;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.QuadArray;
import voltex.VoltexVolume;

public class GeometryCreator
implements AxisConstants {
    private double[] quadCoords = new double[12];
    private VoltexVolume volume;

    public GeometryCreator(VoltexVolume voltexVolume) {
        this.volume = voltexVolume;
    }

    public void setVolume(VoltexVolume voltexVolume) {
        this.volume = voltexVolume;
    }

    public GeometryArray getQuad(int n, int n2) {
        this.calculateQuad(n, n2);
        QuadArray quadArray = new QuadArray(4, 1);
        quadArray.setCoordinates(0, this.quadCoords);
        quadArray.setCapability(18);
        quadArray.setCapability(1);
        return quadArray;
    }

    public double[] getQuadCoords(int n, int n2) {
        this.calculateQuad(n, n2);
        return this.quadCoords;
    }

    private void calculateQuad(int n, int n2) {
        switch (n) {
            case 0: {
                this.setCoordsY();
                this.setCoordsZ();
                this.setCurCoordX(n2);
                break;
            }
            case 1: {
                this.setCoordsX();
                this.setCoordsZ();
                this.setCurCoordY(n2);
                break;
            }
            case 2: {
                this.setCoordsX();
                this.setCoordsY();
                this.setCurCoordZ(n2);
            }
        }
    }

    private void setCurCoordX(int n) {
        double d;
        this.quadCoords[0] = d = (double)n * this.volume.pw + this.volume.minCoord.x;
        this.quadCoords[3] = d;
        this.quadCoords[6] = d;
        this.quadCoords[9] = d;
    }

    private void setCurCoordY(int n) {
        double d;
        this.quadCoords[1] = d = (double)n * this.volume.ph + this.volume.minCoord.y;
        this.quadCoords[4] = d;
        this.quadCoords[7] = d;
        this.quadCoords[10] = d;
    }

    private void setCurCoordZ(int n) {
        double d;
        this.quadCoords[2] = d = (double)n * this.volume.pd + this.volume.minCoord.z;
        this.quadCoords[5] = d;
        this.quadCoords[8] = d;
        this.quadCoords[11] = d;
    }

    private void setCoordsX() {
        this.quadCoords[1] = this.volume.minCoord.y;
        this.quadCoords[2] = this.volume.minCoord.z;
        this.quadCoords[4] = this.volume.maxCoord.y;
        this.quadCoords[5] = this.volume.minCoord.z;
        this.quadCoords[7] = this.volume.maxCoord.y;
        this.quadCoords[8] = this.volume.maxCoord.z;
        this.quadCoords[10] = this.volume.minCoord.y;
        this.quadCoords[11] = this.volume.maxCoord.z;
    }

    private void setCoordsY() {
        this.quadCoords[0] = this.volume.minCoord.x;
        this.quadCoords[2] = this.volume.minCoord.z;
        this.quadCoords[3] = this.volume.minCoord.x;
        this.quadCoords[5] = this.volume.maxCoord.z;
        this.quadCoords[6] = this.volume.maxCoord.x;
        this.quadCoords[8] = this.volume.maxCoord.z;
        this.quadCoords[9] = this.volume.maxCoord.x;
        this.quadCoords[11] = this.volume.minCoord.z;
    }

    private void setCoordsZ() {
        this.quadCoords[0] = this.volume.minCoord.x;
        this.quadCoords[1] = this.volume.minCoord.y;
        this.quadCoords[3] = this.volume.maxCoord.x;
        this.quadCoords[4] = this.volume.minCoord.y;
        this.quadCoords[6] = this.volume.maxCoord.x;
        this.quadCoords[7] = this.volume.maxCoord.y;
        this.quadCoords[9] = this.volume.minCoord.x;
        this.quadCoords[10] = this.volume.maxCoord.y;
    }
}

