/*
 * Decompiled with CFR 0.152.
 */
package voltex;

import ij.IJ;
import ij.ImagePlus;
import ij3d.Volume;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.j3d.ImageComponent2D;
import javax.vecmath.Point3d;

public class VoltexVolume
extends Volume {
    public final int xTexSize;
    public final int yTexSize;
    public final int zTexSize;
    public final float xTexGenScale;
    public final float yTexGenScale;
    public final float zTexGenScale;
    public final Point3d volRefPt = new Point3d();
    protected static final ColorModel greyCM = VoltexVolume.createGreyColorModel();
    protected static final ColorModel rgbCM = VoltexVolume.createRGBColorModel();
    protected ComponentCreator compCreator;
    private ImageUpdater updater = new ImageUpdater();
    private byte[][] xy;
    private byte[][] xz;
    private byte[][] yz;
    private ImageComponent2D[] xyComp;
    private ImageComponent2D[] xzComp;
    private ImageComponent2D[] yzComp;

    public VoltexVolume(ImagePlus imagePlus) {
        this(imagePlus, new boolean[]{true, true, true});
    }

    public VoltexVolume(ImagePlus imagePlus, boolean[] blArray) {
        super(imagePlus, blArray);
        this.xTexSize = VoltexVolume.powerOfTwo(this.xDim);
        this.yTexSize = VoltexVolume.powerOfTwo(this.yDim);
        this.zTexSize = VoltexVolume.powerOfTwo(this.zDim);
        float f = (float)this.pw;
        float f2 = (float)this.ph;
        float f3 = (float)this.pd;
        this.xTexGenScale = (float)(1.0 / (double)(f * (float)this.xTexSize));
        this.yTexGenScale = (float)(1.0 / (double)(f2 * (float)this.yTexSize));
        this.zTexGenScale = (float)(1.0 / (double)(f3 * (float)this.zTexSize));
        this.volRefPt.x = (this.maxCoord.x + this.minCoord.x) / 2.0;
        this.volRefPt.y = (this.maxCoord.y + this.minCoord.y) / 2.0;
        this.volRefPt.z = (this.maxCoord.z + this.minCoord.z) / 2.0;
        this.initLoader2();
        this.updateData();
        this.createImageComponents();
    }

    public void createImageComponents() {
        int n;
        for (n = 0; n < this.zDim; ++n) {
            this.xyComp[n] = this.compCreator.createImageComponent(this.xy[n], this.xTexSize, this.yTexSize);
        }
        for (n = 0; n < this.yDim; ++n) {
            this.xzComp[n] = this.compCreator.createImageComponent(this.xz[n], this.xTexSize, this.zTexSize);
        }
        for (n = 0; n < this.xDim; ++n) {
            this.yzComp[n] = this.compCreator.createImageComponent(this.yz[n], this.yTexSize, this.zTexSize);
        }
    }

    public void updateData() {
        int n;
        for (n = 0; n < this.zDim; ++n) {
            this.loadZ(n, this.xy[n]);
        }
        for (n = 0; n < this.yDim; ++n) {
            this.loadY(n, this.xz[n]);
        }
        for (n = 0; n < this.xDim; ++n) {
            this.loadX(n, this.yz[n]);
        }
    }

    public ImageComponent2D getImageComponentZ(int n) {
        return this.xyComp[n];
    }

    public ImageComponent2D getImageComponentY(int n) {
        return this.xzComp[n];
    }

    public ImageComponent2D getImageComponentX(int n) {
        return this.yzComp[n];
    }

    protected void initLoader() {
    }

    private void initLoader2() {
        boolean[] blArray = this.channels;
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            if (!this.channels[i]) continue;
            ++n;
        }
        switch (this.imp.getType()) {
            case 0: {
                this.loader = new ByteLoader(this.imp);
                this.compCreator = new GreyComponentCreator();
                this.dataType = 1;
                break;
            }
            case 4: {
                if (n == 1) {
                    this.loader = new ByteFromIntLoader(this.imp, blArray);
                    this.compCreator = new GreyComponentCreator();
                    this.dataType = 1;
                    break;
                }
                if (n == 2) {
                    if (this.average) {
                        this.loader = new ByteFromIntLoader(this.imp, blArray);
                        this.dataType = 1;
                        this.compCreator = new GreyComponentCreator();
                        break;
                    }
                    this.loader = new IntFromIntLoader(this.imp, blArray);
                    this.compCreator = new ColorComponentCreator();
                    this.dataType = 0;
                    break;
                }
                if (this.average) {
                    this.loader = new ByteFromIntLoader(this.imp, blArray);
                    this.compCreator = new GreyComponentCreator();
                    this.dataType = 1;
                    break;
                }
                this.loader = new IntLoader(this.imp);
                this.compCreator = new ColorComponentCreator();
                this.dataType = 0;
                break;
            }
            default: {
                IJ.error((String)"image format not supported");
            }
        }
    }

    protected static int powerOfTwo(int n) {
        int n2;
        for (n2 = 16; n2 < n; n2 *= 2) {
        }
        return n2;
    }

    private void loadZ(int n, byte[] byArray) {
        ((Loader)this.loader).loadZ(n, byArray);
    }

    private void loadY(int n, byte[] byArray) {
        ((Loader)this.loader).loadY(n, byArray);
    }

    private void loadX(int n, byte[] byArray) {
        ((Loader)this.loader).loadX(n, byArray);
    }

    private static final ColorModel createGreyColorModel() {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray[i] = (byte)i;
        }
        return new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }

    private static final ColorModel createRGBColorModel() {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int[] nArray = new int[]{8, 8, 8, 8};
        return new ComponentColorModel(colorSpace, nArray, true, false, 3, 0);
    }

    static /* synthetic */ ImageComponent2D[] access$302(VoltexVolume voltexVolume, ImageComponent2D[] imageComponent2DArray) {
        voltexVolume.xyComp = imageComponent2DArray;
        return imageComponent2DArray;
    }

    static /* synthetic */ ImageComponent2D[] access$402(VoltexVolume voltexVolume, ImageComponent2D[] imageComponent2DArray) {
        voltexVolume.xzComp = imageComponent2DArray;
        return imageComponent2DArray;
    }

    static /* synthetic */ ImageComponent2D[] access$502(VoltexVolume voltexVolume, ImageComponent2D[] imageComponent2DArray) {
        voltexVolume.yzComp = imageComponent2DArray;
        return imageComponent2DArray;
    }

    static /* synthetic */ byte[][] access$602(VoltexVolume voltexVolume, byte[][] byArray) {
        voltexVolume.xy = byArray;
        return byArray;
    }

    static /* synthetic */ byte[][] access$702(VoltexVolume voltexVolume, byte[][] byArray) {
        voltexVolume.xz = byArray;
        return byArray;
    }

    static /* synthetic */ byte[][] access$802(VoltexVolume voltexVolume, byte[][] byArray) {
        voltexVolume.yz = byArray;
        return byArray;
    }

    private final class ByteFromIntLoader
    extends Volume.ByteFromIntLoader
    implements Loader {
        ByteFromIntLoader(ImagePlus imagePlus, boolean[] blArray) {
            super(VoltexVolume.this, imagePlus, blArray);
            VoltexVolume.access$602(VoltexVolume.this, new byte[VoltexVolume.this.zDim][VoltexVolume.this.xTexSize * VoltexVolume.this.yTexSize]);
            VoltexVolume.access$702(VoltexVolume.this, new byte[VoltexVolume.this.yDim][VoltexVolume.this.xTexSize * VoltexVolume.this.zTexSize]);
            VoltexVolume.access$802(VoltexVolume.this, new byte[VoltexVolume.this.xDim][VoltexVolume.this.yTexSize * VoltexVolume.this.zTexSize]);
        }

        public void setNoCheck(int n, int n2, int n3, int n4) {
            super.setNoCheck(n, n2, n3, n4);
            int n5 = 0;
            if (this.channels[0]) {
                n5 += (n4 & 0xFF0000) >> 16;
            }
            if (this.channels[1]) {
                n5 += (n4 & 0xFF00) >> 8;
            }
            if (this.channels[2]) {
                n5 += n4 & 0xFF;
            }
            ((VoltexVolume)VoltexVolume.this).xy[n3][n2 * VoltexVolume.this.xTexSize + n] = (byte)(n5 /= this.usedCh);
            ((VoltexVolume)VoltexVolume.this).xz[n2][n3 * VoltexVolume.this.xTexSize + n] = (byte)n5;
            ((VoltexVolume)VoltexVolume.this).yz[n][n3 * VoltexVolume.this.yTexSize + n2] = (byte)n5;
            VoltexVolume.this.xyComp[n3].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, n, n2, 1, 1);
            VoltexVolume.this.xzComp[n2].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, n, n3, 1, 1);
            VoltexVolume.this.yzComp[n].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, n2, n3, 1, 1);
        }

        public void set(int n, int n2, int n3, int n4) {
            if (n >= 0 && n < VoltexVolume.this.xDim && n2 >= 0 && n2 < VoltexVolume.this.yDim && n3 >= 0 && n3 < VoltexVolume.this.zDim) {
                this.setNoCheck(n, n2, n3, n4);
            }
        }

        public void loadZ(int n, byte[] byArray) {
            int[] nArray = this.fdata[n];
            for (int i = 0; i < VoltexVolume.this.yDim; ++i) {
                int n2 = i * VoltexVolume.this.xDim;
                int n3 = i * VoltexVolume.this.xTexSize;
                for (int j = 0; j < VoltexVolume.this.xDim; ++j) {
                    int n4 = nArray[n2 + j];
                    int n5 = 0;
                    if (this.channels[0]) {
                        n5 += (n4 & 0xFF0000) >> 16;
                    }
                    if (this.channels[1]) {
                        n5 += (n4 & 0xFF00) >> 8;
                    }
                    if (this.channels[2]) {
                        n5 += n4 & 0xFF;
                    }
                    byArray[n3 + j] = (byte)(n5 /= this.usedCh);
                }
            }
        }

        public void loadY(int n, byte[] byArray) {
            for (int i = 0; i < VoltexVolume.this.zDim; ++i) {
                int[] nArray = this.fdata[i];
                int n2 = n * VoltexVolume.this.xDim;
                int n3 = i * VoltexVolume.this.xTexSize;
                for (int j = 0; j < VoltexVolume.this.xDim; ++j) {
                    int n4 = nArray[n2 + j];
                    int n5 = 0;
                    if (this.channels[0]) {
                        n5 += (n4 & 0xFF0000) >> 16;
                    }
                    if (this.channels[1]) {
                        n5 += (n4 & 0xFF00) >> 8;
                    }
                    if (this.channels[2]) {
                        n5 += n4 & 0xFF;
                    }
                    byArray[n3 + j] = (byte)(n5 /= this.usedCh);
                }
            }
        }

        public void loadX(int n, byte[] byArray) {
            for (int i = 0; i < VoltexVolume.this.zDim; ++i) {
                int[] nArray = this.fdata[i];
                int n2 = i * VoltexVolume.this.yTexSize;
                for (int j = 0; j < VoltexVolume.this.yDim; ++j) {
                    int n3 = j * VoltexVolume.this.xDim + n;
                    int n4 = nArray[n3];
                    int n5 = 0;
                    if (this.channels[0]) {
                        n5 += (n4 & 0xFF0000) >> 16;
                    }
                    if (this.channels[1]) {
                        n5 += (n4 & 0xFF00) >> 8;
                    }
                    if (this.channels[2]) {
                        n5 += n4 & 0xFF;
                    }
                    byArray[n2 + j] = (byte)(n5 /= this.usedCh);
                }
            }
        }
    }

    private final class IntFromIntLoader
    extends Volume.IntFromIntLoader
    implements Loader {
        IntFromIntLoader(ImagePlus imagePlus, boolean[] blArray) {
            super(VoltexVolume.this, imagePlus, blArray);
            VoltexVolume.access$602(VoltexVolume.this, new byte[VoltexVolume.this.zDim][4 * VoltexVolume.this.xTexSize * VoltexVolume.this.yTexSize]);
            VoltexVolume.access$702(VoltexVolume.this, new byte[VoltexVolume.this.yDim][4 * VoltexVolume.this.xTexSize * VoltexVolume.this.zTexSize]);
            VoltexVolume.access$802(VoltexVolume.this, new byte[VoltexVolume.this.xDim][4 * VoltexVolume.this.yTexSize * VoltexVolume.this.zTexSize]);
        }

        public void setNoCheck(int n, int n2, int n3, int n4) {
            super.setNoCheck(n, n2, n3, n4);
            int n5 = (n4 & 0xFF000000) >> 24;
            int n6 = (n4 & 0xFF0000) >> 16;
            int n7 = (n4 & 0xFF00) >> 8;
            int n8 = n4 & 0xFF;
            int n9 = 4 * (n2 * VoltexVolume.this.xTexSize + n);
            ((VoltexVolume)VoltexVolume.this).xy[n3][n9++] = this.ch[0] ? (byte)n6 : (byte)0;
            ((VoltexVolume)VoltexVolume.this).xy[n3][n9++] = this.ch[1] ? (byte)n7 : (byte)0;
            ((VoltexVolume)VoltexVolume.this).xy[n3][n9++] = this.ch[2] ? (byte)n8 : (byte)0;
            ((VoltexVolume)VoltexVolume.this).xy[n3][n9++] = (byte)n5;
            VoltexVolume.this.xyComp[n3].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, n, n2, 1, 1);
            n9 = 4 * (n3 * VoltexVolume.this.xTexSize + n);
            ((VoltexVolume)VoltexVolume.this).xz[n2][n9++] = this.ch[0] ? (byte)n6 : (byte)0;
            ((VoltexVolume)VoltexVolume.this).xz[n2][n9++] = this.ch[1] ? (byte)n7 : (byte)0;
            ((VoltexVolume)VoltexVolume.this).xz[n2][n9++] = this.ch[2] ? (byte)n8 : (byte)0;
            ((VoltexVolume)VoltexVolume.this).xz[n2][n9++] = (byte)n5;
            VoltexVolume.this.xzComp[n2].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, n, n3, 1, 1);
            n9 = 4 * (n3 * VoltexVolume.this.yTexSize + n2);
            ((VoltexVolume)VoltexVolume.this).yz[n][n9++] = this.ch[0] ? (byte)n6 : (byte)0;
            ((VoltexVolume)VoltexVolume.this).yz[n][n9++] = this.ch[1] ? (byte)n7 : (byte)0;
            ((VoltexVolume)VoltexVolume.this).yz[n][n9++] = this.ch[2] ? (byte)n8 : (byte)0;
            ((VoltexVolume)VoltexVolume.this).yz[n][n9++] = (byte)n5;
            VoltexVolume.this.yzComp[n].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, n2, n3, 1, 1);
        }

        public void set(int n, int n2, int n3, int n4) {
            if (n >= 0 && n < VoltexVolume.this.xDim && n2 >= 0 && n2 < VoltexVolume.this.yDim && n3 >= 0 && n3 < VoltexVolume.this.zDim) {
                this.setNoCheck(n, n2, n3, n4);
            }
        }

        public void loadZ(int n, byte[] byArray) {
            int[] nArray = this.fData[n];
            for (int i = 0; i < VoltexVolume.this.yDim; ++i) {
                int n2 = i * VoltexVolume.this.xDim;
                int n3 = i * VoltexVolume.this.xTexSize * 4;
                for (int j = 0; j < VoltexVolume.this.xDim; ++j) {
                    int n4 = nArray[n2 + j];
                    int n5 = (n4 & 0xFF000000) >> 24;
                    int n6 = (n4 & 0xFF0000) >> 16;
                    int n7 = (n4 & 0xFF00) >> 8;
                    int n8 = n4 & 0xFF;
                    byArray[n3++] = this.ch[0] ? (byte)n6 : (byte)0;
                    byArray[n3++] = this.ch[1] ? (byte)n7 : (byte)0;
                    byArray[n3++] = this.ch[2] ? (byte)n8 : (byte)0;
                    byArray[n3++] = (byte)n5;
                }
            }
        }

        public void loadY(int n, byte[] byArray) {
            for (int i = 0; i < VoltexVolume.this.zDim; ++i) {
                int[] nArray = this.fData[i];
                int n2 = n * VoltexVolume.this.xDim;
                int n3 = i * VoltexVolume.this.xTexSize * 4;
                for (int j = 0; j < VoltexVolume.this.xDim; ++j) {
                    int n4 = nArray[n2 + j];
                    int n5 = (n4 & 0xFF000000) >> 24;
                    int n6 = (n4 & 0xFF0000) >> 16;
                    int n7 = (n4 & 0xFF00) >> 8;
                    int n8 = n4 & 0xFF;
                    byArray[n3++] = this.ch[0] ? (byte)n6 : (byte)0;
                    byArray[n3++] = this.ch[1] ? (byte)n7 : (byte)0;
                    byArray[n3++] = this.ch[2] ? (byte)n8 : (byte)0;
                    byArray[n3++] = (byte)n5;
                }
            }
        }

        public void loadX(int n, byte[] byArray) {
            for (int i = 0; i < VoltexVolume.this.zDim; ++i) {
                int n2 = i * VoltexVolume.this.yTexSize * 4;
                for (int j = 0; j < VoltexVolume.this.yDim; ++j) {
                    int n3 = j * VoltexVolume.this.xDim + n;
                    int n4 = this.fData[i][n3];
                    int n5 = (n4 & 0xFF000000) >> 24;
                    int n6 = (n4 & 0xFF0000) >> 16;
                    int n7 = (n4 & 0xFF00) >> 8;
                    int n8 = n4 & 0xFF;
                    byArray[n2++] = this.ch[0] ? (byte)n6 : (byte)0;
                    byArray[n2++] = this.ch[1] ? (byte)n7 : (byte)0;
                    byArray[n2++] = this.ch[2] ? (byte)n8 : (byte)0;
                    byArray[n2++] = (byte)n5;
                }
            }
        }
    }

    private final class IntLoader
    extends Volume.IntLoader
    implements Loader {
        IntLoader(ImagePlus imagePlus) {
            super(VoltexVolume.this, imagePlus);
            VoltexVolume.access$602(VoltexVolume.this, new byte[VoltexVolume.this.zDim][4 * VoltexVolume.this.xTexSize * VoltexVolume.this.yTexSize]);
            VoltexVolume.access$702(VoltexVolume.this, new byte[VoltexVolume.this.yDim][4 * VoltexVolume.this.xTexSize * VoltexVolume.this.zTexSize]);
            VoltexVolume.access$802(VoltexVolume.this, new byte[VoltexVolume.this.xDim][4 * VoltexVolume.this.yTexSize * VoltexVolume.this.zTexSize]);
        }

        public void setNoCheck(int n, int n2, int n3, int n4) {
            super.setNoCheck(n, n2, n3, n4);
            int n5 = (n4 & 0xFF000000) >> 24;
            int n6 = (n4 & 0xFF0000) >> 16;
            int n7 = (n4 & 0xFF00) >> 8;
            int n8 = n4 & 0xFF;
            int n9 = 4 * (n2 * VoltexVolume.this.xTexSize + n);
            ((VoltexVolume)VoltexVolume.this).xy[n3][n9++] = (byte)n6;
            ((VoltexVolume)VoltexVolume.this).xy[n3][n9++] = (byte)n7;
            ((VoltexVolume)VoltexVolume.this).xy[n3][n9++] = (byte)n8;
            ((VoltexVolume)VoltexVolume.this).xy[n3][n9++] = (byte)n5;
            VoltexVolume.this.xyComp[n3].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, n, n2, 1, 1);
            n9 = 4 * (n3 * VoltexVolume.this.xTexSize + n);
            ((VoltexVolume)VoltexVolume.this).xz[n2][n9++] = (byte)n6;
            ((VoltexVolume)VoltexVolume.this).xz[n2][n9++] = (byte)n7;
            ((VoltexVolume)VoltexVolume.this).xz[n2][n9++] = (byte)n8;
            ((VoltexVolume)VoltexVolume.this).xz[n2][n9++] = (byte)n5;
            VoltexVolume.this.xzComp[n2].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, n, n3, 1, 1);
            n9 = 4 * (n3 * VoltexVolume.this.yTexSize + n2);
            ((VoltexVolume)VoltexVolume.this).yz[n][n9++] = (byte)n6;
            ((VoltexVolume)VoltexVolume.this).yz[n][n9++] = (byte)n7;
            ((VoltexVolume)VoltexVolume.this).yz[n][n9++] = (byte)n8;
            ((VoltexVolume)VoltexVolume.this).yz[n][n9++] = (byte)n5;
            VoltexVolume.this.yzComp[n].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, n2, n3, 1, 1);
        }

        public void set(int n, int n2, int n3, int n4) {
            if (n >= 0 && n < VoltexVolume.this.xDim && n2 >= 0 && n2 < VoltexVolume.this.yDim && n3 >= 0 && n3 < VoltexVolume.this.zDim) {
                this.setNoCheck(n, n2, n3, n4);
            }
        }

        public void loadZ(int n, byte[] byArray) {
            int[] nArray = this.fData[n];
            for (int i = 0; i < VoltexVolume.this.yDim; ++i) {
                int n2 = i * VoltexVolume.this.xDim;
                int n3 = i * VoltexVolume.this.xTexSize * 4;
                for (int j = 0; j < VoltexVolume.this.xDim; ++j) {
                    int n4 = nArray[n2 + j];
                    int n5 = (n4 & 0xFF0000) >> 16;
                    int n6 = (n4 & 0xFF00) >> 8;
                    int n7 = n4 & 0xFF;
                    int n8 = Math.min(255, n5 + n6 + n7);
                    byArray[n3++] = (byte)n5;
                    byArray[n3++] = (byte)n6;
                    byArray[n3++] = (byte)n7;
                    byArray[n3++] = (byte)n8;
                }
            }
        }

        public void loadY(int n, byte[] byArray) {
            for (int i = 0; i < VoltexVolume.this.zDim; ++i) {
                int[] nArray = this.fData[i];
                int n2 = n * VoltexVolume.this.xDim;
                int n3 = i * VoltexVolume.this.xTexSize * 4;
                for (int j = 0; j < VoltexVolume.this.xDim; ++j) {
                    int n4 = nArray[n2 + j];
                    int n5 = (n4 & 0xFF0000) >> 16;
                    int n6 = (n4 & 0xFF00) >> 8;
                    int n7 = n4 & 0xFF;
                    int n8 = Math.min(255, n5 + n6 + n7);
                    byArray[n3++] = (byte)n5;
                    byArray[n3++] = (byte)n6;
                    byArray[n3++] = (byte)n7;
                    byArray[n3++] = (byte)n8;
                }
            }
        }

        public void loadX(int n, byte[] byArray) {
            for (int i = 0; i < VoltexVolume.this.zDim; ++i) {
                int n2 = i * VoltexVolume.this.yTexSize * 4;
                for (int j = 0; j < VoltexVolume.this.yDim; ++j) {
                    int n3 = j * VoltexVolume.this.xDim + n;
                    int n4 = this.fData[i][n3];
                    int n5 = (n4 & 0xFF0000) >> 16;
                    int n6 = (n4 & 0xFF00) >> 8;
                    int n7 = n4 & 0xFF;
                    int n8 = Math.min(255, n5 + n6 + n7);
                    byArray[n2++] = (byte)n5;
                    byArray[n2++] = (byte)n6;
                    byArray[n2++] = (byte)n7;
                    byArray[n2++] = (byte)n8;
                }
            }
        }
    }

    private final class ByteLoader
    extends Volume.ByteLoader
    implements Loader {
        ByteLoader(ImagePlus imagePlus) {
            super(VoltexVolume.this, imagePlus);
            VoltexVolume.access$602(VoltexVolume.this, new byte[VoltexVolume.this.zDim][VoltexVolume.this.xTexSize * VoltexVolume.this.yTexSize]);
            VoltexVolume.access$702(VoltexVolume.this, new byte[VoltexVolume.this.yDim][VoltexVolume.this.xTexSize * VoltexVolume.this.zTexSize]);
            VoltexVolume.access$802(VoltexVolume.this, new byte[VoltexVolume.this.xDim][VoltexVolume.this.yTexSize * VoltexVolume.this.zTexSize]);
        }

        public void setNoCheck(int n, int n2, int n3, int n4) {
            super.setNoCheck(n, n2, n3, n4);
            ((VoltexVolume)VoltexVolume.this).xy[n3][n2 * VoltexVolume.this.xTexSize + n] = (byte)n4;
            ((VoltexVolume)VoltexVolume.this).xz[n2][n3 * VoltexVolume.this.xTexSize + n] = (byte)n4;
            ((VoltexVolume)VoltexVolume.this).yz[n][n3 * VoltexVolume.this.yTexSize + n2] = (byte)n4;
            VoltexVolume.this.xyComp[n3].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, n, n2, 1, 1);
            VoltexVolume.this.xzComp[n2].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, n, n3, 1, 1);
            VoltexVolume.this.yzComp[n].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, n2, n3, 1, 1);
        }

        public void set(int n, int n2, int n3, int n4) {
            if (n >= 0 && n < VoltexVolume.this.xDim && n2 >= 0 && n2 < VoltexVolume.this.yDim && n3 >= 0 && n3 < VoltexVolume.this.zDim) {
                this.setNoCheck(n, n2, n3, n4);
            }
        }

        public void loadZ(int n, byte[] byArray) {
            byte[] byArray2 = this.fData[n];
            for (int i = 0; i < VoltexVolume.this.yDim; ++i) {
                int n2 = i * VoltexVolume.this.xDim;
                int n3 = i * VoltexVolume.this.xTexSize;
                System.arraycopy(byArray2, n2, byArray, n3, VoltexVolume.this.xDim);
            }
        }

        public void loadY(int n, byte[] byArray) {
            for (int i = 0; i < VoltexVolume.this.zDim; ++i) {
                byte[] byArray2 = this.fData[i];
                int n2 = n * VoltexVolume.this.xDim;
                int n3 = i * VoltexVolume.this.xTexSize;
                System.arraycopy(byArray2, n2, byArray, n3, VoltexVolume.this.xDim);
            }
        }

        public void loadX(int n, byte[] byArray) {
            for (int i = 0; i < VoltexVolume.this.zDim; ++i) {
                int n2 = i * VoltexVolume.this.yTexSize;
                for (int j = 0; j < VoltexVolume.this.yDim; ++j) {
                    int n3 = j * VoltexVolume.this.xDim + n;
                    byArray[n2 + j] = this.fData[i][n3];
                }
            }
        }
    }

    protected static interface Loader
    extends Volume.Loader {
        public void loadZ(int var1, byte[] var2);

        public void loadY(int var1, byte[] var2);

        public void loadX(int var1, byte[] var2);
    }

    private final class ColorComponentCreator
    extends ComponentCreator {
        private ColorComponentCreator() {
        }

        ImageComponent2D createImageComponent(byte[] byArray, int n, int n2) {
            int[] nArray = new int[]{0, 1, 2, 3};
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, n * n2 * 4, 0);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 4, 4, nArray, null);
            BufferedImage bufferedImage = new BufferedImage(rgbCM, writableRaster, false, null);
            ImageComponent2D imageComponent2D = new ImageComponent2D(2, n, n2, true, true);
            imageComponent2D.setCapability(3);
            imageComponent2D.set(bufferedImage);
            return imageComponent2D;
        }
    }

    private final class GreyComponentCreator
    extends ComponentCreator {
        private GreyComponentCreator() {
        }

        ImageComponent2D createImageComponent(byte[] byArray, int n, int n2) {
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, n * n2, 0);
            SampleModel sampleModel = greyCM.createCompatibleSampleModel(n, n2);
            WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferByte, null);
            BufferedImage bufferedImage = new BufferedImage(greyCM, writableRaster, false, null);
            ImageComponent2D imageComponent2D = new ImageComponent2D(10, n, n2, true, true);
            imageComponent2D.setCapability(3);
            imageComponent2D.set(bufferedImage);
            return imageComponent2D;
        }
    }

    private abstract class ComponentCreator {
        ComponentCreator() {
            VoltexVolume.access$302(VoltexVolume.this, new ImageComponent2D[VoltexVolume.this.zDim]);
            VoltexVolume.access$402(VoltexVolume.this, new ImageComponent2D[VoltexVolume.this.yDim]);
            VoltexVolume.access$502(VoltexVolume.this, new ImageComponent2D[VoltexVolume.this.xDim]);
        }

        abstract ImageComponent2D createImageComponent(byte[] var1, int var2, int var3);
    }

    private class ImageUpdater
    implements ImageComponent2D.Updater {
        private ImageUpdater() {
        }

        public void updateData(ImageComponent2D imageComponent2D, int n, int n2, int n3, int n4) {
        }
    }
}

