/*
 * Decompiled with CFR 0.152.
 */
package voltex;

import ij.IJ;
import ij.ImagePlus;
import ij3d.AxisConstants;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import voltex.AppearanceCreator;
import voltex.GeometryCreator;
import voltex.VoltexVolume;

public class VolumeRenderer
implements AxisConstants {
    protected final VoltexVolume volume;
    protected final BranchGroup root;
    protected final AppearanceCreator appCreator;
    protected final GeometryCreator geomCreator;
    protected final Switch axisSwitch;
    protected final int[][] axisIndex = new int[3][2];
    private int curAxis = 2;
    private int curDir = 0;
    private Vector3d eyeVec = new Vector3d();
    private static Transform3D parentInv = new Transform3D();
    private static Point3d viewPosition = new Point3d();
    private static Transform3D t = new Transform3D();

    public VolumeRenderer(ImagePlus imagePlus, Color3f color3f, float f, boolean[] blArray) {
        this.volume = new VoltexVolume(imagePlus);
        this.volume.setChannels(blArray);
        this.appCreator = new AppearanceCreator(this.volume, color3f, f);
        this.geomCreator = new GeometryCreator(this.volume);
        this.axisIndex[0][0] = 0;
        this.axisIndex[0][1] = 1;
        this.axisIndex[1][0] = 2;
        this.axisIndex[1][1] = 3;
        this.axisIndex[2][0] = 4;
        this.axisIndex[2][1] = 5;
        this.axisSwitch = new Switch();
        this.axisSwitch.setCapability(17);
        this.axisSwitch.setCapability(18);
        this.axisSwitch.setCapability(12);
        this.axisSwitch.setCapability(13);
        for (int i = 0; i < 6; ++i) {
            this.axisSwitch.addChild((Node)this.getOrderedGroup());
        }
        this.root = new BranchGroup();
        this.root.addChild((Node)this.axisSwitch);
        this.root.setCapability(17);
        this.root.setCapability(11);
    }

    public BranchGroup getVolumeNode() {
        return this.root;
    }

    public VoltexVolume getVolume() {
        return this.volume;
    }

    public void eyePtChanged(View view) {
        Point3d point3d = VolumeRenderer.getViewPosInLocal(view, (Node)this.root);
        if (point3d != null) {
            int n;
            Point3d point3d2 = this.volume.volRefPt;
            this.eyeVec.sub((Tuple3d)point3d, (Tuple3d)point3d2);
            this.eyeVec.x /= this.volume.pw;
            this.eyeVec.y /= this.volume.ph;
            this.eyeVec.z /= this.volume.pd;
            int n2 = 0;
            double d = this.eyeVec.x;
            double d2 = Math.abs(this.eyeVec.x);
            if (Math.abs(this.eyeVec.y) > d2) {
                n2 = 1;
                d = this.eyeVec.y;
                d2 = Math.abs(this.eyeVec.y);
            }
            if (Math.abs(this.eyeVec.z) > d2) {
                n2 = 2;
                d = this.eyeVec.z;
                d2 = Math.abs(this.eyeVec.z);
            }
            int n3 = n = d > 0.0 ? 0 : 1;
            if (n2 != this.curAxis || n != this.curDir) {
                this.curAxis = n2;
                this.curDir = n;
                this.axisSwitch.setWhichChild(this.axisIndex[this.curAxis][this.curDir]);
            }
        }
    }

    public void fullReload() {
        for (int i = 0; i < this.axisSwitch.numChildren(); ++i) {
            ((Group)this.axisSwitch.getChild(i)).removeAllChildren();
        }
        this.loadAxis(2);
        this.loadAxis(1);
        this.loadAxis(0);
        this.axisSwitch.setWhichChild(this.axisIndex[this.curAxis][this.curDir]);
    }

    public void setThreshold(int n) {
        float f = (float)n / 255.0f;
        f = Math.min(1.0f, f);
        f = Math.max(0.1f, f);
        this.appCreator.setThreshold(f);
    }

    public void setTransparency(float f) {
        this.appCreator.setTransparency(f);
    }

    public void setChannels(boolean[] blArray) {
        if (this.volume.setChannels(blArray)) {
            this.fullReload();
        }
    }

    public void setColor(Color3f color3f) {
        if (this.volume.setAverage(color3f != null)) {
            this.fullReload();
        }
        Color3f color3f2 = color3f != null ? color3f : new Color3f(1.0f, 1.0f, 1.0f);
        this.appCreator.setColor(color3f2);
    }

    protected void loadAxis(int n) {
        int n2 = 0;
        Group group = null;
        Group group2 = null;
        group = (Group)this.axisSwitch.getChild(this.axisIndex[n][0]);
        group2 = (Group)this.axisSwitch.getChild(this.axisIndex[n][1]);
        String string = "Loading ";
        switch (n) {
            case 2: {
                n2 = this.volume.zDim;
                string = string + "x axis";
                break;
            }
            case 1: {
                n2 = this.volume.yDim;
                string = string + "y axis";
                break;
            }
            case 0: {
                n2 = this.volume.xDim;
                string = string + "z axis";
            }
        }
        IJ.showStatus((String)string);
        for (int i = 0; i < n2; ++i) {
            IJ.showProgress((int)(i + 1), (int)n2);
            this.loadAxis(n, i, group, group2);
        }
    }

    protected void loadAxis(int n, int n2, Group group, Group group2) {
        GeometryArray geometryArray = this.geomCreator.getQuad(n, n2);
        Appearance appearance = this.appCreator.getAppearance(n, n2);
        Shape3D shape3D = new Shape3D((Geometry)geometryArray, appearance);
        shape3D.setCapability(14);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(12);
        branchGroup.addChild((Node)shape3D);
        group.addChild((Node)branchGroup);
        Shape3D shape3D2 = new Shape3D((Geometry)geometryArray, appearance);
        shape3D2.setCapability(14);
        BranchGroup branchGroup2 = new BranchGroup();
        branchGroup2.setCapability(17);
        branchGroup2.setCapability(12);
        branchGroup2.addChild((Node)shape3D2);
        group2.insertChild((Node)branchGroup2, 0);
    }

    private static Point3d getViewPosInLocal(View view, Node node) {
        if (node == null) {
            return null;
        }
        if (!node.isLive()) {
            return null;
        }
        Canvas3D canvas3D = view.getCanvas3D(0);
        canvas3D.getCenterEyeInImagePlate(viewPosition);
        canvas3D.getImagePlateToVworld(t);
        t.transform(viewPosition);
        node.getLocalToVworld(parentInv);
        parentInv.invert();
        parentInv.transform(viewPosition);
        return viewPosition;
    }

    private Group getOrderedGroup() {
        OrderedGroup orderedGroup = new OrderedGroup();
        orderedGroup.setCapability(12);
        orderedGroup.setCapability(13);
        orderedGroup.setCapability(14);
        return orderedGroup;
    }
}

